/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.alarm;

import com.hs.atic.collector.entity.event.ToSysLog;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.ZoneUitl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AbnormalAlarmEntity
implements Serializable,
ToSysLog {
    private static final long serialVersionUID = 5007590026699684013L;
    private static final String[] DEVICE_TYPE = new String[]{"CLEAN", "DETECT"};
    private long pkId;
    private String deviceIp = "";
    private int direction = 1;
    private int deviceType;
    private long zoneId;
    private long locationId = 0L;
    private String zoneIp = "";
    private long startTime = 0L;
    private long endTime = 0L;
    private int alertTypeValue;
    private int protocol;
    private int port;
    private boolean alarm;
    private long limitValue = 0L;
    private long currentValue = 0L;
    private int ppsOrKbps = 0;
    private long limitValue1 = 0L;
    private long currentValue1 = 0L;
    private int ppsOrKbps1 = 0;
    private boolean multiCurrent = false;
    private long dropPacket = 0L;
    private long dropKbits = 0L;
    private boolean newAlarm = true;
    private String attacker = "";
    private String attackerPpsFlow = "";
    private String attackerKbpsFlow = "";
    private long dropPps;
    private long dropKbps;
    private long ipInPeakKbps;
    private long ipInPeakPps;
    private long ipAttackPeakKbps;
    private long ipAttackPeakPps;
    private long tcpNewConnNum;
    private long tcpCurConnNum;
    private String ports;
    private long currMaxDropPps;
    private long currMaxDropKbps;

    public boolean isNewAlarm() {
        return this.newAlarm;
    }

    public void setNewAlarm(boolean newAlarm) {
        this.newAlarm = newAlarm;
    }

    public int getPpsOrKbps() {
        return this.ppsOrKbps;
    }

    public void setPpsOrKbps(int ppsOrKbps) {
        this.ppsOrKbps = ppsOrKbps;
    }

    public long getLimitValue() {
        return this.limitValue;
    }

    public void setLimitValue(long limitValue) {
        this.limitValue = limitValue;
    }

    public long getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(long currentValue) {
        this.currentValue = currentValue;
    }

    public boolean isAlarm() {
        return this.alarm;
    }

    public void setAlarm(boolean isAlarm) {
        this.alarm = isAlarm;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public int getAlertTypeValue() {
        return this.alertTypeValue;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public int getPort() {
        return this.port;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getZoneIp() {
        return this.zoneIp;
    }

    public void setAlertTypeValue(int alertTypeValue) {
        this.alertTypeValue = alertTypeValue;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public void setZoneId(long zoneId) {
        this.zoneId = zoneId;
    }

    public void setZoneIp(String zoneIp) {
        this.zoneIp = zoneIp;
    }

    public long getDropKbits() {
        return this.dropKbits;
    }

    public void setDropKbits(long dropKbits) {
        this.dropKbits = dropKbits;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("deviceIp=").append(this.deviceIp);
        buffer.append(", direction=").append(this.direction);
        buffer.append(", deviceType=").append(this.deviceType);
        buffer.append(", zoneId=").append(this.zoneId);
        buffer.append(", zoneIp=").append(this.zoneIp);
        buffer.append(", attackType=").append(this.alertTypeValue);
        buffer.append(", alarm=").append(this.alarm);
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof AbnormalAlarmEntity) {
            AbnormalAlarmEntity entry = (AbnormalAlarmEntity)o;
            return entry.getAlertTypeValue() == this.alertTypeValue && entry.getDeviceIp().equals(this.deviceIp) && entry.getDirection() == this.direction && entry.getDeviceType() == this.deviceType && entry.getZoneIp().equals(this.zoneIp) && entry.getZoneId() == this.zoneId;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result += 19 * this.zoneIp.hashCode();
        result += 19 * this.deviceIp.hashCode();
        result += 19 * this.direction;
        result += 19 * this.deviceType;
        result += 19 * this.alertTypeValue;
        return result += 19 * (int)(this.zoneId ^ this.zoneId >>> 16);
    }

    public long getLimitValue1() {
        return this.limitValue1;
    }

    public void setLimitValue1(long limitValue1) {
        this.limitValue1 = limitValue1;
    }

    public long getCurrentValue1() {
        return this.currentValue1;
    }

    public void setCurrentValue1(long currentValue1) {
        this.currentValue1 = currentValue1;
    }

    public int getPpsOrKbps1() {
        return this.ppsOrKbps1;
    }

    public void setPpsOrKbps1(int ppsOrKbps1) {
        this.ppsOrKbps1 = ppsOrKbps1;
    }

    public boolean isMultiCurrent() {
        return this.multiCurrent;
    }

    public void setMultiCurrent(boolean isMultiCurrent) {
        this.multiCurrent = isMultiCurrent;
    }

    public long getPkId() {
        return this.pkId;
    }

    public void setPkId(long pkId) {
        this.pkId = pkId;
    }

    public long getDropPacket() {
        return this.dropPacket;
    }

    public void setDropPacket(long dropPacket) {
        this.dropPacket = dropPacket;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public String getHostName() {
        return this.deviceIp;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    @Override
    public List<String> getSysLogInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("log_type=ip_attack");
        info.add("device_ip=" + this.deviceIp);
        info.add("device_type=" + DEVICE_TYPE[this.deviceType]);
        info.add("direction=" + CommonUtil.getDirectionStr(this.getDirection()));
        info.add("zone_id=" + this.zoneId);
        info.add("zone_name=" + ZoneUitl.getInstance().getZoneNameById(this.zoneId));
        info.add("zone_ip=" + this.zoneIp);
        info.add("start_time_alert=\"" + EventUtil.getTimeStamp(this.startTime) + "\"");
        String attackTime = "";
        if (this.dropPacket > 0L || this.dropKbits > 0L) {
            attackTime = EventUtil.getTimeStamp(this.startTime);
        }
        info.add("start_time_attack=\"" + attackTime + "\"");
        if (this.alarm) {
            info.add("end_time=\"\"");
        } else {
            info.add("end_time=\"" + EventUtil.getTimeStamp(this.endTime) + "\"");
        }
        info.add("duration=" + (this.endTime - this.startTime) / 1000L);
        info.add("attack_type=" + this.alertTypeValue);
        info.add("protocol=" + this.protocol);
        info.add("port=" + this.port);
        info.add("attack_status=" + this.getStateDescription());
        info.add("drop_packets=" + this.dropPacket);
        info.add("drop_kbits=" + this.dropKbits);
        info.add("attacker=" + this.attacker);
        info.add("attacker_pps=" + this.attackerPpsFlow);
        info.add("attacker_kbps=" + this.attackerKbpsFlow);
        if (this.alertTypeValue == 40 || this.alertTypeValue == 14 || this.alertTypeValue == 15) {
            info.add("current_attack_flow=" + this.currentValue + "/" + this.currentValue1);
            info.add("limit_attack_value=" + this.limitValue + "/" + this.limitValue1);
            info.add("attack_unit=" + this.getUnit(this.ppsOrKbps));
        } else if (this.currentValue > this.limitValue) {
            info.add("current_attack_flow=" + this.currentValue);
            info.add("limit_attack_value=" + this.limitValue);
            info.add("attack_unit=" + this.getUnit(this.ppsOrKbps));
        } else {
            info.add("current_attack_flow=" + this.currentValue1);
            info.add("limit_attack_value=" + this.limitValue1);
            info.add("attack_unit=" + this.getUnit(this.ppsOrKbps1));
        }
        info.add("max_drop_kbps=" + this.currMaxDropKbps);
        info.add("max_drop_pps=" + this.currMaxDropPps);
        return info;
    }

    private String getUnit(int unit) {
        switch (unit) {
            case 0: {
                return "\"pps\"";
            }
            case 1: {
                return "\"kbps\"";
            }
            case 2: {
                return "\"qps\"";
            }
            case 3: {
                return "\"connections/commections per second\"";
            }
            case 4: {
                return "\"connections/commections per second\"";
            }
            case 5: {
                return "\"\u2030\"";
            }
        }
        return "";
    }

    private String getStateDescription() {
        if (this.alarm) {
            if (this.dropPacket > 0L) {
                return "ATTACK";
            }
            return "ALERT";
        }
        return "NORMAL";
    }

    @Override
    public long getTime() {
        return this.startTime;
    }

    public void setAttacker(String attacker) {
        this.attacker = attacker;
    }

    public String getAttacker() {
        return this.attacker;
    }

    public long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(long locationId) {
        this.locationId = locationId;
    }

    public String getAttackerPpsFlow() {
        return this.attackerPpsFlow;
    }

    public void setAttackerPpsFlow(String attackerPpsFlow) {
        this.attackerPpsFlow = attackerPpsFlow;
    }

    public String getAttackerKbpsFlow() {
        return this.attackerKbpsFlow;
    }

    public void setAttackerKbpsFlow(String attackerKbpsFlow) {
        this.attackerKbpsFlow = attackerKbpsFlow;
    }

    public long getDropPps() {
        return this.dropPps;
    }

    public void setDropPps(long dropPps) {
        this.dropPps = dropPps;
    }

    public long getDropKbps() {
        return this.dropKbps;
    }

    public void setDropKbps(long dropKbps) {
        this.dropKbps = dropKbps;
    }

    public long getIpInPeakKbps() {
        return this.ipInPeakKbps;
    }

    public void setIpInPeakKbps(long ipInPeakKbps) {
        this.ipInPeakKbps = ipInPeakKbps;
    }

    public long getIpInPeakPps() {
        return this.ipInPeakPps;
    }

    public void setIpInPeakPps(long ipInPeakPps) {
        this.ipInPeakPps = ipInPeakPps;
    }

    public long getIpAttackPeakKbps() {
        return this.ipAttackPeakKbps;
    }

    public void setIpAttackPeakKbps(long ipAttackPeakKbps) {
        this.ipAttackPeakKbps = ipAttackPeakKbps;
    }

    public long getIpAttackPeakPps() {
        return this.ipAttackPeakPps;
    }

    public void setIpAttackPeakPps(long ipAttackPeakPps) {
        this.ipAttackPeakPps = ipAttackPeakPps;
    }

    public long getTcpNewConnNum() {
        return this.tcpNewConnNum;
    }

    public void setTcpNewConnNum(long tcpNewConnNum) {
        this.tcpNewConnNum = tcpNewConnNum;
    }

    public long getTcpCurConnNum() {
        return this.tcpCurConnNum;
    }

    public void setTcpCurConnNum(long tcpCurConnNum) {
        this.tcpCurConnNum = tcpCurConnNum;
    }

    public String getPorts() {
        return this.ports;
    }

    public void setPorts(String ports) {
        this.ports = ports;
    }

    public long getCurrMaxDropPps() {
        return this.currMaxDropPps;
    }

    public void setCurrMaxDropPps(long currMaxDropPps) {
        this.currMaxDropPps = currMaxDropPps;
    }

    public long getCurrMaxDropKbps() {
        return this.currMaxDropKbps;
    }

    public void setCurrMaxDropKbps(long currMaxDropKbps) {
        this.currMaxDropKbps = currMaxDropKbps;
    }
}

