/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.nfa.NfaAttackSrcFlow;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public abstract class AbnormalEvent
extends Event {
    public static final int ATTACKERS_SIZE = 100;
    public static final int PORTS_SIZE = 5;
    public static final int NORMAL = 0;
    public static final int ALERT = 1;
    public static final int ATTACK = 2;
    protected Set<String> attackers = new HashSet<String>();
    protected Set<Integer> ports = new HashSet<Integer>();
    protected List<NfaAttackSrcFlow> attackerFlowData = new ArrayList<NfaAttackSrcFlow>();
    private long abnormalPkId = -1L;
    private long alertStartTime = 0L;
    private long alertEndTime = 0L;
    private long attackStartTime = 0L;
    private long attackEndTime = 0L;
    private long attackCount;
    private int currentState;
    private long dropPacket = 0L;
    private long dropKbits = 0L;
    private boolean isEverAlerted;
    private boolean isEverAttacked;
    private boolean isStateChanged;
    private int oldState;
    private long attackPeakKbps = 0L;
    private long attackPeakPpsOrQps = 0L;
    private long ipInPeakKbps = 0L;
    private long ipInPeakPps = 0L;
    private long ipAttackPeakKbps = 0L;
    private long ipAttackPeakPps = 0L;
    private long tcpNewConnNum;
    private long tcpCurConnNum;
    private int portData;

    public AbnormalEvent(EventIdentifier identifer) {
        super(identifer);
    }

    public void copy(AbnormalEvent copy) {
        copy.setAbnormalPkId(this.getAbnormalPkId());
        copy.setCurrentState(this.getCurrentState());
        copy.setOldState(this.getOldState());
        copy.setAttackers(this.getAttackers());
        copy.setPorts(this.getPorts());
        copy.setAttackCount(this.getAttackCount());
        copy.setAttackStartTime(this.getAttackStartTime());
        copy.setAttackEndTime(this.getAttackEndTime());
        copy.setAlertStartTime(this.getAlertStartTime());
        copy.setAlertEndTime(this.getAlertEndTime());
        copy.setEverAlerted(this.isIsEverAlerted());
        copy.setStateChanged(this.isIsStateChanged());
    }

    public static String getStateDescription(int state) {
        if (state == 0) {
            return "NORMAL";
        }
        if (state == 2) {
            return "ATTACK";
        }
        if (state == 1) {
            return "ALERT";
        }
        return "NONE";
    }

    @Override
    public void average(int number) {
    }

    public long getAlertEndTime() {
        if (this.alertEndTime == this.alertStartTime && !this.isNormal()) {
            this.alertEndTime = this.alertStartTime + 5000L;
        }
        return this.alertEndTime;
    }

    public void updateTime(AbnormalEvent event) {
        if (this.isEverAlerted) {
            this.alertStartTime = this.alertStartTime < event.getAlertStartTime() ? this.alertStartTime : event.getAlertStartTime();
            this.alertEndTime = this.alertEndTime > event.getAlertEndTime() ? this.alertEndTime : event.getAlertEndTime();
        } else {
            this.setAlertStartTime(event.getAlertStartTime());
            this.setAlertEndTime(event.getAlertEndTime());
            this.isEverAlerted = true;
        }
        if (event.isAttack()) {
            if (this.isIsEverAttacked()) {
                this.attackStartTime = this.attackStartTime < event.getAttackStartTime() ? this.attackStartTime : event.getAttackStartTime();
                this.attackEndTime = this.attackEndTime > event.getAttackEndTime() ? this.attackEndTime : event.getAttackEndTime();
            } else {
                this.setAttackStartTime(event.getAttackStartTime());
                this.setAttackEndTime(event.getAttackEndTime());
            }
        }
    }

    public long getAttackEndTime() {
        if (this.isEverAttacked && this.attackEndTime == this.attackStartTime) {
            this.attackEndTime = this.attackStartTime + 5000L;
        }
        return this.attackEndTime;
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            AbnormalEvent abnormal = (AbnormalEvent)event;
            this.dropPacket += abnormal.getDropPkgs();
            this.dropKbits += abnormal.getDropKbits();
            this.setPortData(abnormal.getPortData());
            this.addPort(abnormal.getPortData());
            this.setIpAttackPeakKbps(this.queryMaxValue(this.getIpAttackPeakKbps(), abnormal.getIpAttackPeakKbps()));
            this.setIpAttackPeakPps(this.queryMaxValue(this.getIpAttackPeakPps(), abnormal.getIpAttackPeakPps()));
            this.setIpInPeakKbps(this.queryMaxValue(this.getIpInPeakKbps(), abnormal.getIpInPeakKbps()));
            this.setIpInPeakPps(this.queryMaxValue(this.getIpInPeakPps(), abnormal.getIpInPeakPps()));
            this.setTcpCurConnNum(this.queryMaxValue(this.getTcpCurConnNum(), abnormal.getTcpCurConnNum()));
            this.setTcpNewConnNum(this.queryMaxValue(this.getTcpNewConnNum(), abnormal.getTcpNewConnNum()));
            this.setAttackPeakKbps(this.queryMaxValue(this.getAttackPeakKbps(), abnormal.getAttackPeakKbps()));
            this.setAttackPeakPpsOrQps(this.queryMaxValue(this.getAttackPeakPpsOrQps(), abnormal.getAttackPeakPpsOrQps()));
            this.updateTime(abnormal);
            if (!this.isNormal() && abnormal.getCurrentState() > this.getCurrentState()) {
                this.setCurrentState(abnormal.getCurrentState());
            }
            if (!abnormal.isNormal()) continue;
            this.setCurrentState(0);
        }
    }

    public void setCurrentState(int currentState) {
        if (this.currentState == currentState) {
            this.isStateChanged = false;
        } else {
            this.oldState = this.currentState;
            this.currentState = currentState;
            this.isStateChanged = true;
        }
        if (currentState == 2) {
            this.setEverAttacked(true);
        }
        if (currentState == 1) {
            this.setEverAlerted(true);
        }
    }

    public long getDuration() {
        long duration = (this.getAlertEndTime() > this.getAttackEndTime() ? this.getAlertEndTime() : this.getAttackEndTime()) / 1000L - this.getAlertStartTime() / 1000L;
        return duration;
    }

    public synchronized Set<String> getAttackers() {
        HashSet<String> copy = new HashSet<String>();
        copy.addAll(this.attackers);
        return copy;
    }

    public synchronized void addAttackers(Set<String> attackerss) {
        for (String attacker : attackerss) {
            this.addAttacker(attacker);
        }
    }

    public synchronized void addAttacker(String attacker) {
        if (this.attackers.size() < 100) {
            this.attackers.add(attacker);
        }
    }

    public synchronized void addAttackerFlowData(List<NfaAttackSrcFlow> attackerFlowList) {
        for (NfaAttackSrcFlow nfaAttackSrcFlow : attackerFlowList) {
            this.addAttackerFlow(nfaAttackSrcFlow);
        }
    }

    public synchronized void addAttackerFlow(NfaAttackSrcFlow nfaAttackSrcFlow) {
        if (this.attackerFlowData.size() < 100) {
            this.attackerFlowData.add(nfaAttackSrcFlow);
        }
    }

    public synchronized void setAttackers(Set<String> attackers) {
        this.attackers.clear();
        this.addAttackers(attackers);
    }

    public synchronized List<NfaAttackSrcFlow> getAttackerFlowData() {
        return this.attackerFlowData;
    }

    public synchronized void setAttackerFlowData(List<NfaAttackSrcFlow> attackerFlowData) {
        this.attackerFlowData = attackerFlowData;
    }

    public synchronized void addPorts(Set<Integer> portsSet) {
        for (Integer port : portsSet) {
            this.addPort(port);
        }
    }

    public synchronized void addPort(Integer port) {
        if (this.ports.size() < 5) {
            this.ports.add(port);
        }
    }

    public synchronized Set<Integer> getPorts() {
        HashSet<Integer> copy = new HashSet<Integer>();
        copy.addAll(this.ports);
        return copy;
    }

    public synchronized void setPorts(Set<Integer> ports) {
        this.ports.clear();
        this.addPorts(ports);
    }

    public long getAttackStartTime() {
        return this.attackStartTime;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public long getDropPkgs() {
        return this.dropPacket;
    }

    public long getDropKbits() {
        return this.dropKbits;
    }

    public void setDropKbits(long dropKbits) {
        this.dropKbits = dropKbits;
    }

    public int getOldState() {
        return this.oldState;
    }

    public long getAbnormalPkId() {
        return this.abnormalPkId;
    }

    @Override
    public List<String> getSysLogInfo() {
        return new ArrayList<String>();
    }

    public boolean isAlert() {
        return this.currentState == 1;
    }

    public boolean isAttack() {
        return this.currentState == 2;
    }

    public boolean isIsEverAlerted() {
        return this.isEverAlerted;
    }

    public boolean isIsEverAttacked() {
        return this.isEverAttacked;
    }

    public boolean isNormal() {
        return this.currentState == 0;
    }

    public boolean isSaved() {
        return this.abnormalPkId != -1L;
    }

    public boolean isIsStateChanged() {
        return this.isStateChanged;
    }

    public void setAlertEndTime(long endTime) {
        this.alertEndTime = endTime;
    }

    public void setAlertStartTime(long startTime) {
        this.alertStartTime = startTime;
    }

    public void setAttackCount(long attackCount) {
        this.attackCount = attackCount;
    }

    public void setAttackStartTime(long attackStartTime) {
        this.attackStartTime = attackStartTime;
    }

    public void setDropPkgs(long dropPackets) {
        this.dropPacket = dropPackets;
    }

    public void setEverAlerted(boolean isEverAlerte) {
        this.isEverAlerted = isEverAlerte;
    }

    public void setEverAttacked(boolean isEverAttack) {
        this.isEverAttacked = isEverAttack;
    }

    public void setOldState(int oldState) {
        this.oldState = oldState;
    }

    public void setAbnormalPkId(long pkId) {
        this.abnormalPkId = pkId;
    }

    public void setStateChanged(boolean isStateChange) {
        this.isStateChanged = isStateChange;
    }

    public long getAlertStartTime() {
        return this.alertStartTime;
    }

    public long getAttackCount() {
        return this.attackCount;
    }

    public void setAttackEndTime(long attackEndTime) {
        this.attackEndTime = attackEndTime;
    }

    public long getAttackPeakKbps() {
        return this.attackPeakKbps;
    }

    public void setAttackPeakKbps(long attackPeakKbps) {
        this.attackPeakKbps = attackPeakKbps;
    }

    public long getAttackPeakPpsOrQps() {
        return this.attackPeakPpsOrQps;
    }

    public void setAttackPeakPpsOrQps(long attackPeakPpsOrQps) {
        this.attackPeakPpsOrQps = attackPeakPpsOrQps;
    }

    public long getIpInPeakKbps() {
        return this.ipInPeakKbps;
    }

    public void setIpInPeakKbps(long ipInPeakKbps) {
        this.ipInPeakKbps = ipInPeakKbps;
    }

    public long getIpInPeakPps() {
        return this.ipInPeakPps;
    }

    public void setIpInPeakPps(long ipInPeakPps) {
        this.ipInPeakPps = ipInPeakPps;
    }

    public long getIpAttackPeakKbps() {
        return this.ipAttackPeakKbps;
    }

    public void setIpAttackPeakKbps(long ipAttackPeakKbps) {
        this.ipAttackPeakKbps = ipAttackPeakKbps;
    }

    public long getIpAttackPeakPps() {
        return this.ipAttackPeakPps;
    }

    public void setIpAttackPeakPps(long ipAttackPeakPps) {
        this.ipAttackPeakPps = ipAttackPeakPps;
    }

    public long getTcpNewConnNum() {
        return this.tcpNewConnNum;
    }

    public void setTcpNewConnNum(long tcpNewConnNum) {
        this.tcpNewConnNum = tcpNewConnNum;
    }

    public long getTcpCurConnNum() {
        return this.tcpCurConnNum;
    }

    public void setTcpCurConnNum(long tcpCurConnNum) {
        this.tcpCurConnNum = tcpCurConnNum;
    }

    public long queryMaxValue(long num1, long num2) {
        if (num1 >= num2) {
            return num1;
        }
        return num2;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("isEverAttacked", this.isEverAttacked).append("isEverAlerted", this.isEverAlerted).append("dropKbits", this.dropKbits).append("dropPackets", this.dropPacket).append("startTime", (Object)new Date(this.alertStartTime)).append("endTime", (Object)new Date(this.alertEndTime)).append("attackStartTime", (Object)new Date(this.attackStartTime)).append("attackEndTime", (Object)new Date(this.attackEndTime)).append("currentSate", (Object)AbnormalEvent.getStateDescription(this.currentState)).append("oldState", (Object)AbnormalEvent.getStateDescription(this.oldState)).append("isStateChanged", this.isStateChanged).append("attackCount", this.attackCount).append("duaration", this.getDuration()).append("pkid", this.abnormalPkId).append("attackers", (Object)this.attackers.toString()).append("ports", (Object)this.ports.toString()).append("ipAttackPeakKbps", this.ipAttackPeakKbps).append("ipAttackPeakPps", this.ipAttackPeakPps).append("ipInPeakKbps", this.ipInPeakKbps).append("ipInPeakPps", this.ipInPeakPps).append("attackPeakKbps", this.attackPeakKbps).append("attackPeakPpsOrQps", this.attackPeakPpsOrQps).toString();
    }

    public int getPortData() {
        return this.portData;
    }

    public void setPortData(int portData) {
        this.portData = portData;
    }
}

