/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class AttackTypeEvent
extends Event {
    public static final int PORTS_SIZE = 5;
    protected Set<Integer> ports = new HashSet<Integer>();
    private AttackType attackType;
    private long dropPackets;
    private long dropPps;
    private long dropBytes;
    private long dropKbps;
    private long ipInPeakKbps;
    private long ipInPeakPps;
    private long ipAttackPeakKbps;
    private long ipAttackPeakPps;
    private long tcpNewConnNum;
    private long tcpCurConnNum;
    private int portData;

    public AttackTypeEvent(EventIdentifier identifer, AttackType type) {
        super(identifer);
        this.attackType = type;
    }

    public long getDropBytes() {
        return this.dropBytes;
    }

    public void setDropBytes(long dropBytes) {
        this.dropBytes = dropBytes;
    }

    public long getDropKbps() {
        return this.dropKbps;
    }

    public void setDropKbps(long dropKbps) {
        this.dropKbps = dropKbps;
    }

    public long getDropPps() {
        return this.dropPps;
    }

    public void setDropPps(long dropPps) {
        this.dropPps = dropPps;
    }

    @Override
    public void average(int number) {
    }

    public AttackType getAttackType() {
        return this.attackType;
    }

    public long getDropPackets() {
        return this.dropPackets;
    }

    public long getIpInPeakKbps() {
        return this.ipInPeakKbps;
    }

    public void setIpInPeakKbps(long ipInPeakKbps) {
        this.ipInPeakKbps = ipInPeakKbps;
    }

    public long getIpInPeakPps() {
        return this.ipInPeakPps;
    }

    public void setIpInPeakPps(long ipInPeakPps) {
        this.ipInPeakPps = ipInPeakPps;
    }

    public long getIpAttackPeakKbps() {
        return this.ipAttackPeakKbps;
    }

    public void setIpAttackPeakKbps(long ipAttackPeakKbps) {
        this.ipAttackPeakKbps = ipAttackPeakKbps;
    }

    public long getIpAttackPeakPps() {
        return this.ipAttackPeakPps;
    }

    public void setIpAttackPeakPps(long ipAttackPeakPps) {
        this.ipAttackPeakPps = ipAttackPeakPps;
    }

    public long getTcpNewConnNum() {
        return this.tcpNewConnNum;
    }

    public void setTcpNewConnNum(long tcpNewConnNum) {
        this.tcpNewConnNum = tcpNewConnNum;
    }

    public long getTcpCurConnNum() {
        return this.tcpCurConnNum;
    }

    public void setTcpCurConnNum(long tcpCurConnNum) {
        this.tcpCurConnNum = tcpCurConnNum;
    }

    @Override
    public List<String> getSysLogInfo() {
        return new ArrayList<String>();
    }

    @Override
    public Event getCopyEvent() {
        Class[] ptype = new Class[]{EventIdentifier.class, AttackType.class};
        try {
            Constructor<?> constructor = this.getClass().getConstructor(ptype);
            Event copy = (Event)constructor.newInstance(this.getIdentifierCopy(), this.attackType);
            copy.setDropFlow(this.isIsDropFlow());
            copy.setMaxEvent(this.isIsMaxEvent());
            copy.setHourEvent(this.isIsHourEvent());
            copy.setNeedSum(this.isNeedSum());
            return copy;
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("when copy a event ,error hanpped,source event is " + this, e);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException("when copy a event ,error hanpped,source event is " + this, e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("when copy a event ,error hanpped,source event is " + this, e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("when copy a event ,error hanpped,source event is " + this, e);
        }
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            if (!(event instanceof AttackTypeEvent)) continue;
            AttackTypeEvent e = (AttackTypeEvent)event;
            this.portData = e.getPortData();
            this.addPort(e.getPortData());
            this.dropPackets += e.dropPackets;
            this.dropBytes += e.dropBytes;
            this.dropPps = this.dropPps > e.getDropPps() ? this.dropPps : e.getDropPps();
            this.dropKbps = this.dropKbps > e.getDropKbps() ? this.dropKbps : e.getDropKbps();
            this.ipAttackPeakKbps = this.ipAttackPeakKbps > e.getIpAttackPeakKbps() ? this.ipAttackPeakPps : e.getIpAttackPeakKbps();
            this.ipAttackPeakPps = this.ipAttackPeakPps > e.getIpAttackPeakPps() ? this.ipAttackPeakPps : e.getIpAttackPeakPps();
            this.ipInPeakKbps = this.ipInPeakKbps > e.getIpInPeakKbps() ? this.ipInPeakKbps : e.getIpInPeakKbps();
            this.ipInPeakPps = this.ipInPeakPps > e.getIpInPeakPps() ? this.ipInPeakPps : e.getIpInPeakPps();
            this.tcpNewConnNum = this.tcpNewConnNum > e.getTcpNewConnNum() ? this.tcpNewConnNum : e.getTcpNewConnNum();
            this.tcpCurConnNum = this.tcpCurConnNum > e.getTcpCurConnNum() ? this.tcpCurConnNum : e.getTcpCurConnNum();
        }
    }

    public void mergeDropPackets(AttackTypeEvent event) {
        this.dropPackets += event.dropPackets;
    }

    public void mergeDropBytes(AttackTypeEvent event) {
        this.dropBytes += event.dropBytes;
    }

    public void setAttackType(AttackType attackType) {
        this.attackType = attackType;
    }

    public void setDropPackets(long dropPackets) {
        this.dropPackets = dropPackets;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("type", (Object)this.attackType).append("dropKbps", this.dropKbps).append("dropPps", this.dropPps).toString();
    }

    public synchronized void addPorts(Set<Integer> portsSet) {
        for (Integer port : portsSet) {
            this.addPort(port);
        }
    }

    public synchronized void addPort(Integer port) {
        if (this.ports.size() < 5) {
            this.ports.add(port);
        }
    }

    public synchronized Set<Integer> getPorts() {
        HashSet<Integer> copy = new HashSet<Integer>();
        copy.addAll(this.ports);
        return copy;
    }

    public synchronized void setPorts(Set<Integer> ports) {
        this.ports.clear();
        this.addPorts(ports);
    }

    public int getPortData() {
        return this.portData;
    }

    public void setPortData(int portData) {
        this.portData = portData;
    }
}

