/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class CarEvent
extends Event {
    private long icmpKbps;
    private long icmpPps;
    private long otherKbps;
    private long otherPps;
    private long tcpKbps;
    private long tcpPps;
    private long udpKbps;
    private long udpPps;

    public CarEvent(EventIdentifier identifer) {
        super(identifer);
    }

    @Override
    public void average(int size) {
        this.setIcmpKbps(this.devideUp(this.getIcmpKbps(), size));
        this.setIcmpPps(this.devideUp(this.getIcmpPps(), size));
        this.setOtherKbps(this.devideUp(this.getOtherKbps(), size));
        this.setOtherPps(this.devideUp(this.getOtherPps(), size));
        this.setTcpKbps(this.devideUp(this.getTcpKbps(), size));
        this.setTcpPps(this.devideUp(this.getTcpPps(), size));
        this.setUdpKbps(this.devideUp(this.getUdpKbps(), size));
        this.setUdpPps(this.devideUp(this.getUdpPps(), size));
    }

    public long getIcmpKbps() {
        return this.icmpKbps;
    }

    public long getIcmpPps() {
        return this.icmpPps;
    }

    public long getOtherKbps() {
        return this.otherKbps;
    }

    public long getOtherPps() {
        return this.otherPps;
    }

    @Override
    public List<String> getSysLogInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("log_type=ip_car");
        info.addAll(super.getSysLogInfo());
        info.add("total_pps=" + this.getTotalPps());
        info.add("total_kbps=" + this.getTotalKbps());
        info.add("tcp_pps=" + this.getTcpPps());
        info.add("tcp_kbps=" + this.getTcpKbps());
        info.add("udp_pps=" + this.getUdpPps());
        info.add("udp_kbps=" + this.getUdpKbps());
        info.add("icmp_pps=" + this.getIcmpPps());
        info.add("icmp_kbps=" + this.getIcmpKbps());
        info.add("other_pps=" + this.getOtherPps());
        info.add("other_kbps=" + this.getOtherKbps());
        return info;
    }

    public long getTcpKbps() {
        return this.tcpKbps;
    }

    public long getTcpPps() {
        return this.tcpPps;
    }

    public long getTotalKbps() {
        return this.icmpKbps + this.otherKbps + this.tcpKbps + this.udpKbps;
    }

    public long getTotalPps() {
        return this.icmpPps + this.otherPps + this.tcpPps + this.udpPps;
    }

    public long getUdpKbps() {
        return this.udpKbps;
    }

    public long getUdpPps() {
        return this.udpPps;
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            this.add(event);
        }
    }

    public void setIcmpKbps(long icmpDropedFlow) {
        this.icmpKbps = icmpDropedFlow;
    }

    public void setIcmpPps(long icmpDropedPkts) {
        this.icmpPps = icmpDropedPkts;
    }

    public void setOtherKbps(long otherDropedFlow) {
        this.otherKbps = otherDropedFlow;
    }

    public void setOtherPps(long otherDropedPkts) {
        this.otherPps = otherDropedPkts;
    }

    public void setTcpKbps(long tcpDropedFlow) {
        this.tcpKbps = tcpDropedFlow;
    }

    public void setTcpPps(long tcpDropedPkts) {
        this.tcpPps = tcpDropedPkts;
    }

    public void setUdpKbps(long udpDropedFlow) {
        this.udpKbps = udpDropedFlow;
    }

    public void setUdpPps(long udpDropedPkts) {
        this.udpPps = udpDropedPkts;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).appendSuper(super.toString()).append("icmp_kbps", this.icmpKbps).append("icmp_pps", this.icmpPps).append("other_kbps", this.otherKbps).append("other_pps", this.otherPps).append("tcp_kbps", this.tcpKbps).append("tcp_pps", this.tcpPps).append("udp_pps", this.udpPps).append("udp_kbps", this.udpKbps).toString();
    }

    private void add(Event event) {
        CarEvent carEvent = (CarEvent)event;
        this.setIcmpKbps(this.icmpKbps + carEvent.getIcmpKbps());
        this.setIcmpPps(this.icmpPps + carEvent.getIcmpPps());
        this.setOtherKbps(this.otherKbps + carEvent.getOtherKbps());
        this.setOtherPps(this.otherPps + carEvent.getOtherPps());
        this.setTcpKbps(this.tcpKbps + carEvent.getTcpKbps());
        this.setTcpPps(this.tcpPps + carEvent.getTcpPps());
        this.setUdpKbps(this.udpKbps + carEvent.getUdpKbps());
        this.setUdpPps(this.udpPps + carEvent.getUdpPps());
    }

    @Override
    public void max(Event event) {
        if (null != event && event instanceof CarEvent) {
            CarEvent carEvent = (CarEvent)event;
            this.setIcmpKbps(this.getIcmpKbps() > carEvent.getIcmpKbps() ? this.getIcmpKbps() : carEvent.getIcmpKbps());
            this.setIcmpPps(this.getIcmpPps() > carEvent.getIcmpPps() ? this.getIcmpPps() : carEvent.getIcmpPps());
            this.setOtherKbps(this.getOtherKbps() > carEvent.getOtherKbps() ? this.getOtherKbps() : carEvent.getOtherKbps());
            this.setOtherPps(this.getOtherPps() > carEvent.getOtherPps() ? this.getOtherPps() : carEvent.getOtherPps());
            this.setTcpKbps(this.getTcpKbps() > carEvent.getTcpKbps() ? this.getTcpKbps() : carEvent.getTcpKbps());
            this.setTcpPps(this.getTcpPps() > carEvent.getTcpPps() ? this.getTcpPps() : carEvent.getTcpPps());
            this.setUdpKbps(this.getUdpKbps() > carEvent.getUdpKbps() ? this.getUdpKbps() : carEvent.getUdpKbps());
            this.setUdpPps(this.getUdpPps() > carEvent.getUdpPps() ? this.getUdpPps() : carEvent.getUdpPps());
        }
    }
}

