/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.db.event.DnsRequestType2Str;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ContentTopnEvent
extends Event {
    private long requestPps;
    private long requestKbps;
    private int dnsLen;
    private String domianName;
    private ContentTopnType type = new ContentTopnType();
    private int topnType;

    public ContentTopnEvent(EventIdentifier identifer) {
        super(identifer);
        this.type.setClazzName(this.getClass().getName());
    }

    @Override
    public ContentTopnType getType() {
        return this.type;
    }

    public void setType(ContentTopnType type) {
        this.type = type;
    }

    @Override
    public void average(int size) {
        this.setRequestPps(this.devideUp(this.requestPps, size));
        this.setRequsetKbps(this.devideUp(this.requestKbps, size));
    }

    public int getDnsLen() {
        return this.dnsLen;
    }

    public String getDomianName() {
        return this.domianName;
    }

    public long getRequestPps() {
        return this.requestPps;
    }

    public long getRequsetKbps() {
        return this.requestKbps;
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            this.merge(event);
        }
    }

    private void merge(Event e) {
        ContentTopnEvent event = (ContentTopnEvent)e;
        this.setRequestPps(this.requestPps + event.getRequestPps());
        this.setRequsetKbps(this.requestKbps + event.getRequsetKbps());
    }

    public void setDnsLen(int dnsLen) {
        this.dnsLen = dnsLen;
    }

    public void setDomianName(String domianName) {
        this.domianName = domianName;
        this.type.setDomainName(domianName);
    }

    public int getRequestType() {
        return this.type.getRequestType();
    }

    public void setRequestType(int requestType) {
        this.type.setRequestType(requestType);
    }

    public void setRequestPps(long requestPps) {
        this.requestPps = requestPps;
    }

    public void setRequsetKbps(long requsetKbps) {
        this.requestKbps = requsetKbps;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("is dorp event: ", this.isIsDropFlow()).append("is hour event: ", this.isIsHourEvent()).append("is max event: ", this.isIsMaxEvent()).append("domianName: ", (Object)this.domianName).append("topnType: ", this.topnType).append("requestPps: ", this.requestPps).append("requestKbps: ", this.requestKbps).append("requestType", (Object)DnsRequestType2Str.int2Str(this.getRequestType())).toString();
    }

    @Override
    public ContentTopnEvent getCopyEvent() {
        ContentTopnEvent copy = (ContentTopnEvent)super.getCopyEvent();
        copy.setDomianName(this.getDomianName());
        copy.setRequestType(this.getRequestType());
        copy.setTopnType(this.getTopnType());
        return copy;
    }

    public int getTopnType() {
        return this.topnType;
    }

    public void setTopnType(int topnType) {
        this.topnType = topnType;
        this.type.setTopnType(topnType);
    }

    private static class ContentTopnType
    implements Type {
        private String domainName;
        private String clazzName;
        private int topnType;
        private int requestType;

        private ContentTopnType() {
        }

        public int getRequestType() {
            return this.requestType;
        }

        public void setRequestType(int requestType) {
            this.requestType = requestType;
        }

        public boolean equals(Object o) {
            if (o instanceof ContentTopnType) {
                ContentTopnType type = (ContentTopnType)o;
                return this.domainName.equals(type.getDomainName()) && this.clazzName.equals(type.getClazzName()) && this.requestType == type.getRequestType() && this.topnType == type.getTopnType();
            }
            return false;
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public int hashCode() {
            return this.domainName.hashCode() * 13 + 19 + this.requestType + this.topnType;
        }

        public void setClazzName(String clazzName) {
            this.clazzName = clazzName;
        }

        public void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public int getTopnType() {
            return this.topnType;
        }

        public void setTopnType(int topnType) {
            this.topnType = topnType;
        }
    }
}

