/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.ForwardFlowEvent;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.OtherBizFlowEvent;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.TotalFlowEvent;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import com.hs.atic.collector.entity.event.ZoneTotalFlowEvent;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class DevTotalFlowEvent
extends TotalFlowEvent {
    private long totalPps;
    private long totalKbps;
    private long tcpKbps;
    private long tcpPps;
    private long udpKbps;
    private long udpPps;
    private long icmpKbps;
    private long icmpPps;
    private long otherKbps;
    private long otherPps;
    private long allReboundPps;
    private long allReboundKbps;
    private long tcpReboundPps;
    private long tcpReboundKbps;
    private long udpReboundPps;
    private long udpReboundKbps;
    private long tcpIncreaseCon;
    private long tcpConcurCon;
    private DevTotalBizFlowType type = new DevTotalBizFlowType();

    public DevTotalFlowEvent(EventIdentifier identifer) {
        super(identifer);
        this.type.setClazzName(this.getClass().getName());
    }

    public DevTotalFlowEvent(EventIdentifier identifer, boolean isDrop, boolean isForward) {
        this(identifer);
        super.setDropFlow(isDrop);
        super.setForwardFlow(isForward);
        this.type.setDrop(isDrop);
        this.type.setForward(isForward);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void average(int size) {
        this.setTotalPps(this.devideUp(this.totalPps, size));
        this.setTotalKbps(this.devideUp(this.totalKbps, size));
        this.setTcpPps(this.devideUp(this.getTcpPps(), size));
        this.setTcpKbps(this.devideUp(this.getTcpKbps(), size));
        this.setUdpKbps(this.devideUp(this.getUdpKbps(), size));
        this.setUdpPps(this.devideUp(this.getUdpPps(), size));
        this.setIcmpKbps(this.devideUp(this.getIcmpKbps(), size));
        this.setIcmpPps(this.devideUp(this.getIcmpPps(), size));
        this.setOtherKbps(this.devideUp(this.getOtherKbps(), size));
        this.setOtherPps(this.devideUp(this.getOtherPps(), size));
        this.setAllReboundPps(this.devideUp(this.allReboundPps, size));
        this.setAllReboundKbps(this.devideUp(this.allReboundKbps, size));
        this.setTcpReboundPps(this.devideUp(this.tcpReboundPps, size));
        this.setTcpReboundKbps(this.devideUp(this.tcpReboundKbps, size));
        this.setUdpReboundPps(this.devideUp(this.udpReboundPps, size));
        this.setUdpReboundKbps(this.devideUp(this.udpReboundKbps, size));
    }

    public long getIcmpKbps() {
        return this.icmpKbps;
    }

    public long getIcmpPps() {
        return this.icmpPps;
    }

    public long getOtherKbps() {
        return this.otherKbps;
    }

    public long getOtherPps() {
        return this.otherPps;
    }

    public long getTcpKbps() {
        return this.tcpKbps;
    }

    public long getTcpPps() {
        return this.tcpPps;
    }

    public long getTotalKbps() {
        return this.totalKbps;
    }

    public long getTotalPps() {
        return this.totalPps;
    }

    public long getUdpKbps() {
        return this.udpKbps;
    }

    public long getUdpPps() {
        return this.udpPps;
    }

    public long getAllReboundPps() {
        return this.allReboundPps;
    }

    public void setAllReboundPps(long allReboundPps) {
        this.allReboundPps = allReboundPps;
    }

    public long getAllReboundKbps() {
        return this.allReboundKbps;
    }

    public void setAllReboundKbps(long allReboundKbps) {
        this.allReboundKbps = allReboundKbps;
    }

    public long getTcpReboundPps() {
        return this.tcpReboundPps;
    }

    public void setTcpReboundPps(long tcpReboundPps) {
        this.tcpReboundPps = tcpReboundPps;
    }

    public long getTcpReboundKbps() {
        return this.tcpReboundKbps;
    }

    public void setTcpReboundKbps(long tcpReboundKbps) {
        this.tcpReboundKbps = tcpReboundKbps;
    }

    public long getUdpReboundPps() {
        return this.udpReboundPps;
    }

    public void setUdpReboundPps(long udpReboundPps) {
        this.udpReboundPps = udpReboundPps;
    }

    public long getUdpReboundKbps() {
        return this.udpReboundKbps;
    }

    public void setUdpReboundKbps(long udpReboundKbps) {
        this.udpReboundKbps = udpReboundKbps;
    }

    public long getTcpIncreaseCon() {
        return this.tcpIncreaseCon;
    }

    public void setTcpIncreaseCon(long tcpIncreaseCon) {
        this.tcpIncreaseCon = tcpIncreaseCon;
    }

    public long getTcpConcurCon() {
        return this.tcpConcurCon;
    }

    public void setTcpConcurCon(long tcpConcurCon) {
        this.tcpConcurCon = tcpConcurCon;
    }

    @Override
    public void max(Event e) {
        if (null != e && e instanceof DevTotalFlowEvent) {
            DevTotalFlowEvent devTotal = (DevTotalFlowEvent)e;
            this.setTotalPps(this.getTotalPps() > devTotal.getTotalPps() ? this.getTotalPps() : devTotal.getTotalPps());
            this.setTotalKbps(this.getTotalKbps() > devTotal.getTotalKbps() ? this.getTotalKbps() : devTotal.getTotalKbps());
            this.setTcpPps(this.getTcpPps() > devTotal.getTcpPps() ? this.getTcpPps() : devTotal.getTcpPps());
            this.setTcpKbps(this.getTcpKbps() > devTotal.getTcpKbps() ? this.getTcpKbps() : devTotal.getTcpKbps());
            this.setUdpPps(this.getUdpPps() > devTotal.getUdpPps() ? this.getUdpPps() : devTotal.getUdpPps());
            this.setUdpKbps(this.getUdpKbps() > devTotal.getUdpKbps() ? this.getUdpKbps() : devTotal.getUdpKbps());
            this.setIcmpKbps(this.getIcmpKbps() > devTotal.getIcmpKbps() ? this.getIcmpKbps() : devTotal.getIcmpKbps());
            this.setIcmpPps(this.getIcmpPps() > devTotal.getIcmpPps() ? this.getIcmpPps() : devTotal.getIcmpPps());
            this.setOtherKbps(this.getOtherKbps() > devTotal.getOtherKbps() ? this.getOtherKbps() : devTotal.getOtherKbps());
            this.setOtherPps(this.getOtherPps() > devTotal.getOtherPps() ? this.getOtherPps() : devTotal.getOtherPps());
            this.setAllReboundPps(this.allReboundPps > devTotal.allReboundPps ? this.allReboundPps : devTotal.allReboundPps);
            this.setAllReboundKbps(this.allReboundKbps > devTotal.allReboundKbps ? this.allReboundKbps : devTotal.allReboundKbps);
            this.setTcpReboundPps(this.tcpReboundPps > devTotal.tcpReboundPps ? this.tcpReboundPps : devTotal.tcpReboundPps);
            this.setTcpReboundKbps(this.tcpReboundKbps > devTotal.tcpReboundKbps ? this.tcpReboundKbps : devTotal.tcpReboundKbps);
            this.setUdpReboundPps(this.udpReboundPps > devTotal.udpReboundPps ? this.udpReboundPps : devTotal.udpReboundPps);
            this.setUdpReboundKbps(this.udpReboundKbps > devTotal.udpReboundKbps ? this.udpReboundKbps : devTotal.udpReboundKbps);
            this.setTcpConcurCon(this.getTcpConcurCon() > devTotal.getTcpConcurCon() ? this.getTcpConcurCon() : devTotal.getTcpConcurCon());
            this.setTcpIncreaseCon(this.getTcpIncreaseCon() > devTotal.getTcpIncreaseCon() ? this.getTcpIncreaseCon() : devTotal.getTcpIncreaseCon());
        }
    }

    protected void merge(Event event) {
        DevTotalFlowEvent devTotal = (DevTotalFlowEvent)event;
        this.setTotalPps(this.totalPps + devTotal.getTotalPps());
        this.setTotalKbps(this.totalKbps + devTotal.getTotalKbps());
        this.setTcpKbps(this.tcpKbps + devTotal.getTcpKbps());
        this.setTcpPps(this.tcpPps + devTotal.getTcpPps());
        this.setUdpKbps(this.udpKbps + devTotal.getUdpKbps());
        this.setUdpPps(this.udpPps + devTotal.getUdpPps());
        this.setIcmpKbps(this.icmpKbps + devTotal.getIcmpKbps());
        this.setIcmpPps(this.icmpPps + devTotal.getIcmpPps());
        this.setOtherKbps(this.otherKbps + devTotal.getOtherKbps());
        this.setOtherPps(this.otherPps + devTotal.getOtherPps());
        this.setAllReboundPps(this.allReboundPps + devTotal.allReboundPps);
        this.setAllReboundKbps(this.allReboundKbps + devTotal.allReboundKbps);
        this.setTcpReboundPps(this.tcpReboundPps + devTotal.tcpReboundPps);
        this.setTcpReboundKbps(this.tcpReboundKbps + devTotal.tcpReboundKbps);
        this.setUdpReboundPps(this.udpReboundPps + devTotal.udpReboundPps);
        this.setUdpReboundKbps(this.udpReboundKbps + devTotal.udpReboundKbps);
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            this.merge(event);
        }
    }

    @Override
    public void mergeDiscardFlowEvent(DiscardFlowEvent discard) {
        if (discard.isIsMaxEvent()) {
            this.setTotalPps(this.getTotalPps() > discard.getTotalPps() ? this.getTotalPps() : discard.getTotalPps());
            this.setTotalKbps(this.getTotalKbps() > discard.getTotalKbps() ? this.getTotalKbps() : discard.getTotalKbps());
            this.setTcpPps(this.getTcpPps() > discard.getTcpPps() ? this.getTcpPps() : discard.getTcpPps());
            this.setTcpKbps(this.getTcpKbps() > discard.getTcpKbps() ? this.getTcpKbps() : discard.getTcpKbps());
            this.setUdpPps(this.getUdpPps() > discard.getUdpPps() ? this.getUdpPps() : discard.getUdpPps());
            this.setUdpKbps(this.getUdpKbps() > discard.getUdpKbps() ? this.getUdpKbps() : discard.getUdpKbps());
            this.setIcmpKbps(this.getIcmpKbps() > discard.getIcmpKbps() ? this.getIcmpKbps() : discard.getIcmpKbps());
            this.setIcmpPps(this.getIcmpPps() > discard.getIcmpPps() ? this.getIcmpPps() : discard.getIcmpPps());
            this.setOtherKbps(this.getOtherKbps() > discard.getOtherKbps() ? this.getOtherKbps() : discard.getOtherKbps());
            this.setOtherPps(this.getOtherPps() > discard.getOtherPps() ? this.getOtherPps() : discard.getOtherPps());
            this.setAllReboundPps(this.getAllReboundPps() > discard.getAllReboundPps() ? this.getAllReboundPps() : discard.getAllReboundPps());
            this.setAllReboundKbps(this.getAllReboundKbps() > discard.getAllReboundKbps() ? this.getAllReboundKbps() : discard.getAllReboundKbps());
            this.setTcpReboundPps(this.getTcpReboundPps() > discard.getTcpReboundPps() ? this.getTcpReboundPps() : discard.getTcpReboundPps());
            this.setTcpReboundKbps(this.getTcpReboundKbps() > discard.getTcpReboundKbps() ? this.getTcpReboundKbps() : discard.getTcpReboundKbps());
            this.setUdpReboundPps(this.getUdpReboundPps() > discard.getUdpReboundPps() ? this.getUdpReboundPps() : discard.getUdpReboundPps());
            this.setUdpReboundKbps(this.getUdpReboundKbps() > discard.getUdpReboundKbps() ? this.getUdpReboundKbps() : discard.getUdpReboundKbps());
        } else {
            this.setTotalPps(this.totalPps + discard.getAllPps());
            this.setTotalKbps(this.totalKbps + discard.getAllKbps());
            this.setTcpKbps(this.tcpKbps + discard.getTcpKbps());
            this.setTcpPps(this.tcpPps + discard.getTcpPps());
            this.setUdpKbps(this.udpKbps + discard.getUdpKbps());
            this.setUdpPps(this.udpPps + discard.getUdpPps());
            this.setIcmpKbps(this.icmpKbps + discard.getIcmpKbps());
            this.setIcmpPps(this.icmpPps + discard.getIcmpPps());
            this.setOtherKbps(this.otherKbps + discard.getOtherKbps());
            this.setOtherPps(this.otherPps + discard.getOtherPps());
            this.setAllReboundPps(this.allReboundPps + discard.getAllReboundPps());
            this.setAllReboundKbps(this.allReboundKbps + discard.getAllReboundKbps());
            this.setTcpReboundPps(this.tcpReboundPps + discard.getTcpReboundPps());
            this.setTcpReboundKbps(this.tcpReboundKbps + discard.getTcpReboundKbps());
            this.setUdpReboundPps(this.udpReboundPps + discard.getUdpReboundPps());
            this.setUdpReboundKbps(this.udpReboundKbps + discard.getUdpReboundKbps());
        }
    }

    @Override
    public void mergeInFlowEvent(InFlowEvent flowEvent) {
        if (flowEvent.isIsMaxEvent()) {
            this.setTotalPps(this.getTotalPps() > flowEvent.getTotalPps() ? this.getTotalPps() : flowEvent.getTotalPps());
            this.setTotalKbps(this.getTotalKbps() > flowEvent.getTotalKbps() ? this.getTotalKbps() : flowEvent.getTotalKbps());
            this.setTcpPps(this.getTcpPps() > flowEvent.getTcpPps() ? this.getTcpPps() : flowEvent.getTcpPps());
            this.setTcpKbps(this.getTcpKbps() > flowEvent.getTcpKbps() ? this.getTcpKbps() : flowEvent.getTcpKbps());
            this.setUdpPps(this.getUdpPps() > flowEvent.getUdpPps() ? this.getUdpPps() : flowEvent.getUdpPps());
            this.setUdpKbps(this.getUdpKbps() > flowEvent.getUdpKbps() ? this.getUdpKbps() : flowEvent.getUdpKbps());
            this.setIcmpKbps(this.getIcmpKbps() > flowEvent.getIcmpKbps() ? this.getIcmpKbps() : flowEvent.getIcmpKbps());
            this.setIcmpPps(this.getIcmpPps() > flowEvent.getIcmpPps() ? this.getIcmpPps() : flowEvent.getIcmpPps());
            this.setOtherKbps(this.getOtherKbps() > flowEvent.getOtherKbps() ? this.getOtherKbps() : flowEvent.getOtherKbps());
            this.setOtherPps(this.getOtherPps() > flowEvent.getOtherPps() ? this.getOtherPps() : flowEvent.getOtherPps());
            this.setTcpIncreaseCon(this.getTcpIncreaseCon() > flowEvent.getTcpIncreaseCon() ? this.getTcpIncreaseCon() : flowEvent.getTcpIncreaseCon());
            this.setTcpConcurCon(this.getTcpConcurCon() > flowEvent.getTcpConcurCon() ? this.getTcpConcurCon() : flowEvent.getTcpConcurCon());
        } else {
            this.setTotalPps(this.totalPps + flowEvent.getAllPps());
            this.setTotalKbps(this.totalKbps + flowEvent.getAllKbps());
            this.setTcpKbps(this.tcpKbps + flowEvent.getTcpKbps());
            this.setTcpPps(this.tcpPps + flowEvent.getTcpPps());
            this.setUdpKbps(this.udpKbps + flowEvent.getUdpKbps());
            this.setUdpPps(this.udpPps + flowEvent.getUdpPps());
            this.setIcmpKbps(this.icmpKbps + flowEvent.getIcmpKbps());
            this.setIcmpPps(this.icmpPps + flowEvent.getIcmpPps());
            this.setOtherKbps(this.otherKbps + flowEvent.getOtherKbps());
            this.setOtherPps(this.otherPps + flowEvent.getOtherPps());
            this.setTcpIncreaseCon(this.tcpIncreaseCon + flowEvent.getTcpIncreaseCon());
            this.setTcpConcurCon(this.tcpConcurCon + flowEvent.getTcpConcurCon());
        }
    }

    public void mergeForwardFlowEvent(ForwardFlowEvent flowEvent) {
        if (flowEvent.isIsMaxEvent()) {
            this.setTotalPps(this.getTotalPps() > flowEvent.getTotalPps() ? this.getTotalPps() : flowEvent.getTotalPps());
            this.setTotalKbps(this.getTotalKbps() > flowEvent.getTotalKbps() ? this.getTotalKbps() : flowEvent.getTotalKbps());
            this.setTcpPps(this.getTcpPps() > flowEvent.getTcpPps() ? this.getTcpPps() : flowEvent.getTcpPps());
            this.setTcpKbps(this.getTcpKbps() > flowEvent.getTcpKbps() ? this.getTcpKbps() : flowEvent.getTcpKbps());
            this.setUdpPps(this.getUdpPps() > flowEvent.getUdpPps() ? this.getUdpPps() : flowEvent.getUdpPps());
            this.setUdpKbps(this.getUdpKbps() > flowEvent.getUdpKbps() ? this.getUdpKbps() : flowEvent.getUdpKbps());
            this.setIcmpKbps(this.getIcmpKbps() > flowEvent.getIcmpKbps() ? this.getIcmpKbps() : flowEvent.getIcmpKbps());
            this.setIcmpPps(this.getIcmpPps() > flowEvent.getIcmpPps() ? this.getIcmpPps() : flowEvent.getIcmpPps());
            this.setOtherKbps(this.getOtherKbps() > flowEvent.getOtherKbps() ? this.getOtherKbps() : flowEvent.getOtherKbps());
            this.setOtherPps(this.getOtherPps() > flowEvent.getOtherPps() ? this.getOtherPps() : flowEvent.getOtherPps());
        } else {
            this.setTotalPps(this.totalPps + flowEvent.getAllPps());
            this.setTotalKbps(this.totalKbps + flowEvent.getAllKbps());
            this.setTcpKbps(this.tcpKbps + flowEvent.getTcpKbps());
            this.setTcpPps(this.tcpPps + flowEvent.getTcpPps());
            this.setUdpKbps(this.udpKbps + flowEvent.getUdpKbps());
            this.setUdpPps(this.udpPps + flowEvent.getUdpPps());
            this.setIcmpKbps(this.icmpKbps + flowEvent.getIcmpKbps());
            this.setIcmpPps(this.icmpPps + flowEvent.getIcmpPps());
            this.setOtherKbps(this.otherKbps + flowEvent.getOtherKbps());
            this.setOtherPps(this.otherPps + flowEvent.getOtherPps());
            this.setTcpIncreaseCon(this.tcpIncreaseCon + flowEvent.getTcpIncreaseCon());
            this.setTcpConcurCon(this.tcpConcurCon + flowEvent.getTcpConcurCon());
        }
    }

    @Override
    public void mergeZoneTotalFlowEvent(ZoneTotalFlowEvent zoneTotalFlowEvent) {
        this.setTotalPps(this.totalPps + zoneTotalFlowEvent.getAllPps());
        this.setTotalKbps(this.totalKbps + zoneTotalFlowEvent.getAllKbps());
        this.setTcpKbps(this.tcpKbps + zoneTotalFlowEvent.getTcpKbps());
        this.setTcpPps(this.tcpPps + zoneTotalFlowEvent.getTcpPps());
        this.setUdpKbps(this.udpKbps + zoneTotalFlowEvent.getUdpKbps());
        this.setUdpPps(this.udpPps + zoneTotalFlowEvent.getUdpPps());
        this.setIcmpKbps(this.icmpKbps + zoneTotalFlowEvent.getIcmpKbps());
        this.setIcmpPps(this.icmpPps + zoneTotalFlowEvent.getIcmpPps());
        this.setOtherKbps(this.otherKbps + zoneTotalFlowEvent.getOtherKbps());
        this.setOtherPps(this.otherPps + zoneTotalFlowEvent.getOtherPps());
        this.setAllReboundPps(this.allReboundPps + zoneTotalFlowEvent.getAllReboundPps());
        this.setAllReboundKbps(this.allReboundKbps + zoneTotalFlowEvent.getAllReboundKbps());
        this.setTcpReboundPps(this.tcpReboundPps + zoneTotalFlowEvent.getTcpReboundPps());
        this.setTcpReboundKbps(this.tcpReboundKbps + zoneTotalFlowEvent.getTcpReboundKbps());
        this.setUdpReboundPps(this.udpReboundPps + zoneTotalFlowEvent.getUdpReboundPps());
        this.setUdpReboundKbps(this.udpReboundKbps + zoneTotalFlowEvent.getUdpReboundKbps());
    }

    @Override
    public void mergeTcpBizFlowEvent(TcpBizFlowEvent tcpBizFlow) {
        this.setTotalPps(this.totalPps + tcpBizFlow.getTotalPps());
        this.setTotalKbps(this.totalKbps + tcpBizFlow.getTotalKbps());
        this.setTcpKbps(this.tcpKbps + tcpBizFlow.getTotalKbps());
        this.setTcpPps(this.tcpPps + tcpBizFlow.getTotalPps());
        this.setAllReboundPps(this.allReboundPps + tcpBizFlow.getTotalReboundPps());
        this.setAllReboundKbps(this.allReboundKbps + tcpBizFlow.getTotalReboundKbps());
        this.setTcpReboundPps(this.tcpReboundPps + tcpBizFlow.getTotalReboundPps());
        this.setTcpReboundKbps(this.tcpReboundKbps + tcpBizFlow.getTotalReboundKbps());
    }

    @Override
    public void mergeUdpBizFlowEvent(UdpBizFlowEvent udpBizFlow) {
        this.setTotalPps(this.totalPps + udpBizFlow.getTotalPps());
        this.setTotalKbps(this.totalKbps + udpBizFlow.getTotalKbps());
        this.setUdpKbps(this.udpKbps + udpBizFlow.getTotalKbps());
        this.setUdpPps(this.udpPps + udpBizFlow.getTotalPps());
        this.setAllReboundPps(this.allReboundPps + udpBizFlow.getTotalReboundPps());
        this.setAllReboundKbps(this.allReboundKbps + udpBizFlow.getTotalReboundKbps());
        this.setUdpReboundPps(this.udpReboundPps + udpBizFlow.getTotalReboundPps());
        this.setUdpReboundKbps(this.udpReboundKbps + udpBizFlow.getTotalReboundKbps());
    }

    @Override
    public void mergeOtherBizFlowEvent(OtherBizFlowEvent otherBizFlow) {
        this.setTotalPps(this.totalPps + otherBizFlow.getTotalPps());
        this.setTotalKbps(this.totalKbps + otherBizFlow.getTotalKbps());
        this.setOtherKbps(this.otherKbps + otherBizFlow.getTotalKbps());
        this.setOtherPps(this.otherPps + otherBizFlow.getTotalPps());
    }

    @Override
    public void setDropFlow(boolean isDropFlow) {
        super.setDropFlow(isDropFlow);
        this.type.setDrop(isDropFlow);
    }

    @Override
    public void setForwardFlow(boolean isForwardFlow) {
        super.setForwardFlow(isForwardFlow);
        this.type.setForward(isForwardFlow);
    }

    public void setIcmpKbps(long icmpKbps) {
        this.icmpKbps = icmpKbps;
    }

    public void setIcmpPps(long icmpPps) {
        this.icmpPps = icmpPps;
    }

    public void setOtherKbps(long otherKbps) {
        this.otherKbps = otherKbps;
    }

    public void setOtherPps(long otherPps) {
        this.otherPps = otherPps;
    }

    public void setTcpKbps(long tcpKbps) {
        this.tcpKbps = tcpKbps;
    }

    public void setTcpPps(long tcpPps) {
        this.tcpPps = tcpPps;
    }

    public void setTotalKbps(long totalKbps) {
        this.totalKbps = totalKbps;
    }

    public void setTotalPps(long totalPps) {
        this.totalPps = totalPps;
    }

    public void setUdpKbps(long udpKbps) {
        this.udpKbps = udpKbps;
    }

    public void setUdpPps(long udpPps) {
        this.udpPps = udpPps;
    }

    @Override
    public String toString() {
        if (this.isValid()) {
            return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("is dorp flow: ", this.isIsDropFlow()).append("is hour event: ", this.isIsHourEvent()).append("is max event: ", this.isIsMaxEvent()).append("totolPps", this.getTotalPps()).append("allBkps", this.getTcpKbps()).append("icmpKbps", this.icmpKbps).append("icmpPps", this.icmpPps).append("otherKbps", this.otherKbps).append("otherPps", this.otherPps).append("tcpKbps", this.tcpKbps).append("tcpPps", this.tcpPps).append("udpPps", this.udpPps).append("udpKbps", this.udpKbps).append("tcpConcurCon", this.tcpConcurCon).append("tcpIncreaseCon", this.tcpIncreaseCon).toString();
        }
        return "invalide flow event";
    }

    private static class DevTotalBizFlowType
    implements Type {
        boolean isDrop;
        boolean isForward;
        private String clazzName;

        private DevTotalBizFlowType() {
        }

        public boolean equals(Object o) {
            if (o instanceof DevTotalBizFlowType) {
                DevTotalBizFlowType type = (DevTotalBizFlowType)o;
                return this.isDrop == type.isIsDrop() && this.isForward == type.isIsForward() && this.clazzName.equals(type.getClazzName());
            }
            return false;
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public int hashCode() {
            int result = 0;
            result += 17 * (this.isDrop ? 0 : 1);
            result += 19 * (this.isForward ? 0 : 1);
            return result += this.clazzName.hashCode();
        }

        public boolean isIsDrop() {
            return this.isDrop;
        }

        public boolean isIsForward() {
            return this.isForward;
        }

        public void setClazzName(String clazzName) {
            this.clazzName = clazzName;
        }

        public void setDrop(boolean isDrops) {
            this.isDrop = isDrops;
        }

        public void setForward(boolean isForwards) {
            this.isForward = isForwards;
        }
    }
}

