/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.xml.ToXml;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dom4j.Element;

public class DnsDefendEvent
extends Event
implements ToXml {
    private static final int SRC_IP_SIZE = 20;
    private String domaiName = "";
    private long requestNum;
    private StringBuffer srcIp = new StringBuffer();
    private Set<String> ipCollections = new HashSet<String>();

    public DnsDefendEvent(EventIdentifier identifer) {
        super(identifer);
    }

    public String getDomaiName() {
        return this.domaiName;
    }

    public void setDomaiName(String domaiName) {
        this.domaiName = domaiName;
    }

    public long getRequestNum() {
        return this.requestNum;
    }

    public void setRequestNum(long requestNum) {
        this.requestNum = requestNum;
    }

    public String getSrcIp() {
        return this.srcIp.toString();
    }

    public Set<String> getIpCollections() {
        return this.ipCollections;
    }

    public void setIpCollections(Set<String> ipCollections) {
        this.ipCollections = ipCollections;
    }

    public void addSrcIp(String ip) {
        if (this.ipCollections.isEmpty()) {
            this.srcIp.append(ip);
            this.ipCollections.add(ip);
        } else if (!this.ipCollections.contains(ip)) {
            this.ipCollections.add(ip);
            this.srcIp.append(',').append(ip);
        }
    }

    @Override
    public void average(int number) {
    }

    public void merge(Event e) {
        if (e instanceof DnsDefendEvent) {
            DnsDefendEvent o = (DnsDefendEvent)e;
            this.requestNum += o.requestNum;
            if (!o.getIpCollections().isEmpty()) {
                Set<String> set = o.getIpCollections();
                for (String ip : set) {
                    if (this.ipCollections.size() >= 20) break;
                    this.addSrcIp(ip);
                }
            }
        }
    }

    public void mergeWithOutIp(Event e) {
        if (e instanceof DnsDefendEvent) {
            DnsDefendEvent o = (DnsDefendEvent)e;
            this.requestNum += o.requestNum;
        }
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            this.merge(event);
        }
    }

    @Override
    public void toXml(Element element) {
    }

    public boolean equals(Object o) {
        if (o instanceof DnsDefendEvent) {
            DnsDefendEvent event = (DnsDefendEvent)o;
            return event.getDeviceIp().equals(this.getDeviceIp()) && event.getDeviceType() == this.getDeviceType() && event.domaiName.equals(this.domaiName);
        }
        return false;
    }

    public int hashCode() {
        int result = 19;
        result += this.getDeviceIp().hashCode();
        result += this.getDeviceType();
        return result += this.domaiName.hashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("domaiName", (Object)this.domaiName).toString();
    }
}

