/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.db.event.DnsRequestType2Str;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class DnsStatisEvent
extends Event {
    private DnsStatisType type = new DnsStatisType();
    private long dnsId;
    private long requestPps;
    private long requestKbps;
    private long replyPps;
    private long replyKbps;
    private long requestThresholdPps;
    private long requsetThresholdKbps;
    private long replyThresholdPps;
    private long replyThresholdKbps;
    private String dnsName;
    private boolean isHour;

    public DnsStatisEvent(EventIdentifier identifer) {
        super(identifer);
        this.type.setClazzName(this.getClass().getName());
    }

    @Override
    public void average(int size) {
        this.setRequestPps(this.devideUp(this.requestPps, size));
        this.setRequestKbps(this.devideUp(this.requestKbps, size));
        this.setRequestThresholdPps(this.devideUp(this.requestThresholdPps, size));
        this.setRequsetThresholdKbps(this.devideUp(this.requsetThresholdKbps, size));
        this.setReplyPps(this.devideUp(this.replyPps, size));
        this.setReplyKbps(this.devideUp(this.replyKbps, size));
        this.setReplyThresholdPps(this.devideUp(this.replyThresholdPps, size));
        this.setReplyThresholdKbps(this.devideUp(this.replyThresholdKbps, size));
    }

    @Override
    public DnsStatisEvent getCopyEvent() {
        DnsStatisEvent copy = (DnsStatisEvent)super.getCopyEvent();
        copy.setDnsName(this.getDnsName());
        copy.setRequestType(this.getRequestType());
        return copy;
    }

    public long getDnsId() {
        return this.dnsId;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public long getReplyKbps() {
        return this.replyKbps;
    }

    public long getReplyPps() {
        return this.replyPps;
    }

    public long getReplyThresholdKbps() {
        return this.replyThresholdKbps;
    }

    public long getReplyThresholdPps() {
        return this.replyThresholdPps;
    }

    public long getRequestKbps() {
        return this.requestKbps;
    }

    public long getRequestPps() {
        return this.requestPps;
    }

    public long getRequestThresholdPps() {
        return this.requestThresholdPps;
    }

    public long getRequsetThresholdKbps() {
        return this.requsetThresholdKbps;
    }

    @Override
    public DnsStatisType getType() {
        return this.type;
    }

    public int getRequestType() {
        return this.type.getRequestType();
    }

    public void setRequestType(int requestType) {
        this.type.setRequestType(requestType);
    }

    public boolean isIsHour() {
        return this.isHour;
    }

    protected void merge(Event e) {
        DnsStatisEvent event = (DnsStatisEvent)e;
        this.setRequestPps(this.requestPps + event.getRequestPps());
        this.setRequestKbps(this.requestKbps + event.getRequestKbps());
        this.setRequestThresholdPps(this.requestThresholdPps + event.getRequestThresholdPps());
        this.setRequsetThresholdKbps(this.requsetThresholdKbps + event.getRequsetThresholdKbps());
        this.setReplyPps(this.replyPps + event.getReplyPps());
        this.setReplyKbps(this.replyKbps + event.getReplyKbps());
        this.setReplyThresholdPps(this.replyThresholdPps + event.getReplyThresholdPps());
        this.setReplyThresholdKbps(this.replyThresholdKbps + event.getReplyThresholdKbps());
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            this.merge(event);
        }
    }

    public void setDnsId(long dnsId) {
        this.dnsId = dnsId;
        this.type.setDnsId(dnsId);
    }

    public void setDnsName(String dnsName) {
        this.dnsName = dnsName;
        this.type.setDnsName(dnsName);
    }

    public void setHour(boolean hour) {
        this.isHour = hour;
    }

    public void setReplyKbps(long replyKbps) {
        this.replyKbps = replyKbps;
    }

    public void setReplyPps(long replyPps) {
        this.replyPps = replyPps;
    }

    public void setReplyThresholdKbps(long replyThresholdKbps) {
        this.replyThresholdKbps = replyThresholdKbps;
    }

    public void setReplyThresholdPps(long replyThresholdPps) {
        this.replyThresholdPps = replyThresholdPps;
    }

    public void setRequestKbps(long requestKbps) {
        this.requestKbps = requestKbps;
    }

    public void setRequestPps(long requestPps) {
        this.requestPps = requestPps;
    }

    public void setRequestThresholdPps(long requestThresholdPps) {
        this.requestThresholdPps = requestThresholdPps;
    }

    public void setRequsetThresholdKbps(long requsetThresholdKbps) {
        this.requsetThresholdKbps = requsetThresholdKbps;
    }

    public void setType(DnsStatisType type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("is dorp event: ", this.isIsDropFlow()).append("is hour event: ", this.isIsHourEvent()).append("is max event: ", this.isIsMaxEvent()).append("dnsId: ", this.dnsId).append("dnsName: ", (Object)this.dnsName).append("requestPps: ", this.requestPps).append("requestKbps: ", this.requestKbps).append("replyPps: ", this.replyPps).append("replyKbps: ", this.replyKbps).append("requestThresholdPps: ", this.requestThresholdPps).append("requsetThresholdKbps: ", this.requsetThresholdKbps).append("replyThresholdPps: ", this.replyThresholdPps).append("replyThresholdKbps: ", this.replyThresholdKbps).append("requestType", (Object)DnsRequestType2Str.int2Str(this.getRequestType())).toString();
    }

    private static class DnsStatisType
    implements Type {
        private long dnsId;
        private String dnsName;
        private String clazzName;
        private int requestType;

        private DnsStatisType() {
        }

        public int getRequestType() {
            return this.requestType;
        }

        public void setRequestType(int requestType) {
            this.requestType = requestType;
        }

        public boolean equals(Object o) {
            if (o instanceof DnsStatisType) {
                DnsStatisType type = (DnsStatisType)o;
                return this.dnsId == type.getDnsId() && this.clazzName.equals(type.getClazzName()) && this.dnsName.equals(type.getDnsName()) && this.requestType == type.getRequestType();
            }
            return false;
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public long getDnsId() {
            return this.dnsId;
        }

        public String getDnsName() {
            return this.dnsName;
        }

        public int hashCode() {
            return (int)this.dnsId * 17 + 19 + this.requestType;
        }

        public void setClazzName(String clazzName) {
            this.clazzName = clazzName;
        }

        public void setDnsId(long dnsId) {
            this.dnsId = dnsId;
        }

        public void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }
    }
}

