/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.process.CpuAndVpnType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.AbnormalEvent;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.ExceptionDropEntity;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.entity.event.SumAbnormalEvent;
import com.hs.atic.collector.entity.event.xml.ToXml;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.ZoneUitl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dom4j.Element;

public class ExceptionEvent
extends AbnormalEvent
implements SumAbnormalEvent<OriginalExceptionEvent, ExceptionEvent>,
ToXml {
    private static final String DETECT_DEVICE = "DETECT";
    private static final String CLEAN_DEVICE = "CLEAN";
    private static final int CLEAN_DEVICE_FLAG = 0;
    private static final String ALERT_START_TIME = "start_time_alert";
    private static final String BIZ_ID = "biz_id";
    private static final String ATTACK_START_TIME = "start_time_attack";
    private static final String END_TIME = "end_time";
    private static final String DURATION = "duration";
    private static final String ATTACK_STATUS = "attack_status";
    private static final String ATTAKER = "attacker";
    private static final String DROP_KBITS = "drop_kbits";
    private static final String DROP_PACKETS = "drop_packets";
    private static final String ATTACK_TYPE = "attack_type";
    private static final String PORT = "port";
    private static final String PROTOCOL = "protocol";
    private static final String PORTS = "ports";
    private static final long FIVE_MINITUS = 300000L;
    private static final int LOG_CYCLE = 64;
    private static final long SECOND_BLACKHOLE_TIME_OUT = 120000L;
    private static long timeOutPeroid;
    private Set<Integer> attackCpus = new HashSet<Integer>();
    private Set<Integer> alertCpus = new HashSet<Integer>();
    private Map<CpuAndVpnType, ExceptionDropEntity> cpuAndVpnsDropFlow = new HashMap<CpuAndVpnType, ExceptionDropEntity>();
    private AttackType attackType;
    private long realValue;
    private long normalValue;
    private int ppsOrKbps;
    private long realValue1;
    private long normalValue1;
    private int ppsOrKbps1;
    private boolean isDefend;
    private boolean hasInserted;
    private long maxDropPps;
    private long maxDropKbps;
    private long currMaxDropPps;
    private long currMaxDropKbps;
    private boolean sendAlarm;

    public ExceptionEvent(EventIdentifier identifer) {
        super(identifer);
    }

    public static long getTimeOutPeroid() {
        return timeOutPeroid;
    }

    public static void setTimeOutPeroid(long timeOutPeroid) {
        ExceptionEvent.timeOutPeroid = timeOutPeroid;
    }

    @Override
    public ExceptionEvent sumElement(List<OriginalExceptionEvent> events) {
        long changedPackets = 0L;
        long changedKbits = 0L;
        long attackCount = 0L;
        long changedIpAttackPeakKbps = 0L;
        long changedIpAttackPeakPps = 0L;
        long changedIpInPeakKbps = 0L;
        long changedIpInPeakPps = 0L;
        long changedTcpCurConnNum = 0L;
        long changedTcpNewConnNum = 0L;
        long changedAttackPeakKbps = 0L;
        long changedAttackPeakPpsOrQps = 0L;
        long changedCurrMaxDropKbps = 0L;
        long changedCurrMaxDropPps = 0L;
        for (OriginalExceptionEvent event : events) {
            if (event.isAttackSrcEvent()) continue;
            this.setPortData(event.getPortData());
            this.addPort(event.getPortData());
            changedIpInPeakKbps = this.queryMaxValue(this.getIpInPeakKbps(), event.getIpInPeakKbps());
            changedIpInPeakPps = this.queryMaxValue(this.getIpInPeakPps(), event.getIpInPeakPps());
            changedTcpCurConnNum = this.queryMaxValue(this.getTcpCurConnNum(), event.getTcpCurConnNum());
            changedTcpNewConnNum = this.queryMaxValue(this.getTcpNewConnNum(), event.getTcpNewConnNum());
            this.setIpInPeakKbps(changedIpInPeakKbps);
            this.setIpInPeakPps(changedIpInPeakPps);
            this.setTcpCurConnNum(changedTcpCurConnNum);
            this.setTcpNewConnNum(changedTcpNewConnNum);
            if (!event.isNormal()) {
                if (event.getPpsOrKbps() == this.ppsOrKbps) {
                    this.realValue = event.getRealValue() > this.realValue ? event.getRealValue() : this.realValue;
                    this.normalValue = event.getNormalValue() == 0L ? this.normalValue : event.getNormalValue();
                    this.ppsOrKbps = event.getPpsOrKbps();
                } else {
                    this.realValue = event.getRealValue();
                    this.normalValue = event.getNormalValue() == 0L ? this.normalValue : event.getNormalValue();
                    this.ppsOrKbps = event.getPpsOrKbps();
                }
                if (event.getPpsOrKbps1() == this.ppsOrKbps1) {
                    this.realValue1 = event.getRealValue1() > this.realValue1 ? event.getRealValue1() : this.realValue1;
                    this.normalValue1 = event.getNormalValue1() == 0L ? this.normalValue1 : event.getNormalValue1();
                    this.ppsOrKbps1 = event.getPpsOrKbps1();
                } else {
                    this.realValue1 = event.getRealValue1();
                    this.normalValue1 = event.getNormalValue1() == 0L ? this.normalValue1 : event.getNormalValue1();
                    this.ppsOrKbps1 = event.getPpsOrKbps1();
                }
            }
            this.updateTime(event);
            if (event.isAttack()) {
                changedPackets += event.getDropPkgs();
                this.setDropPkgs(this.getDropPkgs() + event.getDropPkgs());
                changedKbits += event.getDropKbits();
                this.setDropKbits(this.getDropKbits() + event.getDropKbits());
                this.alertCpus.remove(event.getCpu());
                this.attackCpus.add(event.getCpu());
                this.addAttackers(event.getAttackers());
                changedIpAttackPeakKbps = this.queryMaxValue(this.getIpAttackPeakKbps(), event.getIpAttackPeakKbps());
                changedIpAttackPeakPps = this.queryMaxValue(this.getIpAttackPeakPps(), event.getIpAttackPeakPps());
                changedAttackPeakKbps = this.queryMaxValue(this.getAttackPeakKbps(), event.getAttackPeakKbps());
                changedAttackPeakPpsOrQps = this.queryMaxValue(this.getAttackPeakPpsOrQps(), event.getAttackPeakPpsOrQps());
                this.setIpAttackPeakKbps(changedIpAttackPeakKbps);
                this.setIpAttackPeakPps(changedIpAttackPeakPps);
                this.setAttackPeakKbps(changedAttackPeakKbps);
                this.setAttackPeakPpsOrQps(changedAttackPeakPpsOrQps);
                this.currMaxDropKbps = changedCurrMaxDropKbps = event.getAttackPeakKbps();
                this.currMaxDropPps = changedCurrMaxDropPps = event.getAttackPeakPpsOrQps();
                if (!this.isIsEverAttacked()) {
                    ++attackCount;
                }
            } else if (event.isAlert()) {
                this.alertCpus.add(event.getCpu());
                this.attackCpus.remove(event.getCpu());
            } else {
                this.alertCpus.remove(event.getCpu());
                this.attackCpus.remove(event.getCpu());
            }
            this.caculateDropByCpuAndVpn(event);
        }
        this.updateState();
        ExceptionEvent changed = this.getCopyEvent();
        changed.setDropPkgs(changedPackets);
        changed.setDropKbits(changedKbits);
        changed.setAttackCount(attackCount);
        changed.setIpAttackPeakPps(changedIpAttackPeakPps);
        changed.setIpAttackPeakKbps(changedIpAttackPeakKbps);
        changed.setIpInPeakKbps(changedIpInPeakKbps);
        changed.setIpInPeakPps(changedIpInPeakPps);
        changed.setTcpCurConnNum(changedTcpCurConnNum);
        changed.setTcpNewConnNum(changedTcpNewConnNum);
        changed.setAttackPeakKbps(changedAttackPeakKbps);
        changed.setAttackPeakPpsOrQps(changedAttackPeakPpsOrQps);
        changed.setCurrMaxDropKbps(changedCurrMaxDropKbps);
        changed.setCurrMaxDropPps(changedCurrMaxDropPps);
        return changed;
    }

    private void caculateDropByCpuAndVpn(OriginalExceptionEvent event) {
        long dropPps = event.getDropPkgs() / 64L;
        long dropKbps = event.getDropKbits() / 64L;
        long startTime = event.getAlertStartTime() - 64000L;
        CpuAndVpnType cpuAndVpn = new CpuAndVpnType(event.getCpu(), event.getVpnIndex());
        this.cpuAndVpnsDropFlow.remove(cpuAndVpn);
        if (!event.isAttack()) {
            return;
        }
        Iterator<ExceptionDropEntity> it = this.cpuAndVpnsDropFlow.values().iterator();
        while (it.hasNext()) {
            ExceptionDropEntity entry = it.next();
            if (startTime < entry.getStopTime()) {
                dropPps += entry.getDropPps();
                dropKbps += entry.getDropKbps();
                continue;
            }
            it.remove();
        }
        this.cpuAndVpnsDropFlow.put(cpuAndVpn, new ExceptionDropEntity(event));
        this.maxDropKbps = dropKbps > this.maxDropKbps ? dropKbps : this.maxDropKbps;
        this.maxDropPps = dropPps > this.maxDropPps ? dropPps : this.maxDropPps;
    }

    public boolean isConnectionFlood() {
        return AttackTypeFactory.getInstance().isConnectionFlood(this.attackType);
    }

    private void updateState() {
        if (!this.attackCpus.isEmpty()) {
            this.setCurrentState(2);
        } else if (!this.alertCpus.isEmpty()) {
            this.setCurrentState(1);
        } else {
            this.setCurrentState(0);
        }
    }

    public boolean isSendAlarm() {
        return this.sendAlarm;
    }

    public void setSendAlarm(boolean sendAlarm) {
        this.sendAlarm = sendAlarm;
    }

    public boolean isHasInserted() {
        return this.hasInserted;
    }

    public void setHasInserted(boolean insert) {
        this.hasInserted = insert;
    }

    public long getMaxDropPps() {
        return this.maxDropPps;
    }

    public void setMaxDropPps(long maxDropPps) {
        this.maxDropPps = maxDropPps;
    }

    public long getMaxDropKbps() {
        return this.maxDropKbps;
    }

    public void setMaxDropKbps(long maxDropKbps) {
        this.maxDropKbps = maxDropKbps;
    }

    @Override
    public void average(int size) {
        this.setDropPkgs(this.devideUp(this.getDropPkgs(), size));
        this.setDropKbits(this.devideUp(this.getDropKbits(), size));
    }

    public Set<Integer> getAbnormalCpus() {
        HashSet<Integer> cpus = new HashSet<Integer>();
        cpus.addAll(this.alertCpus);
        cpus.addAll(this.attackCpus);
        return cpus;
    }

    public AttackType getAttackType() {
        return this.attackType;
    }

    @Override
    public ExceptionEvent getCopyEvent() {
        ExceptionEvent copy = new ExceptionEvent(this.getIdentifierCopy());
        copy.setAttackType(this.getAttackType());
        this.copy(copy);
        return copy;
    }

    public long getNormalValue() {
        return this.normalValue;
    }

    public long getRealValue() {
        return this.realValue;
    }

    @Override
    public Type getType() {
        return this.attackType;
    }

    public boolean isIsDefend() {
        return this.isDefend;
    }

    public boolean isTimeOut() {
        long durtionTime = System.currentTimeMillis() - this.getAlertEndTime();
        if (null != this.attackType && 73 == this.attackType.getTypeValue()) {
            return durtionTime >= 120000L || durtionTime >= timeOutPeroid;
        }
        return durtionTime >= timeOutPeroid;
    }

    @Override
    public void merge(List<? extends Event> events) {
        super.merge(events);
    }

    public void setAttackType(AttackType attackType) {
        this.attackType = attackType;
    }

    public void setDefend(boolean isDefends) {
        this.isDefend = isDefends;
    }

    public void setNormalValue(long normalValue) {
        this.normalValue = normalValue;
    }

    public void setRealValue(long realValue) {
        this.realValue = realValue;
    }

    public int getPpsOrKbps() {
        return this.ppsOrKbps;
    }

    public void setPpsOrKbps(int ppsOrKbps) {
        this.ppsOrKbps = ppsOrKbps;
    }

    public long getRealValue1() {
        return this.realValue1;
    }

    public void setRealValue1(long realValue1) {
        this.realValue1 = realValue1;
    }

    public long getNormalValue1() {
        return this.normalValue1;
    }

    public void setNormalValue1(long normalValue1) {
        this.normalValue1 = normalValue1;
    }

    public int getPpsOrKbps1() {
        return this.ppsOrKbps1;
    }

    public void setPpsOrKbps1(int ppsOrKbps1) {
        this.ppsOrKbps1 = ppsOrKbps1;
    }

    public long getCurrMaxDropPps() {
        return this.currMaxDropPps;
    }

    public void setCurrMaxDropPps(long currMaxDropPps) {
        this.currMaxDropPps = currMaxDropPps;
    }

    public long getCurrMaxDropKbps() {
        return this.currMaxDropKbps;
    }

    public void setCurrMaxDropKbps(long currMaxDropKbps) {
        this.currMaxDropKbps = currMaxDropKbps;
    }

    @Override
    public List<String> getSysLogInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("log_type=ip_attack");
        info.add("device_ip=" + this.getDeviceIp());
        info.add("device_type=" + (this.getDeviceType() == 0 ? CLEAN_DEVICE : DETECT_DEVICE));
        info.add("direction=" + CommonUtil.getDirectionStr(this.getDirection()));
        info.add("zone_id=" + this.getZoneId());
        info.add("zone_name=" + ZoneUitl.getInstance().getZoneNameById(this.getZoneId()));
        info.add("biz_id=" + this.getBizId());
        info.add("zone_ip=" + this.getZoneIp());
        info.add("start_time_alert=\"" + EventUtil.getTimeStamp(this.getAlertStartTime()) + "\"");
        if (this.isIsEverAttacked()) {
            info.add("start_time_attack=\"" + EventUtil.getTimeStamp(this.getAttackStartTime()) + "\"");
        } else {
            info.add("start_time_attack=\"\"");
        }
        info.add("end_time=\"" + EventUtil.getTimeStamp(this.getAlertEndTime()) + "\"");
        info.add("duration=" + this.getDuration() + "");
        info.add("attack_type=" + this.getAttackType().getTypeValue());
        info.add("protocol=" + this.getAttackType().getProtocol());
        info.add("port=" + this.getAttackType().getPort());
        info.add("attack_status=" + ExceptionEvent.getStateDescription(this.getCurrentState()));
        if (this.isIsEverAttacked()) {
            info.add("drop_kbits=" + this.getDropKbits());
            info.add("drop_packets=" + this.getDropPkgs());
        }
        if (!this.getAttackers().isEmpty()) {
            info.add("attacker=" + CommonUtil.tansIpSet2String(this.getAttackers()));
        }
        return info;
    }

    @Override
    public void toXml(Element element) {
        element.addAttribute(BIZ_ID, this.getBizId() + "");
        element.addAttribute(ALERT_START_TIME, EventUtil.getTimeStamp(this.getAlertStartTime()));
        if (this.isIsEverAttacked()) {
            element.addAttribute(ATTACK_START_TIME, EventUtil.getTimeStamp(this.getAttackStartTime()));
        } else {
            element.addAttribute(ATTACK_START_TIME, "");
        }
        element.addAttribute(END_TIME, EventUtil.getTimeStamp(this.getAlertEndTime()));
        element.addAttribute(DURATION, this.getDuration() + "");
        element.addAttribute(ATTACK_TYPE, this.getAttackType().getTypeValue() + "");
        if (this.getAttackType().isCustomServiceAttack()) {
            element.addAttribute(PROTOCOL, this.getAttackType().getProtocol() + "");
            element.addAttribute(PORT, this.getAttackType().getPort() + "");
        } else {
            element.addAttribute(PROTOCOL, "");
            element.addAttribute(PORT, "");
        }
        element.addAttribute(ATTACK_STATUS, ExceptionEvent.getStateDescription(this.getCurrentState()));
        element.addAttribute(DROP_PACKETS, this.getDropPkgs() + "");
        element.addAttribute(ATTAKER, CommonUtil.tansIpSet2String(this.getAttackers()));
        element.addAttribute(PORTS, CommonUtil.tansPortsSet2String(this.getPorts()));
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("attckType", (Object)this.attackType).append("attackStartTime", (Object)new Date(this.getAttackStartTime())).toString();
    }

    static {
        try {
            timeOutPeroid = Long.parseLong(EventUtil.getEventConfigProperty("TimeOutLength"));
        }
        catch (Exception e) {
            timeOutPeroid = 300000L;
        }
    }
}

