/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.FirstPageEvent;
import com.hs.atic.collector.entity.event.OtherBizFlowEvent;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import com.hs.atic.collector.entity.event.xml.ToXml;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.EventUtil;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dom4j.Element;

public class FlowEvent
extends Event
implements ToXml,
FirstPageEvent {
    protected static final String TOTAL_AVERAGE_PPS = "total_average_pps";
    protected static final String TOTAL_AVERAGE_KBPS = "total_average_kbps";
    private static final String TOTALPPS = "total_pps";
    private static final String TOTALKBPS = "total_kbps";
    private static final String TCPPPS = "tcp_pps";
    private static final String TCPKBPS = "tcp_kbps";
    private static final String TCPFRAGPPS = "tcpfrag_pps";
    private static final String TCPFRAGKBPS = "tcpfrag_kbps";
    private static final String UDPPPS = "udp_pps";
    private static final String UDPKBPS = "udp_kbps";
    private static final String UDPFRAGPPS = "udpfrag_pps";
    private static final String UDPFRAGKBPS = "udpfrag_kbps";
    private static final String ICMPPPS = "icmp_pps";
    private static final String ICMPKBPS = "icmp_kbps";
    private static final String OTHERPPS = "other_pps";
    private static final String OTHERKBPS = "other_kbps";
    private static final String SYNPPS = "syn_pps";
    private static final String SYNACKPPS = "synack_pps";
    private static final String ACKPPS = "ack_pps";
    private static final String FINRSTPPS = "finrst_pps";
    private static final String TIME = "log_time";
    private static final String BIZ_ID = "biz_id";
    private static final String HTTPPPS = "http_pps";
    private static final String HTTPKBPS = "http_kbps";
    private static final String HTTPSPPS = "https_pps";
    private static final String HTTPSKBPS = "https_kbps";
    private static final String DNSREQUESTPPS = "dns_request_pps";
    private static final String DNSREQUESTKBPS = "dns_request_kbps";
    private static final String DNSREPLYPPS = "dns_reply_pps";
    private static final String DNSREPLYKBPS = "dns_reply_kbps";
    private static final String SIPINVITEPPS = "sip_invite_pps";
    private static final String SIPINVITEKBPS = "sip_invite_kbps";
    private static final String HTTPGETPPS = "http_get_pps";
    private static final String SIPINVITEQPS = "sip_invite_qps";
    private long url;
    private long ackKbps;
    private long ackPps;
    private long finRstKbps;
    private long finRstPps;
    private long icmpKbps;
    private long icmpPps;
    private long otherKbps;
    private long otherPps;
    private long synKbps;
    private long synPps;
    private long synAckPps;
    private long tcpFragKbps;
    private long tcpFragPps;
    private long tcpKbps;
    private long tcpPps;
    private long udpFragKbps;
    private long udpFragPps;
    private long udpKbps;
    private long udpPps;
    private long httpPps;
    private long httpKbps;
    private long httpGetPps;
    private long httpsPps;
    private long httpsKbps;
    private long dnsRequestPps;
    private long dnsRequestKbps;
    private long dnsReplyPps;
    private long dnsReplyKbps;
    private long sipInvitePps;
    private long sipInviteKbps;
    private long sipInviteQps;
    private long allPps;
    private long allKbps;

    public FlowEvent(EventIdentifier identifer) {
        super(identifer);
    }

    @Override
    public void average(int size) {
        this.setAllPps(this.devideUp(this.allPps, size));
        this.setAllKbps(this.devideUp(this.allKbps, size));
        this.setTcpPps(this.devideUp(this.getTcpPps(), size));
        this.setTcpKbps(this.devideUp(this.getTcpKbps(), size));
        this.setUdpPps(this.devideUp(this.getUdpPps(), size));
        this.setUdpKbps(this.devideUp(this.getUdpKbps(), size));
        this.setIcmpPps(this.devideUp(this.getIcmpPps(), size));
        this.setIcmpKbps(this.devideUp(this.getIcmpKbps(), size));
        this.setOtherPps(this.devideUp(this.getOtherPps(), size));
        this.setOtherKbps(this.devideUp(this.getOtherKbps(), size));
        this.setHttpPps(this.devideUp(this.httpPps, size));
        this.setHttpKbps(this.devideUp(this.httpKbps, size));
        this.setHttpGetPps(this.devideUp(this.httpGetPps, size));
        this.setHttpsPps(this.devideUp(this.httpsPps, size));
        this.setHttpsKbps(this.devideUp(this.httpsKbps, size));
        this.setDnsRequestPps(this.devideUp(this.dnsRequestPps, size));
        this.setDnsRequestKbps(this.devideUp(this.dnsRequestKbps, size));
        this.setDnsReplyPps(this.devideUp(this.dnsReplyPps, size));
        this.setDnsReplyKbps(this.devideUp(this.dnsReplyKbps, size));
        this.setSipInvitePps(this.devideUp(this.sipInvitePps, size));
        this.setSipInviteKbps(this.devideUp(this.sipInviteKbps, size));
        this.setSipInviteQps(this.devideUp(this.sipInviteQps, size));
        this.setTcpFragPps(this.devideUp(this.tcpFragPps, size));
        this.setTcpFragKbps(this.devideUp(this.tcpFragKbps, size));
        this.setUdpFragPps(this.devideUp(this.udpFragPps, size));
        this.setUdpFragKbps(this.devideUp(this.udpFragKbps, size));
        this.setSynPps(this.devideUp(this.synPps, size));
        this.setSynKbps(this.devideUp(this.synKbps, size));
        this.setSynAckPps(this.devideUp(this.synAckPps, size));
        this.setAckPps(this.devideUp(this.ackPps, size));
        this.setAckKbps(this.devideUp(this.ackKbps, size));
        this.setFinRstPps(this.devideUp(this.finRstPps, size));
        this.setFinRstKbps(this.devideUp(this.finRstKbps, size));
    }

    public void caculateTotal() {
        this.allKbps = this.tcpKbps + this.udpKbps + this.icmpKbps + this.otherKbps;
        this.allPps = this.tcpPps + this.udpPps + this.icmpPps + this.otherPps;
    }

    public long getAckPps() {
        return this.ackPps;
    }

    public long getAllKbps() {
        return this.allKbps;
    }

    public long getAllPps() {
        return this.allPps;
    }

    public long getDnsReplyKbps() {
        return this.dnsReplyKbps;
    }

    public long getDnsReplyPps() {
        return this.dnsReplyPps;
    }

    public long getDnsRequestKbps() {
        return this.dnsRequestKbps;
    }

    public long getDnsRequestPps() {
        return this.dnsRequestPps;
    }

    public long getFinRstPps() {
        return this.finRstPps;
    }

    public long getHttpKbps() {
        return this.httpKbps;
    }

    public long getHttpPps() {
        return this.httpPps;
    }

    public long getHttpsKbps() {
        return this.httpsKbps;
    }

    public long getHttpsPps() {
        return this.httpsPps;
    }

    public long getHttpGetPps() {
        return this.httpGetPps;
    }

    public long getIcmpKbps() {
        return this.icmpKbps;
    }

    public long getIcmpPps() {
        return this.icmpPps;
    }

    public long getOtherKbps() {
        return this.otherKbps;
    }

    public long getOtherPps() {
        return this.otherPps;
    }

    public long getSipInviteKbps() {
        return this.sipInviteKbps;
    }

    public long getSipInvitePps() {
        return this.sipInvitePps;
    }

    public long getSynAckPps() {
        return this.synAckPps;
    }

    public long getSynPps() {
        return this.synPps;
    }

    @Override
    public List<String> getSysLogInfo() {
        List<String> info = super.getSysLogInfo();
        info.add("total_pps=" + this.getAllPps());
        info.add("total_kbps=" + this.getAllKbps());
        info.add("tcp_pps=" + this.getTcpPps());
        info.add("tcp_kbps=" + this.getTcpKbps());
        info.add("tcpfrag_pps=" + this.getTcpFragPps());
        info.add("tcpfrag_kbps=" + this.getTcpFragKbps());
        info.add("udp_pps=" + this.getUdpPps());
        info.add("udp_kbps=" + this.getUdpKbps());
        info.add("udpfrag_pps=" + this.getUdpFragPps());
        info.add("udpfrag_kbps=" + this.getUdpFragKbps());
        info.add("icmp_pps=" + this.getIcmpPps());
        info.add("icmp_kbps=" + this.getIcmpKbps());
        info.add("other_pps=" + this.getOtherPps());
        info.add("other_kbps=" + this.getOtherKbps());
        info.add("syn_pps=" + this.getSynPps());
        info.add("synack_pps=" + this.getSynAckPps());
        info.add("ack_pps=" + this.getAckPps());
        info.add("finrst_pps=" + this.getFinRstPps());
        info.add("http_pps=" + this.getHttpPps());
        info.add("http_kbps=" + this.getHttpKbps());
        info.add("http_get_pps=" + this.getHttpGetPps());
        info.add("https_pps=" + this.getHttpsPps());
        info.add("https_kbps=" + this.getHttpsKbps());
        info.add("dns_request_pps=" + this.getDnsRequestPps());
        info.add("dns_request_kbps=" + this.getDnsRequestKbps());
        info.add("dns_reply_pps=" + this.getDnsReplyPps());
        info.add("dns_reply_kbps=" + this.getDnsReplyKbps());
        info.add("sip_invite_pps=" + this.getSipInvitePps());
        info.add("sip_invite_kbps=" + this.getSipInviteKbps());
        return info;
    }

    public void getDeviceAvgSyslogInfo(List<String> info) {
        info.add("avg_total_pps=" + this.getTotalPps());
        info.add("avg_total_kbps=" + this.getTotalKbps());
        info.add("avg_tcp_pps=" + this.getTcpPps());
        info.add("avg_tcp_kbps=" + this.getTcpKbps());
        info.add("avg_udp_pps=" + this.getUdpPps());
        info.add("avg_udp_kbps=" + this.getUdpKbps());
        info.add("avg_icmp_pps=" + this.getIcmpPps());
        info.add("avg_icmp_kbps=" + this.getIcmpKbps());
        info.add("avg_other_pps=" + this.getOtherPps());
        info.add("avg_other_kbps=" + this.getOtherKbps());
    }

    public void getDeviceMaxSyslogInfo(List<String> info) {
        info.add("time=\"" + EventUtil.getTimeStamp(System.currentTimeMillis()) + "\"");
        info.add("device_ip=" + this.getDeviceIp());
        info.add("device_type=" + this.getDeviceType());
        info.add("direction=" + this.getDirection());
        info.add("max_total_pps=" + this.getTotalPps());
        info.add("max_total_kbps=" + this.getTotalKbps());
        info.add("max_tcp_pps=" + this.getTcpPps());
        info.add("max_tcp_kbps=" + this.getTcpKbps());
        info.add("max_udp_pps=" + this.getUdpPps());
        info.add("max_udp_kbps=" + this.getUdpKbps());
        info.add("max_icmp_pps=" + this.getIcmpPps());
        info.add("max_icmp_kbps=" + this.getIcmpKbps());
        info.add("max_other_pps=" + this.getOtherPps());
        info.add("max_other_kbps=" + this.getOtherKbps());
    }

    public long getTcpFragKbps() {
        return this.tcpFragKbps;
    }

    public long getTcpFragPps() {
        return this.tcpFragPps;
    }

    public long getTcpKbps() {
        return this.tcpKbps;
    }

    public long getTcpPps() {
        return this.tcpPps;
    }

    public long getUdpFragKbps() {
        return this.udpFragKbps;
    }

    public long getUdpFragPps() {
        return this.udpFragPps;
    }

    public long getUdpKbps() {
        return this.udpKbps;
    }

    public long getUdpPps() {
        return this.udpPps;
    }

    public long getUrl() {
        return this.url;
    }

    @Override
    public boolean isValid() {
        return this.getAllPps() != 0L || this.getAllKbps() != 0L;
    }

    @Override
    public void max(Event e) {
        if (null != e && e instanceof FlowEvent) {
            FlowEvent flowEvent = (FlowEvent)e;
            this.setAllPps(this.getAllPps() > flowEvent.getAllPps() ? this.getAllPps() : flowEvent.getAllPps());
            this.setAllKbps(this.getAllKbps() > flowEvent.getAllKbps() ? this.getAllKbps() : flowEvent.getAllKbps());
            this.setTcpPps(this.getTcpPps() > flowEvent.getTcpPps() ? this.getTcpPps() : flowEvent.getTcpPps());
            this.setTcpKbps(this.getTcpKbps() > flowEvent.getTcpKbps() ? this.getTcpKbps() : flowEvent.getTcpKbps());
            this.setUdpPps(this.getUdpPps() > flowEvent.getUdpPps() ? this.getUdpPps() : flowEvent.getUdpPps());
            this.setUdpKbps(this.getUdpKbps() > flowEvent.getUdpKbps() ? this.getUdpKbps() : flowEvent.getUdpKbps());
            this.setIcmpPps(this.getIcmpPps() > flowEvent.getIcmpPps() ? this.getIcmpPps() : flowEvent.getIcmpPps());
            this.setIcmpKbps(this.getIcmpKbps() > flowEvent.getIcmpKbps() ? this.getIcmpKbps() : flowEvent.getIcmpKbps());
            this.setOtherPps(this.getOtherPps() > flowEvent.getOtherPps() ? this.getOtherPps() : flowEvent.getOtherPps());
            this.setOtherKbps(this.getOtherKbps() > flowEvent.getOtherKbps() ? this.getOtherKbps() : flowEvent.getOtherKbps());
            this.setHttpPps(this.getHttpPps() > flowEvent.getHttpPps() ? this.getHttpPps() : flowEvent.getHttpPps());
            this.setHttpKbps(this.getHttpKbps() > flowEvent.getHttpKbps() ? this.getHttpKbps() : flowEvent.getHttpKbps());
            this.setHttpGetPps(this.getHttpGetPps() > flowEvent.getHttpGetPps() ? this.getHttpGetPps() : flowEvent.getHttpGetPps());
            this.setHttpsPps(this.getHttpsPps() > flowEvent.getHttpsPps() ? this.getHttpsPps() : flowEvent.getHttpsPps());
            this.setHttpsKbps(this.getHttpsKbps() > flowEvent.getHttpsKbps() ? this.getHttpsKbps() : flowEvent.getHttpsKbps());
            this.setDnsRequestPps(this.getDnsRequestPps() > flowEvent.getDnsRequestPps() ? this.getDnsRequestPps() : flowEvent.getDnsRequestPps());
            this.setDnsRequestKbps(this.getDnsRequestKbps() > flowEvent.getDnsRequestKbps() ? this.getDnsRequestKbps() : flowEvent.getDnsRequestKbps());
            this.setDnsReplyPps(this.getDnsReplyPps() > flowEvent.getDnsReplyPps() ? this.getDnsReplyPps() : flowEvent.getDnsReplyPps());
            this.setDnsReplyKbps(this.getDnsReplyKbps() > flowEvent.getDnsReplyKbps() ? this.getDnsReplyKbps() : flowEvent.getDnsReplyKbps());
            this.setSipInvitePps(this.getSipInvitePps() > flowEvent.getSipInvitePps() ? this.getSipInvitePps() : flowEvent.getSipInvitePps());
            this.setSipInviteKbps(this.getSipInviteKbps() > flowEvent.getSipInviteKbps() ? this.getSipInviteKbps() : flowEvent.getSipInviteKbps());
            this.setSipInviteQps(this.getSipInviteQps() > flowEvent.getSipInviteQps() ? this.getSipInviteQps() : flowEvent.getSipInviteQps());
            this.setTcpFragPps(this.getTcpFragPps() > flowEvent.getTcpFragPps() ? this.getTcpFragPps() : flowEvent.getTcpFragPps());
            this.setTcpFragKbps(this.getTcpFragKbps() > flowEvent.getTcpFragKbps() ? this.getTcpFragKbps() : flowEvent.getTcpFragKbps());
            this.setUdpFragPps(this.getUdpFragPps() > flowEvent.getUdpFragPps() ? this.getUdpFragPps() : flowEvent.getUdpFragPps());
            this.setUdpFragKbps(this.getUdpFragKbps() > flowEvent.getUdpFragKbps() ? this.getUdpFragKbps() : flowEvent.getUdpFragKbps());
            this.setSynPps(this.getSynPps() > flowEvent.getSynPps() ? this.getSynPps() : flowEvent.getSynPps());
            this.setSynKbps(this.getSynKbps() > flowEvent.getSynKbps() ? this.getSynKbps() : flowEvent.getSynKbps());
            this.setSynAckPps(this.getSynAckPps() > flowEvent.getSynAckPps() ? this.getSynAckPps() : flowEvent.getSynAckPps());
            this.setAckPps(this.getAckPps() > flowEvent.getAckPps() ? this.getAckPps() : flowEvent.getAckPps());
            this.setAckKbps(this.getAckKbps() > flowEvent.getAckKbps() ? this.getAckKbps() : flowEvent.getAckKbps());
            this.setFinRstPps(this.getFinRstPps() > flowEvent.getFinRstPps() ? this.getFinRstPps() : flowEvent.getFinRstPps());
            this.setFinRstKbps(this.getFinRstKbps() > flowEvent.getFinRstKbps() ? this.getFinRstKbps() : flowEvent.getFinRstKbps());
            this.setUrl(this.getUrl() > flowEvent.getUrl() ? this.getUrl() : flowEvent.getUrl());
        }
    }

    protected void merge(Event event) {
        FlowEvent flowEvent = (FlowEvent)event;
        this.setUrl(this.url + flowEvent.getUrl());
        this.setAllPps(this.allPps + flowEvent.getAllPps());
        this.setAllKbps(this.allKbps + flowEvent.getAllKbps());
        this.setTcpPps(this.tcpPps + flowEvent.getTcpPps());
        this.setTcpKbps(this.tcpKbps + flowEvent.getTcpKbps());
        this.setUdpPps(this.udpPps + flowEvent.getUdpPps());
        this.setUdpKbps(this.udpKbps + flowEvent.getUdpKbps());
        this.setIcmpPps(this.icmpPps + flowEvent.getIcmpPps());
        this.setIcmpKbps(this.icmpKbps + flowEvent.getIcmpKbps());
        this.setOtherPps(this.otherPps + flowEvent.getOtherPps());
        this.setOtherKbps(this.otherKbps + flowEvent.getOtherKbps());
        this.setHttpPps(this.httpPps + flowEvent.getHttpPps());
        this.setHttpKbps(this.httpKbps + flowEvent.getHttpKbps());
        this.setHttpGetPps(this.httpGetPps + flowEvent.getHttpGetPps());
        this.setHttpsPps(this.httpsPps + flowEvent.getHttpsPps());
        this.setHttpsKbps(this.httpsKbps + flowEvent.getHttpsKbps());
        this.setDnsRequestPps(this.dnsRequestPps + flowEvent.getDnsRequestPps());
        this.setDnsRequestKbps(this.dnsRequestKbps + flowEvent.getDnsRequestKbps());
        this.setDnsReplyPps(this.dnsReplyPps + flowEvent.getDnsReplyPps());
        this.setDnsReplyKbps(this.dnsReplyKbps + flowEvent.getDnsReplyKbps());
        this.setSipInvitePps(this.sipInvitePps + flowEvent.getSipInvitePps());
        this.setSipInviteKbps(this.sipInviteKbps + flowEvent.getSipInviteKbps());
        this.setSipInviteQps(this.sipInviteQps + flowEvent.getSipInviteQps());
        this.setTcpFragPps(this.tcpFragPps + flowEvent.getTcpFragPps());
        this.setTcpFragKbps(this.tcpFragKbps + flowEvent.getTcpFragKbps());
        this.setUdpFragPps(this.udpFragPps + flowEvent.getUdpFragPps());
        this.setUdpFragKbps(this.udpFragKbps + flowEvent.getUdpFragKbps());
        this.setSynPps(this.synPps + flowEvent.getSynPps());
        this.setSynKbps(this.synKbps + flowEvent.getSynKbps());
        this.setSynAckPps(this.synAckPps + flowEvent.getSynAckPps());
        this.setAckPps(this.ackPps + flowEvent.getAckPps());
        this.setAckKbps(this.ackKbps + flowEvent.getAckKbps());
        this.setFinRstPps(this.finRstPps + flowEvent.getFinRstPps());
        this.setFinRstKbps(this.finRstKbps + flowEvent.getFinRstKbps());
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            this.merge(event);
        }
    }

    public void setAckPps(long ackPps) {
        this.ackPps = ackPps;
    }

    public void setAllKbps(long allKbps) {
        this.allKbps = allKbps;
    }

    public void setAllPps(long allPps) {
        this.allPps = allPps;
    }

    public void setDnsReplyKbps(long dnsReplyKbps) {
        this.dnsReplyKbps = dnsReplyKbps;
    }

    public void setDnsReplyPps(long dnsReplyPps) {
        this.dnsReplyPps = dnsReplyPps;
    }

    public void setDnsRequestKbps(long dnsRequestKbps) {
        this.dnsRequestKbps = dnsRequestKbps;
    }

    public void setDnsRequestPps(long dnsRequestPps) {
        this.dnsRequestPps = dnsRequestPps;
    }

    public void setFinRstPps(long finPps) {
        this.finRstPps = finPps;
    }

    public void setHttpKbps(long httpKbps) {
        this.httpKbps = httpKbps;
    }

    public void setHttpPps(long httpPps) {
        this.httpPps = httpPps;
    }

    public void setHttpsKbps(long httpsKbps) {
        this.httpsKbps = httpsKbps;
    }

    public void setHttpGetPps(long httpGetPps) {
        this.httpGetPps = httpGetPps;
    }

    public void setHttpsPps(long httpsPps) {
        this.httpsPps = httpsPps;
    }

    public void setIcmpKbps(long icmpKbps) {
        this.icmpKbps = icmpKbps;
    }

    public void setIcmpPps(long icmpPps) {
        this.icmpPps = icmpPps;
    }

    public void setOtherKbps(long otherKbps) {
        this.otherKbps = otherKbps;
    }

    public void setOtherPps(long otherPps) {
        this.otherPps = otherPps;
    }

    public void setSipInviteKbps(long sipInviteKbps) {
        this.sipInviteKbps = sipInviteKbps;
    }

    public void setSipInvitePps(long sipInvitePps) {
        this.sipInvitePps = sipInvitePps;
    }

    public void setSynAckPps(long synAckPps) {
        this.synAckPps = synAckPps;
    }

    public void setSynPps(long synPps) {
        this.synPps = synPps;
    }

    public void setTcpFragKbps(long tcpFragKbps) {
        this.tcpFragKbps = tcpFragKbps;
    }

    public void setTcpFragPps(long tcpFragPps) {
        this.tcpFragPps = tcpFragPps;
    }

    public void setTcpKbps(long tcpKbps) {
        this.tcpKbps = tcpKbps;
    }

    public void setTcpPps(long tcpPps) {
        this.tcpPps = tcpPps;
    }

    public void setUdpFragKbps(long udpFragKbps) {
        this.udpFragKbps = udpFragKbps;
    }

    public void setUdpFragPps(long udpFragPps) {
        this.udpFragPps = udpFragPps;
    }

    public void setUdpKbps(long udpKbps) {
        this.udpKbps = udpKbps;
    }

    public void setUdpPps(long udpPps) {
        this.udpPps = udpPps;
    }

    public void setUrl(long url) {
        this.url = url;
    }

    public long getAckKbps() {
        return this.ackKbps;
    }

    public void setAckKbps(long ackKbps) {
        this.ackKbps = ackKbps;
    }

    public long getFinRstKbps() {
        return this.finRstKbps;
    }

    public void setFinRstKbps(long finRstKbps) {
        this.finRstKbps = finRstKbps;
    }

    public long getSynKbps() {
        return this.synKbps;
    }

    public void setSynKbps(long synKbps) {
        this.synKbps = synKbps;
    }

    private void isLessPartOne(FlowEvent flowEvent) {
        if (this.getAllPps() < flowEvent.getAllPps()) {
            flowEvent.setAllPps(this.getAllPps());
        }
        if (this.getAllKbps() < flowEvent.getAllKbps()) {
            flowEvent.setAllKbps(this.getAllKbps());
        }
        if (this.getTcpPps() < flowEvent.getTcpPps()) {
            flowEvent.setTcpPps(this.getTcpPps());
        }
        if (this.getTcpKbps() < flowEvent.getTcpKbps()) {
            flowEvent.setTcpKbps(this.getTcpKbps());
        }
        if (this.getUdpPps() < flowEvent.getUdpPps()) {
            flowEvent.setUdpPps(this.getUdpPps());
        }
        if (this.getUdpKbps() < flowEvent.getUdpKbps()) {
            flowEvent.setUdpKbps(this.getUdpKbps());
        }
    }

    private void isLessPartTwo(FlowEvent flowEvent) {
        if (this.getIcmpPps() < flowEvent.getIcmpPps()) {
            flowEvent.setIcmpPps(this.getIcmpPps());
        }
        if (this.getIcmpKbps() < flowEvent.getIcmpKbps()) {
            flowEvent.setIcmpKbps(this.getIcmpKbps());
        }
        if (this.getOtherPps() < flowEvent.getOtherPps()) {
            flowEvent.setOtherPps(this.getOtherPps());
        }
        if (this.getOtherKbps() < flowEvent.getOtherKbps()) {
            flowEvent.setOtherKbps(this.getOtherKbps());
        }
        if (this.getHttpPps() < flowEvent.getHttpPps()) {
            flowEvent.setHttpPps(this.getHttpPps());
        }
        if (this.getHttpKbps() < flowEvent.getHttpKbps()) {
            flowEvent.setHttpKbps(this.getHttpKbps());
        }
        if (this.getHttpGetPps() < flowEvent.getHttpGetPps()) {
            flowEvent.setHttpGetPps(this.getHttpGetPps());
        }
    }

    private void isLessPartThree(FlowEvent flowEvent) {
        if (this.getHttpsPps() < flowEvent.getHttpsPps()) {
            flowEvent.setHttpsPps(this.getHttpsPps());
        }
        if (this.getHttpsKbps() < flowEvent.getHttpsKbps()) {
            flowEvent.setHttpsKbps(this.getHttpsKbps());
        }
        if (this.getDnsRequestPps() < flowEvent.getDnsRequestPps()) {
            flowEvent.setDnsRequestPps(this.getDnsRequestPps());
        }
        if (this.getDnsRequestKbps() < flowEvent.getDnsRequestKbps()) {
            flowEvent.setDnsRequestKbps(this.getDnsRequestKbps());
        }
        if (this.getDnsReplyPps() < flowEvent.getDnsReplyPps()) {
            flowEvent.setDnsReplyPps(this.getDnsReplyPps());
        }
        if (this.getDnsReplyKbps() < flowEvent.getDnsReplyKbps()) {
            flowEvent.setDnsReplyKbps(this.getDnsReplyKbps());
        }
    }

    private void isLessPartFour(FlowEvent flowEvent) {
        if (this.getSipInvitePps() < flowEvent.getSipInvitePps()) {
            flowEvent.setSipInvitePps(this.getSipInvitePps());
        }
        if (this.getSipInviteKbps() < flowEvent.getSipInviteKbps()) {
            flowEvent.setSipInviteKbps(this.getSipInviteKbps());
        }
        if (this.getSipInviteQps() < flowEvent.getSipInviteQps()) {
            flowEvent.setSipInviteQps(this.getSipInviteQps());
        }
        if (this.getTcpFragPps() < flowEvent.getTcpFragPps()) {
            flowEvent.setTcpFragPps(this.getTcpFragPps());
        }
        if (this.getTcpFragKbps() < flowEvent.getTcpFragKbps()) {
            flowEvent.setTcpFragKbps(this.getTcpFragKbps());
        }
        if (this.getUdpFragPps() < flowEvent.getUdpFragPps()) {
            flowEvent.setUdpFragPps(this.getUdpFragPps());
        }
        if (this.getUdpFragKbps() < flowEvent.getUdpFragKbps()) {
            flowEvent.setUdpFragKbps(this.getUdpFragKbps());
        }
    }

    private void isLessPartFive(FlowEvent flowEvent) {
        if (this.getSynPps() < flowEvent.getSynPps()) {
            flowEvent.setSynPps(this.getSynPps());
        }
        if (this.getSynAckPps() < flowEvent.getSynAckPps()) {
            flowEvent.setSynAckPps(this.getSynAckPps());
        }
        if (this.getAckPps() < flowEvent.getAckPps()) {
            flowEvent.setAckPps(this.getAckPps());
        }
        if (this.getFinRstPps() < flowEvent.getFinRstPps()) {
            flowEvent.setFinRstPps(this.getFinRstPps());
        }
        if (this.getUrl() < flowEvent.getUrl()) {
            flowEvent.setUrl(this.getUrl());
        }
    }

    @Override
    public boolean isLess(Event t) {
        if (t instanceof FlowEvent) {
            FlowEvent flowEvent = (FlowEvent)t;
            this.isLessPartOne(flowEvent);
            this.isLessPartTwo(flowEvent);
            this.isLessPartThree(flowEvent);
            this.isLessPartFour(flowEvent);
            this.isLessPartFive(flowEvent);
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.isValid()) {
            return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("url", this.url).append("allPps", this.getAllPps()).append("allBkps", this.getAllKbps()).append("tcpPps", this.tcpPps).append("tcpKbps", this.tcpKbps).append("udpPps", this.udpPps).append("udpKbps", this.udpKbps).append("icmpPps", this.icmpPps).append("icmpKbps", this.icmpKbps).append("otherPps", this.otherPps).append("otherKbps", this.otherKbps).append("httpPps", this.httpPps).append("httpKbps", this.httpKbps).append("httpGetPps", this.httpGetPps).append("httpsPps", this.httpsPps).append("httpsKbps", this.httpsKbps).append("sipPps", this.sipInvitePps).append("sipKbps", this.sipInviteKbps).append("sipQps", this.sipInviteQps).append("tcpFragPps", this.tcpFragPps).append("tcpFragKbps", this.tcpFragKbps).append("udpFragPps", this.udpFragPps).append("udpFragKbps", this.udpFragKbps).append("dnsRequestPps", this.dnsRequestPps).append("dnsRequestKbps", this.dnsRequestKbps).append("dnsReplyPps", this.dnsReplyPps).append("dnsReplyKbps", this.dnsReplyKbps).append("ackPps", this.ackPps).append("ackKbps", this.ackKbps).append("finRstPps", this.finRstPps).append("finRstKbps", this.finRstKbps).append("synPps", this.synPps).append("synKbps", this.synKbps).append("synackPps", this.synAckPps).toString();
        }
        return "invalide flow event";
    }

    @Override
    public void toXml(Element element) {
        element.addAttribute(TIME, EventUtil.getTimeStamp(this.getLogTime()));
        element.addAttribute(BIZ_ID, this.getBizId() + "");
        element.addAttribute(TOTALPPS, this.getAllPps() + "");
        element.addAttribute(TOTALKBPS, this.getAllKbps() + "");
        element.addAttribute(TCPKBPS, this.getTcpKbps() + "");
        element.addAttribute(TCPPPS, this.getTcpPps() + "");
        element.addAttribute(TCPFRAGKBPS, this.getTcpFragKbps() + "");
        element.addAttribute(TCPFRAGPPS, this.getTcpFragPps() + "");
        element.addAttribute(UDPKBPS, this.getUdpKbps() + "");
        element.addAttribute(UDPPPS, this.getUdpPps() + "");
        element.addAttribute(UDPFRAGKBPS, this.getUdpFragKbps() + "");
        element.addAttribute(UDPFRAGPPS, this.getUdpFragPps() + "");
        element.addAttribute(ICMPKBPS, this.getIcmpKbps() + "");
        element.addAttribute(ICMPPPS, this.getIcmpPps() + "");
        element.addAttribute(OTHERPPS, this.getOtherPps() + "");
        element.addAttribute(OTHERKBPS, this.getOtherKbps() + "");
        element.addAttribute(SYNPPS, this.getSynAckPps() + "");
        element.addAttribute(SYNACKPPS, this.getSynAckPps() + "");
        element.addAttribute(ACKPPS, this.getAckPps() + "");
        element.addAttribute(FINRSTPPS, this.getFinRstPps() + "");
        element.addAttribute(HTTPPPS, this.getHttpPps() + "");
        element.addAttribute(HTTPKBPS, this.getHttpKbps() + "");
        element.addAttribute(HTTPGETPPS, this.getHttpGetPps() + "");
        element.addAttribute(HTTPSPPS, this.getHttpsPps() + "");
        element.addAttribute(HTTPSKBPS, this.getHttpKbps() + "");
        element.addAttribute(DNSREQUESTPPS, this.getDnsRequestPps() + "");
        element.addAttribute(DNSREQUESTKBPS, this.getDnsRequestKbps() + "");
        element.addAttribute(DNSREPLYPPS, this.getDnsReplyPps() + "");
        element.addAttribute(DNSREPLYKBPS, this.getDnsReplyKbps() + "");
        element.addAttribute(SIPINVITEPPS, this.getSipInvitePps() + "");
        element.addAttribute(SIPINVITEKBPS, this.getSipInviteKbps() + "");
        element.addAttribute(SIPINVITEQPS, this.getSipInviteQps() + "");
    }

    @Override
    public long getTotalKbps() {
        return this.getAllKbps();
    }

    @Override
    public long getTotalPps() {
        return this.getAllPps();
    }

    @Override
    public long getCurrConn() {
        return 0L;
    }

    @Override
    public long getNewConn() {
        return 0L;
    }

    @Override
    public boolean isFlowOverMax() {
        int aticFlowMaxNum = CommonUtil.getAticFlowMaxNum();
        Boolean allPpsKpbs = this.allPps > (long)aticFlowMaxNum || this.allKbps > (long)aticFlowMaxNum || this.ackPps > (long)aticFlowMaxNum || this.finRstPps > (long)aticFlowMaxNum;
        Boolean icmpPpsKpbs = this.icmpKbps > (long)aticFlowMaxNum || this.icmpPps > (long)aticFlowMaxNum || this.otherKbps > (long)aticFlowMaxNum || this.otherPps > (long)aticFlowMaxNum;
        Boolean synPpsKpbs = this.synPps > (long)aticFlowMaxNum || this.synAckPps > (long)aticFlowMaxNum || this.tcpFragKbps > (long)aticFlowMaxNum || this.tcpFragPps > (long)aticFlowMaxNum;
        Boolean tcpPpsKpbs = this.tcpKbps > (long)aticFlowMaxNum || this.tcpPps > (long)aticFlowMaxNum || this.udpFragKbps > (long)aticFlowMaxNum || this.udpFragPps > (long)aticFlowMaxNum;
        Boolean udpPpsKpbs = this.udpKbps > (long)aticFlowMaxNum || this.udpPps > (long)aticFlowMaxNum || this.httpPps > (long)aticFlowMaxNum || this.httpKbps > (long)aticFlowMaxNum || this.httpGetPps > (long)aticFlowMaxNum;
        Boolean httpsPpsKpbs = this.httpsPps > (long)aticFlowMaxNum || this.httpsKbps > (long)aticFlowMaxNum || this.dnsRequestPps > (long)aticFlowMaxNum || this.dnsRequestKbps > (long)aticFlowMaxNum;
        Boolean dnsPpsKpbs = this.dnsReplyPps > (long)aticFlowMaxNum || this.dnsReplyKbps > (long)aticFlowMaxNum || this.sipInvitePps > (long)aticFlowMaxNum || this.sipInviteKbps > (long)aticFlowMaxNum || this.sipInviteQps > (long)aticFlowMaxNum;
        Boolean otherPpsKpbs = tcpPpsKpbs != false || udpPpsKpbs != false || httpsPpsKpbs != false || dnsPpsKpbs != false;
        return allPpsKpbs != false || icmpPpsKpbs != false || synPpsKpbs != false || otherPpsKpbs != false;
    }

    public void mergeTcpBizFlowEvent(TcpBizFlowEvent tcpBizFlow) {
        this.setAllKbps(this.allKbps + tcpBizFlow.getTotalKbps());
        this.setAllPps(this.allPps + tcpBizFlow.getTotalPps());
        this.setTcpPps(this.tcpPps + tcpBizFlow.getTotalPps());
        this.setTcpKbps(this.tcpKbps + tcpBizFlow.getTotalKbps());
        this.setSynPps(this.synPps + tcpBizFlow.getSynPps());
        this.setAckPps(this.ackPps + tcpBizFlow.getAckPps());
        this.setSynAckPps(this.synAckPps + tcpBizFlow.getSynAckPps());
        this.setFinRstPps(this.finRstPps + tcpBizFlow.getFinRstPps());
    }

    public void mergeUdpBizFlowEvent(UdpBizFlowEvent udpBizFlow) {
        this.setAllKbps(this.allKbps + udpBizFlow.getTotalKbps());
        this.setAllPps(this.allPps + udpBizFlow.getTotalPps());
        this.setUdpKbps(this.udpKbps + udpBizFlow.getTotalKbps());
        this.setUdpPps(this.udpPps + udpBizFlow.getTotalPps());
    }

    public void mergeOtherBizFlowEvent(OtherBizFlowEvent otherBizFlow) {
        this.setAllKbps(this.allKbps + otherBizFlow.getTotalKbps());
        this.setAllPps(this.allPps + otherBizFlow.getTotalPps());
        this.setOtherKbps(this.otherKbps + otherBizFlow.getTotalKbps());
        this.setOtherPps(this.otherPps + otherBizFlow.getTotalPps());
    }

    public long getSipInviteQps() {
        return this.sipInviteQps;
    }

    public void setSipInviteQps(long sipInviteQps) {
        this.sipInviteQps = sipInviteQps;
    }
}

