/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.InFlowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class IntelligentDefenseEvent
extends Event {
    private long synPps;
    private long srcSynPps;
    private long ackPps;
    private long ackPpsRatio;
    private long srcAckKbps;
    private long synAckRatio;
    private long tcpIncreaseCon;
    private long tcpConcurCon;
    private long srcIncreaseCon;
    private long srcConcurCon;
    private long httpQps;
    private long udpKbps;
    private long dnsRequestPps;
    private Set<Integer> attackTypeSet = new HashSet<Integer>();
    private Set<Integer> blackTypeSet = new HashSet<Integer>();

    public IntelligentDefenseEvent(EventIdentifier identifer) {
        super(identifer);
    }

    public IntelligentDefenseEvent(InFlowEvent inFlow, DiscardFlowEvent dropFlow) {
        super(inFlow.getIdentifierCopy());
        this.synPps = inFlow.getSynPps() - dropFlow.getSynPps();
        this.ackPps = inFlow.getAckPps() - dropFlow.getAckPps();
        this.synAckRatio = 0L == this.synPps ? 100L : this.ackPps * 100L / this.synPps;
        this.ackPpsRatio = 0L == this.ackPps ? 100L : inFlow.getAckPps() * 100L / this.ackPps;
        this.srcSynPps = inFlow.getSynPktNum() / 10L;
        this.srcAckKbps = inFlow.getSrcAckKbps();
        this.tcpConcurCon = inFlow.getTcpConcurCon();
        this.tcpIncreaseCon = inFlow.getTcpIncreaseCon();
        this.srcConcurCon = inFlow.getTcpSrcConcurCon();
        this.srcIncreaseCon = inFlow.getTcpSrcIncreaseCon();
        this.httpQps = inFlow.getHttpGetPps() - dropFlow.getHttpGetPps();
        this.udpKbps = inFlow.getUdpKbps() - dropFlow.getUdpKbps();
        this.dnsRequestPps = inFlow.getDnsRequestPps() - dropFlow.getDnsRequestPps();
    }

    public IntelligentDefenseEvent(InFlowEvent inFlow) {
        super(inFlow.getIdentifierCopy());
        this.synPps = inFlow.getSynPps();
        this.ackPps = inFlow.getAckPps();
        this.synAckRatio = 0L == this.synPps ? 100L : this.ackPps * 100L / this.synPps;
        this.ackPpsRatio = 100L;
        this.srcSynPps = inFlow.getSynPktNum() / 10L;
        this.srcAckKbps = inFlow.getSrcAckKbps();
        this.tcpConcurCon = inFlow.getTcpConcurCon();
        this.tcpIncreaseCon = inFlow.getTcpIncreaseCon();
        this.srcConcurCon = inFlow.getTcpSrcConcurCon();
        this.srcIncreaseCon = inFlow.getTcpSrcIncreaseCon();
        this.httpQps = inFlow.getHttpGetPps();
        this.udpKbps = inFlow.getUdpKbps();
        this.dnsRequestPps = inFlow.getDnsRequestPps();
    }

    @Override
    public void average(int number) {
    }

    @Override
    public void merge(List<? extends Event> events) {
    }

    public long getSynPps() {
        return this.synPps;
    }

    public void setSynPps(long synPps) {
        this.synPps = synPps;
    }

    public long getSrcSynPps() {
        return this.srcSynPps;
    }

    public void setSrcSynPps(long srcSynPps) {
        this.srcSynPps = srcSynPps;
    }

    public long getAckPps() {
        return this.ackPps;
    }

    public void setAckPps(long ackPps) {
        this.ackPps = ackPps;
    }

    public long getSrcAckPps() {
        return this.srcAckKbps;
    }

    public void setSrcAckPps(long srcAckPps) {
        this.srcAckKbps = srcAckPps;
    }

    public long getTcpIncreaseCon() {
        return this.tcpIncreaseCon;
    }

    public void setTcpIncreaseCon(long tcpIncreaseCon) {
        this.tcpIncreaseCon = tcpIncreaseCon;
    }

    public long getTcpConcurCon() {
        return this.tcpConcurCon;
    }

    public void setTcpConcurCon(long tcpConcurCon) {
        this.tcpConcurCon = tcpConcurCon;
    }

    public long getSrcIncreaseCon() {
        return this.srcIncreaseCon;
    }

    public void setSrcIncreaseCon(long srcIncreaseCon) {
        this.srcIncreaseCon = srcIncreaseCon;
    }

    public long getSrcConcurCon() {
        return this.srcConcurCon;
    }

    public void setSrcConcurCon(long srcConcurCon) {
        this.srcConcurCon = srcConcurCon;
    }

    public long getHttpQps() {
        return this.httpQps;
    }

    public void setHttpQps(long httpQps) {
        this.httpQps = httpQps;
    }

    public long getUdpKbps() {
        return this.udpKbps;
    }

    public void setUdpKbps(long udpKbps) {
        this.udpKbps = udpKbps;
    }

    public long getDnsRequestPps() {
        return this.dnsRequestPps;
    }

    public void setDnsRequestPps(long dnsRequestPps) {
        this.dnsRequestPps = dnsRequestPps;
    }

    public long getSrcAckKbps() {
        return this.srcAckKbps;
    }

    public void setSrcAckKbps(long srcAckKbps) {
        this.srcAckKbps = srcAckKbps;
    }

    public long getSynAckRatio() {
        return this.synAckRatio;
    }

    public void setSynAckRatio(long synAckRatio) {
        this.synAckRatio = synAckRatio;
    }

    public Set<Integer> getAttackTypeSet() {
        return this.attackTypeSet;
    }

    public void setAttackTypeSet(Set<Integer> attackTypeSet) {
        this.attackTypeSet = attackTypeSet;
    }

    public Set<Integer> getBlackTypeSet() {
        return this.blackTypeSet;
    }

    public void setBlackTypeSet(Set<Integer> blackTypeSet) {
        this.blackTypeSet = blackTypeSet;
    }

    public long getAckPpsRatio() {
        return this.ackPpsRatio;
    }

    public void setAckPpsRatio(long ackPpsRatio) {
        this.ackPpsRatio = ackPpsRatio;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("synPps", this.synPps).append("srcSynPps", this.srcSynPps).append("ackPps", this.ackPps).append("ackPpsRatio", this.ackPpsRatio).append("srcAckKbps", this.srcAckKbps).append("synAckRatio", this.synAckRatio).append("tcpIncreaseCon", this.tcpIncreaseCon).append("tcpConcurCon", this.tcpConcurCon).append("srcIncreaseCon", this.srcIncreaseCon).append("srcConcurCon", this.srcConcurCon).append("httpQps", this.httpQps).append("udpKbps", this.udpKbps).append("dnsRequestPps", this.dnsRequestPps).append("attackTypeSet", (Object)this.attackTypeSet.toString()).append("blackTypeSet", (Object)this.blackTypeSet.toString()).toString();
    }

    public Map<String, String> eventsToCheck() {
        HashMap<String, String> events = new HashMap<String, String>();
        events.put("synPps", String.valueOf(this.getSynPps()));
        events.put("srcSynPps", String.valueOf(this.getSrcSynPps()));
        events.put("ackPps", String.valueOf(this.getAckPps()));
        events.put("ackPpsRatio", String.valueOf(this.getAckPpsRatio()));
        events.put("srcAckKbps", String.valueOf(this.getSrcAckKbps()));
        events.put("synAckRatio", String.valueOf(this.getSynAckRatio()));
        events.put("tcpIncreaseCon", String.valueOf(this.getTcpIncreaseCon()));
        events.put("tcpConcurCon", String.valueOf(this.getTcpConcurCon()));
        events.put("srcIncreaseCon", String.valueOf(this.getSrcIncreaseCon()));
        events.put("srcConcurCon", String.valueOf(this.getSrcConcurCon()));
        events.put("httpQps", String.valueOf(this.getHttpQps()));
        events.put("udpKbps", String.valueOf(this.getUdpKbps()));
        events.put("dnsRequestPps", String.valueOf(this.getDnsRequestPps()));
        List<String> attackTypeList = this.convertToStringList(new ArrayList<Integer>(this.getAttackTypeSet()));
        List<String> blackTypeList = this.convertToStringList(new ArrayList<Integer>(this.getBlackTypeSet()));
        events.put("attackTypeSet", String.join((CharSequence)",", attackTypeList));
        events.put("blackTypeSet", String.join((CharSequence)",", blackTypeList));
        return events;
    }

    private List<String> convertToStringList(List<Integer> integerList) {
        ArrayList<String> stringList = new ArrayList<String>();
        if (integerList != null) {
            for (Integer item : integerList) {
                String strItem = String.valueOf(item);
                stringList.add(strItem);
            }
        }
        return stringList;
    }
}

