/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class SrcTopnEvent
extends Event {
    public static final int TOPN_TYPE_IP_REPUTATION = 100;
    SrcTopnType type = new SrcTopnType();
    private String srcIp;
    private int topnType;
    private long requestPps;
    private long requestKbps;
    private long attackDstIp;
    private long unAttackDstIp;

    public SrcTopnEvent(EventIdentifier identifer) {
        super(identifer);
        this.type.setClazzName(this.getClass().getName());
    }

    @Override
    public void average(int size) {
        this.setRequestPps(this.devideUp(this.requestPps, size));
        this.setRequestKbps(this.devideUp(this.requestKbps, size));
    }

    public long getRequestKbps() {
        return this.requestKbps;
    }

    public long getRequestPps() {
        return this.requestPps;
    }

    public String getSrcIp() {
        return this.srcIp;
    }

    @Override
    public SrcTopnType getType() {
        return this.type;
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            this.merge(event);
        }
    }

    private void merge(Event e) {
        SrcTopnEvent event = (SrcTopnEvent)e;
        this.setRequestPps(this.requestPps + event.getRequestPps());
        this.setRequestKbps(this.requestKbps + event.getRequestKbps());
    }

    public void setRequestKbps(long requestKbps) {
        this.requestKbps = requestKbps;
    }

    public void setRequestPps(long requestPps) {
        this.requestPps = requestPps;
    }

    public void setSrcIp(String srcIp) {
        this.srcIp = srcIp;
        this.type.setSrcIp(srcIp);
    }

    public void setType(SrcTopnType type) {
        this.type = type;
    }

    public long getAttackDstIp() {
        return this.attackDstIp;
    }

    public void setAttackDstIp(long attackDstIp) {
        this.attackDstIp = attackDstIp;
    }

    public long getUnAttackDstIp() {
        return this.unAttackDstIp;
    }

    public void setUnAttackDstIp(long unAttackDstIp) {
        this.unAttackDstIp = unAttackDstIp;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("is dorp event: ", this.isIsDropFlow()).append("is hour event: ", this.isIsHourEvent()).append("is max event: ", this.isIsMaxEvent()).append("srcIp: ", (Object)this.srcIp).append("topnType: ", this.topnType).append("requestPps: ", this.requestPps).append("requestKbps: ", this.requestKbps).toString();
    }

    public int getTopnType() {
        return this.topnType;
    }

    public void setTopnType(int topnType) {
        this.topnType = topnType;
        this.type.setTopnType(topnType);
    }

    @Override
    public SrcTopnEvent getCopyEvent() {
        SrcTopnEvent copy = (SrcTopnEvent)super.getCopyEvent();
        copy.setSrcIp(this.getSrcIp());
        copy.setTopnType(this.topnType);
        return copy;
    }

    private static class SrcTopnType
    implements Type {
        private String srcIp;
        private String clazzName;
        private int topnType;

        private SrcTopnType() {
        }

        public boolean equals(Object o) {
            if (o instanceof SrcTopnType) {
                SrcTopnType type = (SrcTopnType)o;
                return this.srcIp.equals(type.getSrcIp()) && this.clazzName.equals(type.getClazzName()) && this.topnType == this.getTopnType();
            }
            return false;
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public String getSrcIp() {
            return this.srcIp;
        }

        public int hashCode() {
            int result = this.srcIp.hashCode() + 19;
            result = result + this.clazzName.hashCode() + 19;
            result = result + this.topnType + 19;
            return result;
        }

        public void setClazzName(String clazzName) {
            this.clazzName = clazzName;
        }

        public void setSrcIp(String srcIp) {
            this.srcIp = srcIp;
        }

        public int getTopnType() {
            return this.topnType;
        }

        public void setTopnType(int topnType) {
            this.topnType = topnType;
        }
    }
}

