/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.FirstPageEvent;
import com.hs.atic.collector.entity.event.xml.ToXml;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.EventUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dom4j.Element;

public class TcpBizFlowEvent
extends Event
implements ToXml,
FirstPageEvent {
    private static final String TIME = "log_time";
    private static final String TOTAL_PPS = "total_pps";
    private static final String TOTAL_KBPS = "total_kbps";
    private static final String SYN_PPS = "syn_pps";
    private static final String SYN_ACK_PPS = "syn_ack_pps";
    private static final String ACK_PPS = "ack_pps";
    private static final String FINRST_PPS = "finrst_pps";
    private static final String INCREASE_CON_PPS = "increase_con";
    private static final String CUR_CON_PPS = "cur_con";
    private static final String SPECIAL_PPS = "special_pps";
    private static final String SPECIAL_KBPS = "special_kbps";
    private static final String TYPE = "type";
    private static final String TYPE_VALUE = "tcp";
    private static final String BIZ_ID = "biz_id";
    private static final String IS_DROP = "is_drop";
    protected TcpBizFlowType type = new TcpBizFlowType();
    private long totalPps;
    private long totalKbps;
    private long totalReboundPps;
    private long totalReboundKbps;
    private long synPps;
    private long synAckPps;
    private long synReboundPps;
    private long synAckReboundPps;
    private long ackPps;
    private long finRstPps;
    private long increaseConPps;
    private long curConPps;
    private long specialPps;
    private long specialKbps;

    public TcpBizFlowEvent(EventIdentifier identifer) {
        super(identifer);
        this.type.setClazzName(this.getClass().getName());
    }

    @Override
    public void average(int size) {
        this.setTotalKbps(this.devideUp(this.totalKbps, size));
        this.setTotalPps(this.devideUp(this.totalPps, size));
        this.setSynPps(this.devideUp(this.synPps, size));
        this.setSynAckPps(this.devideUp(this.synAckPps, size));
        this.setAckPps(this.devideUp(this.ackPps, size));
        this.setFinRstPps(this.devideUp(this.finRstPps, size));
        this.setIncreaseConPps(this.devideUp(this.increaseConPps, size));
        this.setCurConPps(this.devideUp(this.curConPps, size));
        this.setSpecialPps(this.devideUp(this.specialPps, size));
        this.setSpecialKbps(this.devideUp(this.specialKbps, size));
        this.setTotalReboundPps(this.devideUp(this.totalReboundPps, size));
        this.setTotalReboundKbps(this.devideUp(this.totalReboundKbps, size));
        this.setSynReboundPps(this.devideUp(this.synReboundPps, size));
        this.setSynAckReboundPps(this.devideUp(this.synAckReboundPps, size));
    }

    public long getAckPps() {
        return this.ackPps;
    }

    public long getCurConPps() {
        return this.curConPps;
    }

    public long getFinRstPps() {
        return this.finRstPps;
    }

    public long getIncreaseConPps() {
        return this.increaseConPps;
    }

    public long getSpecialKbps() {
        return this.specialKbps;
    }

    public long getSpecialPps() {
        return this.specialPps;
    }

    public long getSynAckPps() {
        return this.synAckPps;
    }

    public long getSynPps() {
        return this.synPps;
    }

    @Override
    public long getTotalKbps() {
        return this.totalKbps;
    }

    @Override
    public long getTotalPps() {
        return this.totalPps;
    }

    @Override
    public boolean isLess(Event t) {
        if (t instanceof TcpBizFlowEvent) {
            TcpBizFlowEvent event = (TcpBizFlowEvent)t;
            Boolean totalPpsKbps = this.getTotalPps() < event.getTotalPps() || this.getTotalKbps() < event.getTotalKbps() || this.getSynPps() < event.getSynPps() || this.getSynAckPps() < event.getSynAckPps() || this.getAckPps() < event.getAckPps();
            Boolean finPpsKbps = this.getFinRstPps() < event.getFinRstPps() || this.getCurConPps() < event.getCurConPps() || this.getIncreaseConPps() < event.getIncreaseConPps() || this.getSpecialPps() < event.getSpecialPps() || this.getSpecialKbps() < event.getSpecialKbps();
            return totalPpsKbps != false || finPpsKbps != false;
        }
        return false;
    }

    @Override
    public void max(Event e) {
        if (null != e && e instanceof TcpBizFlowEvent) {
            TcpBizFlowEvent event = (TcpBizFlowEvent)e;
            this.setTotalPps(this.getTotalPps() > event.getTotalPps() ? this.getTotalPps() : event.getTotalPps());
            this.setTotalKbps(this.getTotalKbps() > event.getTotalKbps() ? this.getTotalKbps() : event.getTotalKbps());
            this.setSynPps(this.getSynPps() > event.getSynPps() ? this.getSynPps() : event.getSynPps());
            this.setSynAckPps(this.getSynAckPps() > event.getSynAckPps() ? this.getSynAckPps() : event.getSynAckPps());
            this.setAckPps(this.getAckPps() > event.getAckPps() ? this.getAckPps() : event.getAckPps());
            this.setFinRstPps(this.getFinRstPps() > event.getFinRstPps() ? this.getFinRstPps() : event.getFinRstPps());
            this.setCurConPps(this.getCurConPps() > event.getCurConPps() ? this.getCurConPps() : event.getCurConPps());
            this.setIncreaseConPps(this.getIncreaseConPps() > event.getIncreaseConPps() ? this.getIncreaseConPps() : event.getIncreaseConPps());
            this.setSpecialPps(this.getSpecialPps() > event.getSpecialPps() ? this.getSpecialPps() : event.getSpecialPps());
            this.setSpecialKbps(this.getSpecialKbps() > event.getSpecialKbps() ? this.getSpecialKbps() : event.getSpecialKbps());
            this.setTotalReboundPps(this.totalReboundPps > event.totalReboundPps ? this.totalReboundPps : event.totalReboundPps);
            this.setTotalReboundKbps(this.totalReboundKbps > event.totalReboundKbps ? this.totalReboundKbps : event.totalReboundKbps);
            this.setSynReboundPps(this.synReboundPps > event.synReboundPps ? this.synReboundPps : event.synReboundPps);
            this.setSynAckReboundPps(this.synAckReboundPps > event.synAckReboundPps ? this.synAckReboundPps : event.synAckReboundPps);
        }
    }

    protected void merge(Event e) {
        TcpBizFlowEvent event = (TcpBizFlowEvent)e;
        this.setTotalPps(this.totalPps + event.getTotalPps());
        this.setTotalKbps(this.totalKbps + event.getTotalKbps());
        this.setSynPps(this.synPps + event.getSynPps());
        this.setSynAckPps(this.synAckPps + event.getSynAckPps());
        this.setAckPps(this.ackPps + event.getAckPps());
        this.setFinRstPps(this.finRstPps + event.getFinRstPps());
        this.setCurConPps(this.curConPps + event.getCurConPps());
        this.setIncreaseConPps(this.increaseConPps + event.getIncreaseConPps());
        this.setSpecialPps(this.specialPps + event.getSpecialPps());
        this.setSpecialKbps(this.specialKbps + event.getSpecialKbps());
        this.setTotalReboundPps(this.totalReboundPps + event.totalReboundPps);
        this.setTotalReboundKbps(this.totalReboundKbps + event.totalReboundKbps);
        this.setSynReboundPps(this.synReboundPps + event.synReboundPps);
        this.setSynAckReboundPps(this.synAckReboundPps + event.synAckReboundPps);
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            this.merge(event);
        }
    }

    public void setAckPps(long ackPps) {
        this.ackPps = ackPps;
    }

    public void setCurConPps(long curConPps) {
        this.curConPps = curConPps;
    }

    @Override
    public void setDropFlow(boolean isDropFlow) {
        super.setDropFlow(isDropFlow);
        this.type.setDrop(isDropFlow);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public void setFinRstPps(long finRstPps) {
        this.finRstPps = finRstPps;
    }

    public void setIncreaseConPps(long increaseConPps) {
        this.increaseConPps = increaseConPps;
    }

    public void setSpecialKbps(long specialKbps) {
        this.specialKbps = specialKbps;
    }

    public void setSpecialPps(long specialPps) {
        this.specialPps = specialPps;
    }

    public void setSynAckPps(long synAckPps) {
        this.synAckPps = synAckPps;
    }

    public void setSynPps(long synPps) {
        this.synPps = synPps;
    }

    public void setTotalKbps(long totalKbps) {
        this.totalKbps = totalKbps;
    }

    public void setTotalPps(long totalPps) {
        this.totalPps = totalPps;
    }

    @Override
    public boolean isValid() {
        return this.totalPps != 0L || this.totalKbps != 0L;
    }

    public long getTotalReboundPps() {
        return this.totalReboundPps;
    }

    public void setTotalReboundPps(long totalReboundPps) {
        this.totalReboundPps = totalReboundPps;
    }

    public long getTotalReboundKbps() {
        return this.totalReboundKbps;
    }

    public void setTotalReboundKbps(long totalReboundKbps) {
        this.totalReboundKbps = totalReboundKbps;
    }

    public long getSynReboundPps() {
        return this.synReboundPps;
    }

    public void setSynReboundPps(long synReboundPps) {
        this.synReboundPps = synReboundPps;
    }

    public long getSynAckReboundPps() {
        return this.synAckReboundPps;
    }

    public void setSynAckReboundPps(long synAckReboundPps) {
        this.synAckReboundPps = synAckReboundPps;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("is dorp flow: ", this.isIsDropFlow()).append("is hour event: ", this.isIsHourEvent()).append("is max event: ", this.isIsMaxEvent()).append("totalPps: ", this.totalPps).append("totalKbps: ", this.totalKbps).append("synPps: ", this.synPps).append("synAckPps: ", this.synAckPps).append("ackPps: ", this.ackPps).append("finRstPps: ", this.finRstPps).append("increaseConPps: ", this.increaseConPps).append("curConPps: ", this.curConPps).append("specialPps: ", this.specialPps).append("totalReboundPps: ", this.totalReboundPps).append("totalReboundKbps: ", this.totalReboundKbps).append("synReboundPps: ", this.synReboundPps).append("synAckReboundPps: ", this.synAckReboundPps).toString();
    }

    public void toXmlLoTime(Element element) {
        element.addAttribute(TIME, EventUtil.getTimeStamp(this.getLogTime()));
    }

    private void toXmlType(Element element) {
        element.addAttribute(TYPE, TYPE_VALUE);
    }

    public void toXmlEntity(Element element) {
        element.addAttribute(BIZ_ID, this.getIdentifier().getBizId() + "");
        element.addAttribute(IS_DROP, String.valueOf(this.isIsDropFlow()));
        element.addAttribute(TOTAL_PPS, this.getTotalPps() + "");
        element.addAttribute(TOTAL_KBPS, this.getTotalKbps() + "");
        element.addAttribute(SYN_PPS, this.getSynPps() + "");
        element.addAttribute(SYN_ACK_PPS, this.getSynAckPps() + "");
        element.addAttribute(ACK_PPS, this.getAckPps() + "");
        element.addAttribute(FINRST_PPS, this.getFinRstPps() + "");
        element.addAttribute(INCREASE_CON_PPS, this.getIncreaseConPps() + "");
        element.addAttribute(CUR_CON_PPS, this.getCurConPps() + "");
        element.addAttribute(SPECIAL_PPS, this.getSpecialPps() + "");
        element.addAttribute(SPECIAL_KBPS, this.getSpecialKbps() + "");
    }

    @Override
    public void toXml(Element element) {
        this.toXmlLoTime(element);
        this.toXmlType(element);
        this.toXmlEntity(element);
    }

    @Override
    public List<String> getSysLogInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("log_type=tcp_biz");
        info.addAll(this.getSysLogEntry());
        return info;
    }

    public List<String> getSysLogEntry() {
        ArrayList<String> info = new ArrayList<String>();
        info.addAll(super.getSysLogInfo());
        info.add("is_drop=" + this.isIsDropFlow());
        info.add("total_pps=" + this.totalPps);
        info.add("total_kbps=" + this.totalKbps);
        info.add("syn_pps=" + this.synPps);
        info.add("syn_ack_pps=" + this.synAckPps);
        info.add("ack_pps=" + this.ackPps);
        info.add("finrst_pps=" + this.finRstPps);
        info.add("increase_con=" + this.increaseConPps);
        info.add("cur_con=" + this.curConPps);
        info.add("special_pps=" + this.specialPps);
        info.add("special_kbps=" + this.specialKbps);
        return info;
    }

    @Override
    public long getCurrConn() {
        return this.curConPps;
    }

    @Override
    public long getNewConn() {
        return this.increaseConPps;
    }

    @Override
    public boolean isFlowOverMax() {
        int aticFlowMaxNum = CommonUtil.getAticFlowMaxNum();
        Boolean totalPpsKbps = this.totalPps > (long)aticFlowMaxNum || this.totalKbps > (long)aticFlowMaxNum || this.synPps > (long)aticFlowMaxNum || this.synAckPps > (long)aticFlowMaxNum || this.ackPps > (long)aticFlowMaxNum;
        Boolean finPpsKbp = this.finRstPps > (long)aticFlowMaxNum || this.curConPps > (long)aticFlowMaxNum || this.increaseConPps > (long)aticFlowMaxNum || this.specialPps > (long)aticFlowMaxNum || this.specialKbps > (long)aticFlowMaxNum;
        Boolean reboundPpsKbp = this.totalReboundPps > (long)aticFlowMaxNum || this.totalReboundKbps > (long)aticFlowMaxNum || this.synReboundPps > (long)aticFlowMaxNum || this.synAckReboundPps > (long)aticFlowMaxNum;
        return totalPpsKbps != false || finPpsKbp != false || reboundPpsKbp != false;
    }

    @Override
    public TcpBizFlowEvent getCopyEvent() {
        TcpBizFlowEvent copy = (TcpBizFlowEvent)super.getCopyEvent();
        return copy;
    }

    @Override
    public TcpBizFlowEvent getFlowCopyEvent() {
        TcpBizFlowEvent copy = new TcpBizFlowEvent(this.getIdentifierCopy());
        copy.setDropFlow(this.isIsDropFlow());
        copy.setMaxEvent(this.isIsMaxEvent());
        copy.setHourEvent(this.isIsHourEvent());
        copy.setNeedSum(this.isNeedSum());
        copy.merge(this);
        return copy;
    }

    private static class TcpBizFlowType
    implements Type {
        private String clazzName;
        private boolean isDrop;

        private TcpBizFlowType() {
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public void setClazzName(String clazzName) {
            this.clazzName = clazzName;
        }

        public boolean isIsDrop() {
            return this.isDrop;
        }

        public void setDrop(boolean isDrops) {
            this.isDrop = isDrops;
        }

        public boolean equals(Object o) {
            if (o instanceof TcpBizFlowType) {
                TcpBizFlowType type = (TcpBizFlowType)o;
                return this.isDrop == type.isIsDrop() && this.clazzName.equals(type.getClazzName());
            }
            return false;
        }

        public int hashCode() {
            return this.isDrop ? 0 : 1 + this.clazzName.hashCode();
        }
    }
}

