/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.FirstPageEvent;
import com.hs.atic.collector.entity.event.xml.ToXml;
import com.hs.atic.collector.util.EventUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dom4j.Element;

public class UdpBizFlowEvent
extends Event
implements ToXml,
FirstPageEvent {
    private static final String TIME = "LOG_TIME";
    private static final String TOTALPPS = "TOTAL_PPS";
    private static final String TOTALKBPS = "TOTAL_KBPS";
    private static final String INCREASE_CON_PPS = "INCREASE_CON";
    private static final String CUR_CON_PPS = "CUR_CON";
    private static final String SPECIAL_PPS = "SPECIAL_PPS";
    private static final String SPECIAL_KBPS = "SPECIAL_KBPS";
    private static final String TYPE = "TYPE";
    private static final String TYPE_VALUE = "UDP";
    private static final String BIZ_ID = "BIZ_ID";
    private static final String IS_DROP = "IS_DROP";
    private UdpBizFlowType type = new UdpBizFlowType();
    private long totalPps;
    private long totalKbps;
    private long totalReboundPps;
    private long totalReboundKbps;
    private long increaseConPps;
    private long curConPps;
    private long specialPps;
    private long specialKbps;

    public UdpBizFlowEvent(EventIdentifier identifer) {
        super(identifer);
        this.type.setClazzName(this.getClass().getName());
    }

    @Override
    public void average(int size) {
        this.setTotalPps(this.devideUp(this.totalPps, size));
        this.setTotalKbps(this.devideUp(this.totalKbps, size));
        this.setIncreaseConPps(this.devideUp(this.increaseConPps, size));
        this.setCurConPps(this.devideUp(this.curConPps, size));
        this.setSpecialPps(this.devideUp(this.specialPps, size));
        this.setSpecialKbps(this.devideUp(this.specialKbps, size));
        this.setTotalReboundPps(this.devideUp(this.totalReboundPps, size));
        this.setTotalReboundKbps(this.devideUp(this.totalReboundKbps, size));
    }

    public long getCurConPps() {
        return this.curConPps;
    }

    public long getIncreaseConPps() {
        return this.increaseConPps;
    }

    public long getSpecialKbps() {
        return this.specialKbps;
    }

    public long getSpecialPps() {
        return this.specialPps;
    }

    @Override
    public long getTotalKbps() {
        return this.totalKbps;
    }

    @Override
    public long getTotalPps() {
        return this.totalPps;
    }

    @Override
    public boolean isLess(Event t) {
        if (t instanceof UdpBizFlowEvent) {
            UdpBizFlowEvent event = (UdpBizFlowEvent)t;
            return this.getTotalPps() < event.getTotalPps() || this.getTotalKbps() < event.getTotalKbps() || this.getIncreaseConPps() < event.getIncreaseConPps() || this.getCurConPps() < event.getCurConPps() || this.getSpecialPps() < event.getSpecialPps() || this.getSpecialKbps() < event.getSpecialKbps();
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.totalPps != 0L || this.totalKbps != 0L;
    }

    @Override
    public void max(Event e) {
        if (null != e && e instanceof UdpBizFlowEvent) {
            UdpBizFlowEvent event = (UdpBizFlowEvent)e;
            this.setTotalPps(this.getTotalPps() > event.getTotalPps() ? this.getTotalPps() : event.getTotalPps());
            this.setTotalKbps(this.getTotalKbps() > event.getTotalKbps() ? this.getTotalKbps() : event.getTotalKbps());
            this.setIncreaseConPps(this.getIncreaseConPps() > event.getIncreaseConPps() ? this.getIncreaseConPps() : event.getIncreaseConPps());
            this.setCurConPps(this.getCurConPps() > event.getCurConPps() ? this.getCurConPps() : event.getCurConPps());
            this.setSpecialPps(this.getSpecialPps() > event.getSpecialPps() ? this.getSpecialPps() : event.getSpecialPps());
            this.setSpecialKbps(this.getSpecialKbps() > event.getSpecialKbps() ? this.getSpecialKbps() : event.getSpecialKbps());
            this.setTotalReboundPps(this.totalReboundPps > event.totalReboundPps ? this.totalReboundPps : event.totalReboundPps);
            this.setTotalReboundKbps(this.totalReboundKbps > event.totalReboundKbps ? this.totalReboundKbps : event.totalReboundKbps);
        }
    }

    protected void merge(Event e) {
        UdpBizFlowEvent event = (UdpBizFlowEvent)e;
        this.setTotalPps(this.totalPps + event.getTotalPps());
        this.setTotalKbps(this.totalKbps + event.getTotalKbps());
        this.setCurConPps(this.curConPps + event.getCurConPps());
        this.setIncreaseConPps(this.increaseConPps + event.getIncreaseConPps());
        this.setSpecialPps(this.specialPps + event.getSpecialPps());
        this.setSpecialKbps(this.specialKbps + event.getSpecialKbps());
        this.setTotalReboundPps(this.totalReboundPps + event.totalReboundPps);
        this.setTotalReboundKbps(this.totalReboundKbps + event.totalReboundKbps);
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            this.merge(event);
        }
    }

    public void setCurConPps(long curConPps) {
        this.curConPps = curConPps;
    }

    @Override
    public void setDropFlow(boolean isDropFlow) {
        super.setDropFlow(isDropFlow);
        this.type.setDrop(isDropFlow);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public void setIncreaseConPps(long increaseConPps) {
        this.increaseConPps = increaseConPps;
    }

    public void setSpecialKbps(long specialKbps) {
        this.specialKbps = specialKbps;
    }

    public void setSpecialPps(long specialPps) {
        this.specialPps = specialPps;
    }

    public void setTotalKbps(long totalKbps) {
        this.totalKbps = totalKbps;
    }

    public void setTotalPps(long totalPps) {
        this.totalPps = totalPps;
    }

    public long getTotalReboundPps() {
        return this.totalReboundPps;
    }

    public void setTotalReboundPps(long totalReboundPps) {
        this.totalReboundPps = totalReboundPps;
    }

    public long getTotalReboundKbps() {
        return this.totalReboundKbps;
    }

    public void setTotalReboundKbps(long totalReboundKbps) {
        this.totalReboundKbps = totalReboundKbps;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("is Dorp Flow: ", this.isIsDropFlow()).append("is hour event: ", this.isIsHourEvent()).append("is max event: ", this.isIsMaxEvent()).append("totalPps: ", this.totalPps).append("totalKbps: ", this.totalKbps).append("increaseConPps: ", this.increaseConPps).append("curConPps: ", this.curConPps).append("specialPps: ", this.specialPps).append("specialKbps: ", this.specialKbps).append("totalReboundPps: ", this.totalReboundPps).append("totalReboundKbps: ", this.totalReboundKbps).toString();
    }

    public void toXmlLoTime(Element element) {
        element.addAttribute(TIME, EventUtil.getTimeStamp(this.getLogTime()));
    }

    private void toXmlType(Element element) {
        element.addAttribute(TYPE, TYPE_VALUE);
    }

    public void toXmlEntity(Element element) {
        element.addAttribute(BIZ_ID, this.getIdentifier().getBizId() + "");
        element.addAttribute(IS_DROP, String.valueOf(this.isIsDropFlow()));
        element.addAttribute(TOTALPPS, this.getTotalPps() + "");
        element.addAttribute(TOTALKBPS, this.getTotalKbps() + "");
        element.addAttribute(INCREASE_CON_PPS, this.getIncreaseConPps() + "");
        element.addAttribute(CUR_CON_PPS, this.getCurConPps() + "");
        element.addAttribute(SPECIAL_PPS, this.getSpecialPps() + "");
        element.addAttribute(SPECIAL_KBPS, this.getSpecialKbps() + "");
    }

    @Override
    public void toXml(Element element) {
        this.toXmlLoTime(element);
        this.toXmlType(element);
        this.toXmlEntity(element);
    }

    @Override
    public List<String> getSysLogInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("log_type=udp_biz");
        info.addAll(this.getSysLogEntry());
        return info;
    }

    public List<String> getSysLogEntry() {
        ArrayList<String> info = new ArrayList<String>();
        info.addAll(super.getSysLogInfo());
        info.add("is_drop=" + this.isIsDropFlow());
        info.add("total_pps=" + this.totalPps);
        info.add("total_kbps=" + this.totalKbps);
        info.add("increase_con=" + this.increaseConPps);
        info.add("cur_con=" + this.curConPps);
        info.add("special_pps=" + this.specialPps);
        info.add("special_kbps=" + this.specialKbps);
        return info;
    }

    @Override
    public long getCurrConn() {
        return this.curConPps;
    }

    @Override
    public long getNewConn() {
        return this.increaseConPps;
    }

    @Override
    public UdpBizFlowEvent getCopyEvent() {
        UdpBizFlowEvent copy = (UdpBizFlowEvent)super.getCopyEvent();
        return copy;
    }

    @Override
    public UdpBizFlowEvent getFlowCopyEvent() {
        UdpBizFlowEvent copy = new UdpBizFlowEvent(this.getIdentifierCopy());
        copy.setDropFlow(this.isIsDropFlow());
        copy.setMaxEvent(this.isIsMaxEvent());
        copy.setHourEvent(this.isIsHourEvent());
        copy.setNeedSum(this.isNeedSum());
        copy.merge(this);
        return copy;
    }

    private static class UdpBizFlowType
    implements Type {
        boolean isDrop;
        private String clazzName;

        private UdpBizFlowType() {
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public void setClazzName(String clazzName) {
            this.clazzName = clazzName;
        }

        public boolean isIsDrop() {
            return this.isDrop;
        }

        public void setDrop(boolean isDrops) {
            this.isDrop = isDrops;
        }

        public boolean equals(Object o) {
            if (o instanceof UdpBizFlowType) {
                UdpBizFlowType type = (UdpBizFlowType)o;
                return this.isDrop == type.isIsDrop() && this.clazzName.equals(type.getClazzName());
            }
            return false;
        }

        public int hashCode() {
            return this.isDrop ? 0 : 1;
        }
    }
}

