/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import com.hs.atic.collector.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dom4j.Element;

public class UdpDnsBizFlowEvent
extends UdpBizFlowEvent {
    private static final String REQUEST_PPS = "request_pps";
    private static final String REPLY_PPS = "reply_pps";
    private static final String DIS_SENDREPLY_PPS = "dis_sendreply_pps";
    private static final String A_REQUSET_PPS = "a_requset_pps";
    private static final String PTR_REQUSET_PPS = "ptr_requset_pps";
    private static final String NS_REQUSET_PPS = "ns_requset_pps";
    private static final String MX_REQUSET_PPS = "mx_requset_pps";
    private static final String TXT_REQUSET_PPS = "txt_requset_pps";
    private static final String CNNAME_REQUEST_PPS = "cnname_request_pps";
    private static final String SOA_REQUEST_PPS = "soa_request_pps";
    private static final String AAAA_REQUST_PPS = "aaaa_requst_pps";
    private static final String OTHER_REQUSET_PPS = "other_requset_pps";
    private static final String FRAG_PPS = "frag_pps";
    private static final String LARGE_PPS = "large_pps";
    private static final String ILEGAL_PPS = "ilegal_pps";
    private static final String TTL_DENIED_PPS = "ttl_denied_pps";
    private static final String TYPE = "type";
    private static final String TYPE_VALUE = "udp_dns";
    private long requestPps;
    private long replyPps;
    private long disSendReplyPps;
    private long aRequsetPps;
    private long ptrRequsetPps;
    private long nsRequsetPps;
    private long mxRequsetPps;
    private long txtRequsetPps;
    private long cnnameRequestPps;
    private long soaRequestPps;
    private long aaaaRequstPps;
    private long otherRequsetPps;
    private long fragPps;
    private long largePps;
    private long iLegalPps;
    private long ttlDeniedPps;
    private long dnsQueryReboundPps;
    private long dnsReplyReboundPps;

    public UdpDnsBizFlowEvent(EventIdentifier identifer) {
        super(identifer);
    }

    @Override
    public void average(int size) {
        super.average(size);
        this.setRequestPps(this.devideUp(this.requestPps, size));
        this.setReplyPps(this.devideUp(this.replyPps, size));
        this.setDisSendReplyPps(this.devideUp(this.disSendReplyPps, size));
        this.setaRequsetPps(this.devideUp(this.aRequsetPps, size));
        this.setPtrRequsetPps(this.devideUp(this.ptrRequsetPps, size));
        this.setNsRequsetPps(this.devideUp(this.nsRequsetPps, size));
        this.setMxRequsetPps(this.devideUp(this.mxRequsetPps, size));
        this.setTxtRequsetPps(this.devideUp(this.txtRequsetPps, size));
        this.setCnnameRequestPps(this.devideUp(this.cnnameRequestPps, size));
        this.setSoaRequestPps(this.devideUp(this.soaRequestPps, size));
        this.setAaaaRequstPps(this.devideUp(this.aaaaRequstPps, size));
        this.setOtherRequsetPps(this.devideUp(this.otherRequsetPps, size));
        this.setFragPps(this.devideUp(this.fragPps, size));
        this.setLargePps(this.devideUp(this.largePps, size));
        this.setiLegalPps(this.devideUp(this.iLegalPps, size));
        this.setTtlDeniedPps(this.devideUp(this.ttlDeniedPps, size));
        this.setDnsQueryReboundPps(this.devideUp(this.dnsQueryReboundPps, size));
        this.setDnsReplyReboundPps(this.devideUp(this.dnsReplyReboundPps, size));
    }

    @Override
    public boolean isFlowOverMax() {
        int aticFlowMaxNum = CommonUtil.getAticFlowMaxNum();
        Boolean flow = super.isFlowOverMax() || this.requestPps > (long)aticFlowMaxNum || this.replyPps > (long)aticFlowMaxNum || this.disSendReplyPps > (long)aticFlowMaxNum || this.aRequsetPps > (long)aticFlowMaxNum || this.ptrRequsetPps > (long)aticFlowMaxNum;
        Boolean ns = this.nsRequsetPps > (long)aticFlowMaxNum || this.mxRequsetPps > (long)aticFlowMaxNum || this.txtRequsetPps > (long)aticFlowMaxNum || this.cnnameRequestPps > (long)aticFlowMaxNum || this.soaRequestPps > (long)aticFlowMaxNum;
        Boolean aaa = this.aaaaRequstPps > (long)aticFlowMaxNum || this.otherRequsetPps > (long)aticFlowMaxNum || this.fragPps > (long)aticFlowMaxNum || this.largePps > (long)aticFlowMaxNum || this.iLegalPps > (long)aticFlowMaxNum;
        Boolean ttl = this.ttlDeniedPps > (long)aticFlowMaxNum || this.dnsQueryReboundPps > (long)aticFlowMaxNum || this.dnsReplyReboundPps > (long)aticFlowMaxNum;
        return flow != false || ns != false || aaa != false || ttl != false;
    }

    public long getAaaaRequstPps() {
        return this.aaaaRequstPps;
    }

    public long getaRequsetPps() {
        return this.aRequsetPps;
    }

    public long getCnnameRequestPps() {
        return this.cnnameRequestPps;
    }

    public long getDisSendReplyPps() {
        return this.disSendReplyPps;
    }

    public long getFragPps() {
        return this.fragPps;
    }

    public long getiLegalPps() {
        return this.iLegalPps;
    }

    public long getLargePps() {
        return this.largePps;
    }

    public long getMxRequsetPps() {
        return this.mxRequsetPps;
    }

    public long getNsRequsetPps() {
        return this.nsRequsetPps;
    }

    public long getOtherRequsetPps() {
        return this.otherRequsetPps;
    }

    public long getPtrRequsetPps() {
        return this.ptrRequsetPps;
    }

    public long getReplyPps() {
        return this.replyPps;
    }

    public long getRequestPps() {
        return this.requestPps;
    }

    public long getSoaRequestPps() {
        return this.soaRequestPps;
    }

    public long getTtlDeniedPps() {
        return this.ttlDeniedPps;
    }

    public long getTxtRequsetPps() {
        return this.txtRequsetPps;
    }

    @Override
    public void max(Event e) {
        if (null != e && e instanceof UdpDnsBizFlowEvent) {
            UdpDnsBizFlowEvent event = (UdpDnsBizFlowEvent)e;
            super.max(event);
            this.setRequestPps(this.getRequestPps() > event.getRequestPps() ? this.getRequestPps() : event.getRequestPps());
            this.setReplyPps(this.getReplyPps() > event.getReplyPps() ? this.getReplyPps() : event.getReplyPps());
            this.setDisSendReplyPps(this.getDisSendReplyPps() > event.getDisSendReplyPps() ? this.getDisSendReplyPps() : event.getDisSendReplyPps());
            this.setaRequsetPps(this.getaRequsetPps() > event.getaRequsetPps() ? this.getaRequsetPps() : event.getaRequsetPps());
            this.setPtrRequsetPps(this.getPtrRequsetPps() > event.getPtrRequsetPps() ? this.getPtrRequsetPps() : event.getPtrRequsetPps());
            this.setNsRequsetPps(this.getNsRequsetPps() > event.getNsRequsetPps() ? this.getNsRequsetPps() : event.getNsRequsetPps());
            this.setMxRequsetPps(this.getMxRequsetPps() > event.getMxRequsetPps() ? this.getMxRequsetPps() : event.getMxRequsetPps());
            this.setTxtRequsetPps(this.getTxtRequsetPps() > event.getTxtRequsetPps() ? this.getTxtRequsetPps() : event.getTxtRequsetPps());
            this.setCnnameRequestPps(this.getCnnameRequestPps() > event.getCnnameRequestPps() ? this.getCnnameRequestPps() : event.getCnnameRequestPps());
            this.setSoaRequestPps(this.getSoaRequestPps() > event.getSoaRequestPps() ? this.getSoaRequestPps() : event.getSoaRequestPps());
            this.setAaaaRequstPps(this.getAaaaRequstPps() > event.getAaaaRequstPps() ? this.getAaaaRequstPps() : event.getAaaaRequstPps());
            this.setFragPps(this.getFragPps() > event.getFragPps() ? this.getFragPps() : event.getFragPps());
            this.setLargePps(this.getLargePps() > event.getLargePps() ? this.getLargePps() : event.getLargePps());
            this.setiLegalPps(this.getiLegalPps() > event.getiLegalPps() ? this.getiLegalPps() : event.getiLegalPps());
            this.setTtlDeniedPps(this.getTtlDeniedPps() > event.getTtlDeniedPps() ? this.getTtlDeniedPps() : event.getTtlDeniedPps());
            this.setDnsQueryReboundPps(this.dnsQueryReboundPps > event.dnsQueryReboundPps ? this.dnsQueryReboundPps : event.dnsQueryReboundPps);
            this.setDnsReplyReboundPps(this.dnsReplyReboundPps > event.dnsReplyReboundPps ? this.dnsReplyReboundPps : event.dnsReplyReboundPps);
        }
    }

    @Override
    public boolean isLess(Event t) {
        if (t instanceof UdpDnsBizFlowEvent) {
            UdpDnsBizFlowEvent event = (UdpDnsBizFlowEvent)t;
            Boolean less = super.isLess(t) || this.getRequestPps() < event.getRequestPps() || this.getReplyPps() < event.getReplyPps() || this.getDisSendReplyPps() < event.getDisSendReplyPps() || this.getaRequsetPps() < event.getaRequsetPps();
            Boolean ptr = this.getPtrRequsetPps() < event.getPtrRequsetPps() || this.getNsRequsetPps() < event.getNsRequsetPps() || this.getMxRequsetPps() < event.getMxRequsetPps() || this.getTxtRequsetPps() < event.getTxtRequsetPps() || this.getCnnameRequestPps() < event.getCnnameRequestPps();
            Boolean soa = this.getSoaRequestPps() < event.getSoaRequestPps() || this.getAaaaRequstPps() < event.getAaaaRequstPps() || this.getFragPps() < event.getFragPps() || this.getLargePps() < event.getLargePps() || this.getiLegalPps() < event.getiLegalPps();
            return less != false || ptr != false || soa != false || this.getTtlDeniedPps() < event.getTtlDeniedPps();
        }
        return false;
    }

    @Override
    public void merge(Event e) {
        if (null != e && e instanceof UdpDnsBizFlowEvent) {
            UdpDnsBizFlowEvent event = (UdpDnsBizFlowEvent)e;
            super.merge(event);
            this.setRequestPps(this.getRequestPps() + event.getRequestPps());
            this.setReplyPps(this.getReplyPps() + event.getReplyPps());
            this.setDisSendReplyPps(this.getDisSendReplyPps() + event.getDisSendReplyPps());
            this.setaRequsetPps(this.getaRequsetPps() + event.getaRequsetPps());
            this.setPtrRequsetPps(this.getPtrRequsetPps() + event.getPtrRequsetPps());
            this.setNsRequsetPps(this.getNsRequsetPps() + event.getNsRequsetPps());
            this.setMxRequsetPps(this.getMxRequsetPps() + event.getMxRequsetPps());
            this.setTxtRequsetPps(this.getTxtRequsetPps() + event.getTxtRequsetPps());
            this.setCnnameRequestPps(this.getCnnameRequestPps() + event.getCnnameRequestPps());
            this.setSoaRequestPps(this.getSoaRequestPps() + event.getSoaRequestPps());
            this.setAaaaRequstPps(this.getAaaaRequstPps() + event.getAaaaRequstPps());
            this.setOtherRequsetPps(this.getOtherRequsetPps() + event.getOtherRequsetPps());
            this.setFragPps(this.getFragPps() + event.getFragPps());
            this.setLargePps(this.getLargePps() + event.getLargePps());
            this.setiLegalPps(this.getiLegalPps() + event.getiLegalPps());
            this.setTtlDeniedPps(this.getTtlDeniedPps() + event.getTtlDeniedPps());
            this.setDnsQueryReboundPps(this.dnsQueryReboundPps + event.dnsQueryReboundPps);
            this.setDnsReplyReboundPps(this.dnsReplyReboundPps + event.dnsReplyReboundPps);
        }
    }

    public void setAaaaRequstPps(long aaaaRequstPps) {
        this.aaaaRequstPps = aaaaRequstPps;
    }

    public void setaRequsetPps(long aRequsetPpss) {
        this.aRequsetPps = aRequsetPpss;
    }

    public void setCnnameRequestPps(long cnnameRequestPps) {
        this.cnnameRequestPps = cnnameRequestPps;
    }

    public void setDisSendReplyPps(long disSendReplyPps) {
        this.disSendReplyPps = disSendReplyPps;
    }

    public void setFragPps(long fragPps) {
        this.fragPps = fragPps;
    }

    public void setiLegalPps(long iLegalPpss) {
        this.iLegalPps = iLegalPpss;
    }

    public void setLargePps(long largePps) {
        this.largePps = largePps;
    }

    public void setMxRequsetPps(long mxRequsetPps) {
        this.mxRequsetPps = mxRequsetPps;
    }

    public void setNsRequsetPps(long nsRequsetPps) {
        this.nsRequsetPps = nsRequsetPps;
    }

    public void setOtherRequsetPps(long otherRequsetPps) {
        this.otherRequsetPps = otherRequsetPps;
    }

    public void setPtrRequsetPps(long ptrRequsetPps) {
        this.ptrRequsetPps = ptrRequsetPps;
    }

    public void setReplyPps(long replyPps) {
        this.replyPps = replyPps;
    }

    public void setRequestPps(long requestPps) {
        this.requestPps = requestPps;
    }

    public void setSoaRequestPps(long soaRequestPps) {
        this.soaRequestPps = soaRequestPps;
    }

    public void setTtlDeniedPps(long ttlDeniedPps) {
        this.ttlDeniedPps = ttlDeniedPps;
    }

    public void setTxtRequsetPps(long txtRequsetPps) {
        this.txtRequsetPps = txtRequsetPps;
    }

    public long getDnsQueryReboundPps() {
        return this.dnsQueryReboundPps;
    }

    public void setDnsQueryReboundPps(long dnsQueryReboundPps) {
        this.dnsQueryReboundPps = dnsQueryReboundPps;
    }

    public long getDnsReplyReboundPps() {
        return this.dnsReplyReboundPps;
    }

    public void setDnsReplyReboundPps(long dnsReplyReboundPps) {
        this.dnsReplyReboundPps = dnsReplyReboundPps;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("is Dorp Flow: ", this.isIsDropFlow()).append("is hour event: ", this.isIsHourEvent()).append("is max event: ", this.isIsMaxEvent()).append("requestPps: ", this.requestPps).append("replyPps: ", this.replyPps).append("disSendReplyPps", this.disSendReplyPps).append("aRequsetPps: ", this.aRequsetPps).append("ptrRequsetPps: ", this.ptrRequsetPps).append("nsRequsetPps: ", this.nsRequsetPps).append("mxRequsetPps: ", this.mxRequsetPps).append("txtRequsetPps: ", this.txtRequsetPps).append("cnnameRequestPps: ", this.cnnameRequestPps).append("soaRequestPps: ", this.soaRequestPps).append("aaaaRequstPps: ", this.aaaaRequstPps).append("otherRequsetPps: ", this.otherRequsetPps).append("fragPps: ", this.fragPps).append("largePps: ", this.largePps).append("iLegalPps: ", this.iLegalPps).append("ttlDeniedPps: ", this.ttlDeniedPps).append("dnsQueryReboundPps: ", this.dnsQueryReboundPps).append("dnsReplyReboundPps: ", this.dnsReplyReboundPps).toString();
    }

    @Override
    public void toXml(Element element) {
        super.toXmlLoTime(element);
        element.addAttribute(TYPE, TYPE_VALUE);
        super.toXmlEntity(element);
        element.addAttribute(REQUEST_PPS, this.getRequestPps() + "");
        element.addAttribute(REPLY_PPS, this.getReplyPps() + "");
        element.addAttribute(DIS_SENDREPLY_PPS, this.getDisSendReplyPps() + "");
        element.addAttribute(A_REQUSET_PPS, this.getaRequsetPps() + "");
        element.addAttribute(PTR_REQUSET_PPS, this.getPtrRequsetPps() + "");
        element.addAttribute(NS_REQUSET_PPS, this.getNsRequsetPps() + "");
        element.addAttribute(MX_REQUSET_PPS, this.getMxRequsetPps() + "");
        element.addAttribute(TXT_REQUSET_PPS, this.getTxtRequsetPps() + "");
        element.addAttribute(CNNAME_REQUEST_PPS, this.getCnnameRequestPps() + "");
        element.addAttribute(SOA_REQUEST_PPS, this.getSoaRequestPps() + "");
        element.addAttribute(AAAA_REQUST_PPS, this.getAaaaRequstPps() + "");
        element.addAttribute(OTHER_REQUSET_PPS, this.getOtherRequsetPps() + "");
        element.addAttribute(FRAG_PPS, this.getFragPps() + "");
        element.addAttribute(LARGE_PPS, this.getLargePps() + "");
        element.addAttribute(ILEGAL_PPS, this.getiLegalPps() + "");
        element.addAttribute(TTL_DENIED_PPS, this.getTtlDeniedPps() + "");
    }

    @Override
    public List<String> getSysLogInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("log_type=udp_dns_biz");
        info.addAll(this.getSysLogEntry());
        info.add("request_pps=" + this.requestPps);
        info.add("reply_pps=" + this.replyPps);
        info.add("dis_sendreply_pps=" + this.disSendReplyPps);
        info.add("a_requset_pps=" + this.aRequsetPps);
        info.add("ptr_requset_pps=" + this.ptrRequsetPps);
        info.add("ns_requset_pps=" + this.nsRequsetPps);
        info.add("mx_requset_pps=" + this.mxRequsetPps);
        info.add("txt_requset_pps=" + this.txtRequsetPps);
        info.add("cnname_request_pps=" + this.cnnameRequestPps);
        info.add("soa_request_pps=" + this.soaRequestPps);
        info.add("aaaa_requst_pps=" + this.aaaaRequstPps);
        info.add("other_requset_pps=" + this.otherRequsetPps);
        info.add("frag_pps=" + this.fragPps);
        info.add("large_pps=" + this.largePps);
        info.add("ilegal_pps=" + this.iLegalPps);
        info.add("ttl_denied_pps=" + this.ttlDeniedPps);
        return info;
    }

    @Override
    public UdpDnsBizFlowEvent getCopyEvent() {
        UdpDnsBizFlowEvent copy = (UdpDnsBizFlowEvent)super.getCopyEvent();
        return copy;
    }

    @Override
    public UdpDnsBizFlowEvent getFlowCopyEvent() {
        UdpDnsBizFlowEvent copy = new UdpDnsBizFlowEvent(this.getIdentifierCopy());
        copy.setDropFlow(this.isIsDropFlow());
        copy.setMaxEvent(this.isIsMaxEvent());
        copy.setHourEvent(this.isIsHourEvent());
        copy.setNeedSum(this.isNeedSum());
        copy.merge(this);
        return copy;
    }
}

