/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.SumEvent;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class UdpDnsUserDefTypeEvent
extends Event
implements SumEvent<UdpDnsUserDefTypeEvent> {
    private UdpDnsUserDefType type = new UdpDnsUserDefType();
    private long dnsCode;
    private long dnsValue;
    private long dnsMaxValue;
    private long dnsDropValue;
    private long dnsDropMaxValue;

    public UdpDnsUserDefTypeEvent(EventIdentifier identifer) {
        super(identifer);
        this.type.setClazzName(this.getClass().getName());
    }

    @Override
    public UdpDnsUserDefType getType() {
        return this.type;
    }

    @Override
    public void average(int number) {
        this.setDnsValue(this.devideUp(this.dnsValue, number));
        this.setDnsDropValue(this.devideUp(this.dnsDropValue, number));
    }

    public long getDnsCode() {
        return this.dnsCode;
    }

    public long getDnsDropMaxValue() {
        return this.dnsDropMaxValue;
    }

    public long getDnsDropValue() {
        return this.dnsDropValue;
    }

    public long getDnsMaxValue() {
        return this.dnsMaxValue;
    }

    public long getDnsValue() {
        return this.dnsValue;
    }

    protected void merge(Event e) {
        UdpDnsUserDefTypeEvent event = (UdpDnsUserDefTypeEvent)e;
        this.setDnsValue(this.dnsValue + event.getDnsValue());
        this.setDnsDropValue(this.dnsDropValue + event.getDnsDropValue());
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            this.merge(event);
        }
    }

    public void setDnsCode(long dnsCode) {
        this.dnsCode = dnsCode;
        this.type.setDnsCode(dnsCode);
    }

    public void setDnsDropMaxValue(long dnsDropMaxValue) {
        this.dnsDropMaxValue = dnsDropMaxValue;
    }

    public void setDnsDropValue(long dnsDropValue) {
        this.dnsDropValue = dnsDropValue;
    }

    public void setDnsMaxValue(long dnsMaxValue) {
        this.dnsMaxValue = dnsMaxValue;
    }

    public void setDnsValue(long dnsValue) {
        this.dnsValue = dnsValue;
    }

    @Override
    public void sumElement(List<UdpDnsUserDefTypeEvent> events) {
        for (UdpDnsUserDefTypeEvent e : events) {
            this.setDnsValue(this.getDnsValue() + e.getDnsValue());
            this.setDnsDropValue(this.getDnsDropValue() + e.getDnsDropValue());
            this.setDnsMaxValue(this.getDnsMaxValue() > e.getDnsValue() ? this.getDnsMaxValue() : e.getDnsValue());
            this.setDnsDropMaxValue(this.getDnsDropMaxValue() > e.getDnsDropValue() ? this.getDnsDropMaxValue() : e.getDnsDropValue());
        }
    }

    @Override
    public UdpDnsUserDefTypeEvent getCopyEvent() {
        UdpDnsUserDefTypeEvent copy = (UdpDnsUserDefTypeEvent)super.getCopyEvent();
        copy.setDnsCode(this.getDnsCode());
        return copy;
    }

    @Override
    public UdpDnsUserDefTypeEvent getFlowCopyEvent() {
        UdpDnsUserDefTypeEvent copy = new UdpDnsUserDefTypeEvent(this.getIdentifierCopy());
        copy.setDropFlow(this.isIsDropFlow());
        copy.setMaxEvent(this.isIsMaxEvent());
        copy.setHourEvent(this.isIsHourEvent());
        copy.setNeedSum(this.isNeedSum());
        copy.merge(this);
        return copy;
    }

    @Override
    public String getEventTypeString() {
        return this.getClass().getName() + this.dnsCode;
    }

    @Override
    public boolean isValid() {
        return this.dnsDropValue != 0L || this.dnsValue != 0L;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("is hour event: ", this.isIsHourEvent()).append("is max event: ", this.isIsMaxEvent()).append("dnsCode: ", this.dnsCode).append("dnsValue: ", this.dnsValue).append("dnsMaxValue: ", this.dnsMaxValue).append("dnsDropValue: ", this.dnsDropValue).append("dnsDropMaxValue: ", this.dnsDropMaxValue).toString();
    }

    private static class UdpDnsUserDefType
    implements Type {
        private String clazzName;
        private long dnsCode;

        private UdpDnsUserDefType() {
        }

        public boolean equals(Object o) {
            if (o instanceof UdpDnsUserDefType) {
                UdpDnsUserDefType type = (UdpDnsUserDefType)o;
                return this.dnsCode == type.getDnsCode() && this.clazzName.equals(type.getClazzName());
            }
            return false;
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public long getDnsCode() {
            return this.dnsCode;
        }

        public int hashCode() {
            return (int)this.dnsCode * 17 + 13;
        }

        public void setClazzName(String clazzName) {
            this.clazzName = clazzName;
        }

        public void setDnsCode(long dnsCode) {
            this.dnsCode = dnsCode;
        }
    }
}

