/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event.xml;

import com.hs.atic.collector.biz.event.process.DeviceType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.xml.ToXml;
import com.hs.atic.collector.entity.event.xml.XmlZoneIpBlock;
import com.hs.atic.collector.util.EventUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class XmlDeviceBlock
implements ToXml {
    private static final String DEVICEIP_ATTRIBUTE_IP = "ip";
    private static final String ZONEIP_TAG = "IP";
    private static final String DEVICEIP_ATTRIBUTE_TYPE = "type";
    private static final String DETECT_DEVICE = "DETECT";
    private static final String CLEAN_DEVICE = "CLEAN";
    private static final int CLEAN_DEVICE_FLAG = 0;
    private String deviceIp;
    private int deviceType;
    private List<XmlZoneIpBlock> suits = new ArrayList<XmlZoneIpBlock>();

    public XmlDeviceBlock(DeviceType type, List<Event> value) {
        this.deviceIp = type.getTypeDeviceIp();
        this.deviceType = type.getDeviceType();
        Map<Type, List<Event>> events = EventUtil.groupEventsByZoneIpIgnoreTypeAndBiz(value);
        for (Map.Entry<Type, List<Event>> entry : events.entrySet()) {
            XmlZoneIpBlock block = new XmlZoneIpBlock(entry.getValue());
            if (!block.isValid()) continue;
            this.suits.add(block);
        }
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public boolean isValid() {
        return !this.suits.isEmpty();
    }

    @Override
    public void toXml(Element device) {
        device.addAttribute(DEVICEIP_ATTRIBUTE_IP, this.deviceIp);
        device.addAttribute(DEVICEIP_ATTRIBUTE_TYPE, this.deviceType == 0 ? CLEAN_DEVICE : DETECT_DEVICE);
        for (XmlZoneIpBlock block : this.suits) {
            Element zoneIp = device.addElement(ZONEIP_TAG);
            block.toXml(zoneIp);
        }
    }
}

