/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event.xml;

import com.hs.atic.collector.biz.event.process.DeviceType;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.xml.ToXml;
import com.hs.atic.collector.entity.event.xml.XmlDeviceBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class XmlZoneBlock
implements ToXml {
    public static final String DEVICE_TAG = "DEVICE";
    private static final String ID_ATTRIBUTE = "id";
    private long zoneId;
    private List<XmlDeviceBlock> suits = new ArrayList<XmlDeviceBlock>();

    public XmlZoneBlock(List<Event> events) {
        this.zoneId = events.get(0).getZoneId();
        Map<DeviceType, List<Event>> map = this.groupEventsByDeviceIp(events);
        for (Map.Entry<DeviceType, List<Event>> entry : map.entrySet()) {
            XmlDeviceBlock block = new XmlDeviceBlock(entry.getKey(), entry.getValue());
            if (!block.isValid()) continue;
            this.suits.add(block);
        }
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public boolean isValid() {
        return !this.suits.isEmpty();
    }

    @Override
    public void toXml(Element element) {
        element.addAttribute(ID_ATTRIBUTE, this.zoneId + "");
        for (XmlDeviceBlock block : this.suits) {
            Element device = element.addElement(DEVICE_TAG);
            block.toXml(device);
        }
    }

    private Map<DeviceType, List<Event>> groupEventsByDeviceIp(List<Event> events) {
        HashMap<DeviceType, List<Event>> map = new HashMap<DeviceType, List<Event>>();
        for (Event event : events) {
            DeviceType type = new DeviceType(event.getIdentifier());
            if (map.containsKey(type)) {
                ((List)map.get(type)).add(event);
                continue;
            }
            ArrayList<Event> list = new ArrayList<Event>();
            list.add(event);
            map.put(type, list);
        }
        return map;
    }
}

