/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.monitor;

import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.ParamCheckUtil;
import java.io.Serializable;

public class DeviceObj
implements Serializable {
    public static final int CLEAN_DEVICE = 0;
    public static final int DETECT_CLEAN_DEVICE = 3;
    public static final int DETECT_DEVICE = 1;
    public static final int ENCRYPT_TYPE_OLD_DEVICE = 0;
    public static final int ENCRYPT_TYPE_NEW_YES = 1;
    public static final int ENCRYPT_TYPE_NEW_NO = 2;
    private static final long serialVersionUID = -7493334255146522190L;
    private long moId;
    private String deviceIp;
    private String logIp;
    private int serviceType;
    private int deviceType;
    private String logPwd;
    private int encryptType;

    public static String getDeviceTypeDescriptor(int deviceType) {
        if (deviceType == 0) {
            return "CLEAN DEVICE";
        }
        if (deviceType == 1) {
            return "DETECT DEVICE";
        }
        return "DETECT CLEAN DEVICE";
    }

    public boolean equals(Object obj) {
        DeviceObj device;
        return obj instanceof DeviceObj && (device = (DeviceObj)obj).getDeviceIp().equals(this.deviceIp) && device.getServiceType() == this.serviceType;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public long getMoId() {
        return this.moId;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public int hashCode() {
        return 17 + 19 * this.deviceIp.hashCode() + 361 * this.serviceType;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    public void setMoId(long moId) {
        this.moId = moId;
    }

    public void setServiceType(int serviceType) {
        this.serviceType = serviceType;
    }

    public String getLogIp() {
        return this.logIp;
    }

    public void setLogIp(String logIp) {
        this.logIp = logIp;
    }

    public String getLogPwd() {
        return this.logPwd;
    }

    public void setLogPwd(String logPwd) {
        this.logPwd = logPwd;
    }

    public int getEncryptType() {
        return this.encryptType;
    }

    public void setEncryptType(int encryptType) {
        this.encryptType = encryptType;
    }

    public String toString() {
        return "DeviceObj [moId=" + this.moId + ", deviceIp=" + this.deviceIp + ", logIp=" + this.logIp + ", serviceType=" + this.serviceType + ", deviceType=" + this.deviceType + ", encryptType=" + this.encryptType + "]";
    }

    public boolean isValid() {
        if (!IpTransformer.isIpV4(this.deviceIp)) {
            return false;
        }
        if (null != this.logIp && !IpTransformer.isIpV4(this.logIp)) {
            return false;
        }
        if (!ParamCheckUtil.isValidStringNotNull(this.logPwd, 64)) {
            return false;
        }
        if (this.deviceType < 0 || this.deviceType > 9) {
            return false;
        }
        return this.encryptType >= 0 && this.encryptType <= 3;
    }
}

