/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.AbstractProtocolParser;
import com.hs.atic.collector.entity.pcap.ArpProtocol;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SingleValueProtocolType;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ArpProtocolParser
extends AbstractProtocolParser {
    private static SubProtocolType subType = new SingleValueProtocolType(2054);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Protocol parseHead(byte[] data) {
        ArpProtocol protocol = new ArpProtocol();
        UnsignedDataInputStream stream = null;
        try {
            stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
            protocol.setHardwareType(stream.readUnsignedShort());
            protocol.setEmbedProtocolType(stream.readUnsignedShort());
            protocol.setHardwareSize(stream.readUnsignedByte());
            protocol.setProtocolSize(stream.readUnsignedByte());
            protocol.setOpCode(stream.readUnsignedShort());
            protocol.setSenderMacAddress(this.getMacAddress(stream));
            protocol.setSenderIpAddress(IpTransformer.long2StringFormat(stream.readUnsignedInt()));
            protocol.setTargetMacAddress(this.getMacAddress(stream));
            protocol.setTargetIpAddress(IpTransformer.long2StringFormat(stream.readUnsignedInt()));
            ArpProtocol arpProtocol = protocol;
            return arpProtocol;
        }
        catch (IOException e) {
            ArpProtocol arpProtocol = protocol;
            return arpProtocol;
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    return protocol;
                }
            }
        }
    }

    private String getMacAddress(UnsignedDataInputStream stream) throws IOException {
        int mac1 = stream.readUnsignedByte();
        int mac2 = stream.readUnsignedByte();
        int mac3 = stream.readUnsignedByte();
        int mac4 = stream.readUnsignedByte();
        int mac5 = stream.readUnsignedByte();
        int mac6 = stream.readUnsignedByte();
        return Integer.toHexString(mac1) + ":" + Integer.toHexString(mac2) + ":" + Integer.toHexString(mac3) + ":" + Integer.toHexString(mac4) + ":" + Integer.toHexString(mac5) + ":" + Integer.toHexString(mac6);
    }

    @Override
    public boolean canParse(SubProtocolType type) {
        return subType.equals(type);
    }
}

