/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.AbstractProtocolParser;
import com.hs.atic.collector.entity.pcap.DnsProtocol;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import com.hs.atic.collector.entity.pcap.TransformProtocolType;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class DnsProtocolParser
extends AbstractProtocolParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private int port = 53;
    private byte[] loadData = new byte[0];

    private boolean fit(int newport) {
        return newport == this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Protocol parseHead(byte[] data) {
        DnsProtocol protocol = new DnsProtocol();
        FilterInputStream stream = null;
        try {
            this.loadData = data;
            protocol.setLoadData(data);
            protocol.setHeadData(data);
            stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
            int transactionId = ((DataInputStream)stream).readUnsignedShort();
            protocol.setTransactionId(transactionId);
            int flag = ((DataInputStream)stream).readUnsignedShort();
            protocol.setFlag(flag);
            if ((flag & 0x8000) == 0) {
                protocol.setQuery(true);
            }
            int queryNumber = ((DataInputStream)stream).readUnsignedShort();
            int answerNumber = ((DataInputStream)stream).readUnsignedShort();
            int authorizeNumber = ((DataInputStream)stream).readUnsignedShort();
            int additionalNumber = ((DataInputStream)stream).readUnsignedShort();
            protocol.setQueries(this.parseQueries(queryNumber, (UnsignedDataInputStream)stream));
            protocol.setAnswers(this.parseRr(answerNumber, (UnsignedDataInputStream)stream, data));
            protocol.setAuthorizeResources(this.parseRr(authorizeNumber, (UnsignedDataInputStream)stream, data));
            protocol.setAdditionalRecords(this.parseRr(additionalNumber, (UnsignedDataInputStream)stream, data));
            DnsProtocol dnsProtocol = protocol;
            return dnsProtocol;
        }
        catch (IOException e) {
            DnsProtocol dnsProtocol = protocol;
            return dnsProtocol;
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    return protocol;
                }
            }
        }
    }

    public List<DnsProtocol.DnsQuery> parseQueries(int size, UnsignedDataInputStream stream) throws IOException {
        ArrayList<DnsProtocol.DnsQuery> questions = new ArrayList<DnsProtocol.DnsQuery>();
        for (int i = 0; i < size; ++i) {
            String queryName = this.getQueryFormat(stream);
            int queryType = stream.readUnsignedShort();
            int queryClass = stream.readUnsignedShort();
            DnsProtocol.DnsQuery question = new DnsProtocol.DnsQuery();
            question.setQueryName(queryName);
            question.setQueryClass(queryClass);
            question.setQueryType(queryType);
            questions.add(question);
        }
        return questions;
    }

    private String getQueryFormat(UnsignedDataInputStream stream) throws IOException {
        int size;
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> subStr = new ArrayList<String>();
        while ((size = stream.readUnsignedByte()) != 0) {
            if ((size & 0xC0) != 0) {
                int offset = (size & 0x3F) * 256 + stream.readUnsignedByte();
                if (this.loadData.length > offset) {
                    byte[] bytes = new byte[this.loadData.length - offset];
                    System.arraycopy(this.loadData, offset, bytes, 0, this.loadData.length - offset);
                    stream = new UnsignedDataInputStream(new ByteArrayInputStream(bytes));
                    continue;
                }
                byte[] charArray = new byte[size];
                if (stream.read(charArray) != size) {
                    LOGGER.error((Object)"stream read error");
                }
                subStr.add(new String(charArray, "utf-8"));
                continue;
            }
            byte[] charArray = new byte[size];
            if (stream.read(charArray) != size) {
                LOGGER.error((Object)"stream read error");
            }
            subStr.add(new String(charArray, "utf-8"));
        }
        Iterator itor = subStr.iterator();
        while (itor.hasNext()) {
            buffer.append((String)itor.next());
            if (!itor.hasNext()) continue;
            buffer.append('.');
        }
        return buffer.toString();
    }

    public List<DnsProtocol.DnsRr> parseRr(int size, UnsignedDataInputStream stream, byte[] date) throws IOException {
        ArrayList<DnsProtocol.DnsRr> dnsRrs = new ArrayList<DnsProtocol.DnsRr>();
        for (int i = 0; i < size; ++i) {
            String domain = this.getQueryFormat(stream);
            int type = stream.readUnsignedShort();
            int rrClass = stream.readUnsignedShort();
            long ttl = stream.readUnsignedInt();
            int dataLength = stream.readUnsignedShort();
            byte[] contentBytes = new byte[dataLength];
            if (stream.read(contentBytes) != dataLength) {
                LOGGER.error((Object)"stream read error");
            }
            DnsProtocol.DnsRr dnsRr = new DnsProtocol.DnsRr();
            dnsRr.setDomain(domain);
            dnsRr.setType(type);
            dnsRr.setClassType(rrClass);
            dnsRr.setTtl(ttl);
            dnsRr.setDataLength(dataLength);
            if (type == 1) {
                dnsRr.setDescription(IpTransformer.byte2String(contentBytes));
            }
            if (type == 2) {
                dnsRr.setDescription(this.getQueryFormat(new UnsignedDataInputStream(new ByteArrayInputStream(contentBytes))));
            }
            if (type == 5) {
                dnsRr.setDescription(this.getQueryFormat(new UnsignedDataInputStream(new ByteArrayInputStream(contentBytes))));
            }
            dnsRr.setDataContent(contentBytes);
            dnsRrs.add(dnsRr);
        }
        return dnsRrs;
    }

    @Override
    public boolean canParse(SubProtocolType type) {
        TransformProtocolType transType;
        return type instanceof TransformProtocolType && (this.fit((transType = (TransformProtocolType)type).getSource()) || this.fit(transType.getTarget()));
    }
}

