/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.AbstractProtocolParser;
import com.hs.atic.collector.entity.pcap.HttpProtocol;
import com.hs.atic.collector.entity.pcap.HttpRequest;
import com.hs.atic.collector.entity.pcap.HttpResponse;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import com.hs.atic.collector.entity.pcap.TransformProtocolType;
import com.hs.atic.collector.util.CommonUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class HttpProtocolParser
extends AbstractProtocolParser {
    private int port = 80;
    private int port2 = 8080;
    private boolean isRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Protocol parseHead(byte[] data) {
        HttpProtocol protocol = new HttpProtocol();
        protocol.setLoadData(data);
        protocol.setHeadData(data);
        BufferedReader reader = null;
        try {
            Object startLine;
            reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(data), "utf-8"));
            if (this.isRequest) {
                startLine = reader.readLine();
                if (!CommonUtil.isNull((String)startLine)) {
                    HttpRequest request = new HttpRequest((String)startLine);
                    if (request.getIsWellDefined().booleanValue()) {
                        String headLine;
                        while (!CommonUtil.isNull(headLine = reader.readLine())) {
                            request.addHeadContent(headLine, "");
                        }
                    }
                    protocol.setRequest(request);
                }
            } else {
                startLine = reader.readLine();
                if (!CommonUtil.isNull((String)startLine)) {
                    HttpResponse response = new HttpResponse((String)startLine);
                    if (response.getIsWellDefined().booleanValue()) {
                        String headLine;
                        while (!CommonUtil.isNull(headLine = reader.readLine())) {
                            response.addHeadContent(headLine, "");
                        }
                    }
                    protocol.setResponse(response);
                }
            }
            startLine = protocol;
            return startLine;
        }
        catch (IOException e) {
            HttpProtocol httpProtocol = protocol;
            return httpProtocol;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    return protocol;
                }
            }
        }
    }

    @Override
    public boolean canParse(SubProtocolType type) {
        if (type instanceof TransformProtocolType) {
            TransformProtocolType transType = (TransformProtocolType)type;
            if (this.fit(transType.getSource())) {
                this.isRequest = false;
                return true;
            }
            if (this.fit(transType.getTarget())) {
                this.isRequest = true;
                return true;
            }
        }
        return false;
    }

    private boolean fit(int ports) {
        return ports == this.port || ports == this.port2;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

