/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class HttpRequest
implements Serializable {
    private static final long serialVersionUID = 3884509875816908496L;
    private static final int WELL_DEFINED_HEAD_SIZE = 3;
    private String requestMethod;
    private String url;
    private String version;
    private Map<String, String> generalHead = new LinkedHashMap<String, String>();
    private Boolean isWellDefined = false;

    public HttpRequest(String startLine) {
        String[] array = startLine.split(" ");
        if (array.length == 3) {
            this.requestMethod = array[0];
            this.url = array[1];
            this.version = array[2];
            this.isWellDefined = true;
        }
    }

    public Boolean getIsWellDefined() {
        return this.isWellDefined;
    }

    public void setIsWellDefined(Boolean isWellDefined) {
        this.isWellDefined = isWellDefined;
    }

    public void addHeadContent(String key, String value) {
        this.generalHead.put(key, value);
    }

    public String getDescription() {
        if (this.isWellDefined.booleanValue()) {
            return this.requestMethod + " " + this.url;
        }
        return "Continuation or Non-HTTP Traffic";
    }

    public Map<String, String> getHeadContent() {
        LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
        if (this.isWellDefined.booleanValue()) {
            content.put("Request Method", this.requestMethod);
            content.put("Request URI", this.url);
            content.put("Request Version", this.version);
            content.putAll(this.generalHead);
        }
        return content;
    }
}

