/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.AbstractProtocolParser;
import com.hs.atic.collector.entity.pcap.IcmpProtocol;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SingleValueProtocolType;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class IcmpProtocolParser
extends AbstractProtocolParser {
    private static final int PING_REPLY_TYPE = 0;
    private static final int UNREACHABLE_TYPE = 3;
    private static final int REDIRECT_TYPE = 5;
    private static final int PING_REQUEST_TYPE = 8;
    private static final int ROUTER_REPLY_TYPE = 9;
    private static final int ROUTER_REQUEST_TYPE = 10;
    private static final int TIMEOUT_TYPE = 11;
    private static final int TIMESTAMP_REQUEST_TYPE = 13;
    private static final int TIMESTAMP_REPLY_TYPE = 14;
    private static final int MASK_REPLY_TYPE = 18;
    private static final int MASK_REQUEST_TYPE = 17;
    private static final int FRAG_UNREACHABLE = 4;
    private static SubProtocolType protocolType = new SingleValueProtocolType(1);

    @Override
    public boolean canParse(SubProtocolType type) {
        return protocolType.equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Protocol parseHead(byte[] data) {
        IcmpProtocol protocol = new IcmpProtocol();
        UnsignedDataInputStream stream = null;
        try {
            stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
            int type = stream.readUnsignedByte();
            protocol.setType(type);
            int code = stream.readUnsignedByte();
            protocol.setCode(code);
            int checkSum = stream.readUnsignedShort();
            protocol.setCheckSum(checkSum);
            switch (type) {
                case 0: {
                    IcmpProtocol.PingType innerType = new IcmpProtocol.PingType();
                    innerType.setIsReply(true);
                    innerType.setIdentifier(stream.readUnsignedShort());
                    innerType.setSerialNumber(stream.readUnsignedShort());
                    innerType.setDataLength(data.length);
                    protocol.setInnerType(innerType);
                    break;
                }
                case 8: {
                    IcmpProtocol.PingType innerType = new IcmpProtocol.PingType();
                    innerType.setIsReply(false);
                    innerType.setIdentifier(stream.readUnsignedShort());
                    innerType.setSerialNumber(stream.readUnsignedShort());
                    innerType.setDataLength(data.length);
                    protocol.setInnerType(innerType);
                    break;
                }
                case 3: {
                    IcmpProtocol.IcmpInnerType unreach;
                    if (code == 4) {
                        unreach = new IcmpProtocol.FragmentUnreachableType();
                        stream.readUnsignedShort();
                        ((IcmpProtocol.FragmentUnreachableType)unreach).setMtu(stream.readUnsignedShort());
                        ((IcmpProtocol.FragmentUnreachableType)unreach).setDataLength(data.length);
                        protocol.setInnerType(unreach);
                        break;
                    }
                    unreach = new IcmpProtocol.UnreachableType();
                    ((IcmpProtocol.UnreachableType)unreach).setDataLength(data.length);
                    ((IcmpProtocol.UnreachableType)unreach).setCode(code);
                    protocol.setInnerType(unreach);
                    break;
                }
                case 5: {
                    IcmpProtocol.RedirectType redirectType = new IcmpProtocol.RedirectType();
                    redirectType.setCode(code);
                    redirectType.setIp(IpTransformer.long2StringFormat(stream.readUnsignedInt()));
                    redirectType.setDataLength(data.length);
                    protocol.setInnerType(redirectType);
                    break;
                }
                case 10: {
                    IcmpProtocol.RouterRequestType requestType = new IcmpProtocol.RouterRequestType();
                    protocol.setInnerType(requestType);
                    break;
                }
                case 9: {
                    IcmpProtocol.RouterReplyType replyType = new IcmpProtocol.RouterReplyType();
                    int addressNumber = stream.readUnsignedByte();
                    replyType.setAddressNumber(addressNumber);
                    int addressLength = stream.readUnsignedByte();
                    replyType.setAddressLength(addressLength);
                    int aliveTime = stream.readUnsignedShort();
                    replyType.setAliveTime(aliveTime);
                    long[][] addressPair = new long[addressNumber][2];
                    for (int i = 0; i < addressLength; ++i) {
                        addressPair[i][0] = stream.readUnsignedInt();
                        addressPair[i][1] = stream.readUnsignedInt();
                    }
                    replyType.setAddressPair(addressPair);
                    protocol.setInnerType(replyType);
                    break;
                }
                case 11: {
                    IcmpProtocol.TimeOutType timeOut = new IcmpProtocol.TimeOutType();
                    timeOut.setDataLength(data.length);
                    protocol.setInnerType(timeOut);
                    break;
                }
                case 13: {
                    IcmpProtocol.TimeStampType timeStamp = new IcmpProtocol.TimeStampType();
                    timeStamp.setIdentifier(stream.readUnsignedShort());
                    timeStamp.setSequenceNumber(stream.readUnsignedShort());
                    timeStamp.setOriginalTime(stream.readUnsignedInt());
                    timeStamp.setReceiveTime(stream.readUnsignedInt());
                    timeStamp.setTransmitTime(stream.readUnsignedInt());
                    timeStamp.setIsReply(false);
                    protocol.setInnerType(timeStamp);
                    break;
                }
                case 14: {
                    IcmpProtocol.TimeStampType timeStamp = new IcmpProtocol.TimeStampType();
                    timeStamp.setIdentifier(stream.readUnsignedShort());
                    timeStamp.setSequenceNumber(stream.readUnsignedShort());
                    timeStamp.setOriginalTime(stream.readUnsignedInt());
                    timeStamp.setReceiveTime(stream.readUnsignedInt());
                    timeStamp.setTransmitTime(stream.readUnsignedInt());
                    timeStamp.setIsReply(true);
                    protocol.setInnerType(timeStamp);
                    break;
                }
                case 18: {
                    IcmpProtocol.MaskType maskType = new IcmpProtocol.MaskType();
                    maskType.setIsReply(true);
                    maskType.setIdentifier(stream.readUnsignedShort());
                    maskType.setSerialNumber(stream.readUnsignedShort());
                    maskType.setMark(stream.readUnsignedInt());
                    protocol.setInnerType(maskType);
                    break;
                }
                case 17: {
                    IcmpProtocol.MaskType maskType = new IcmpProtocol.MaskType();
                    maskType.setIsReply(false);
                    maskType.setIdentifier(stream.readUnsignedShort());
                    maskType.setSerialNumber(stream.readUnsignedShort());
                    maskType.setMark(stream.readUnsignedInt());
                    protocol.setInnerType(maskType);
                    break;
                }
                default: {
                    IcmpProtocol.OtherType inner = new IcmpProtocol.OtherType();
                    protocol.setInnerType(inner);
                }
            }
            protocol.setHeadData(data);
            protocol.setLoadData(data);
            IcmpProtocol icmpProtocol = protocol;
            return icmpProtocol;
        }
        catch (IOException e) {
            IcmpProtocol icmpProtocol = protocol;
            return icmpProtocol;
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    return protocol;
                }
            }
        }
    }
}

