/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.AbstractProtocolParser;
import com.hs.atic.collector.entity.pcap.IpProtocol4IpV6;
import com.hs.atic.collector.entity.pcap.IpV6ExpanderHeader;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SingleValueProtocolType;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class IpProtocolParser4IpV6
extends AbstractProtocolParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static SubProtocolType typeFlag = new SingleValueProtocolType(34525);
    private static int udpCode = 17;
    private static int tcpCode = 6;
    private static int icmpCode = 58;

    public boolean isTransmissionProtocolHeader(int code) {
        return udpCode == code || tcpCode == code || icmpCode == code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Protocol parseHead(byte[] data) {
        IpProtocol4IpV6 protocol = new IpProtocol4IpV6();
        UnsignedDataInputStream stream = null;
        try {
            stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
            int value = stream.readUnsignedByte();
            protocol.setVersion(value >> 4);
            int trafficClass = stream.readUnsignedByte();
            protocol.setTrafficClass((value & 0xF) << 4 | (trafficClass & 0xFF) >> 4);
            int flowLable = stream.readUnsignedShort();
            protocol.setFlowLabel((long)((trafficClass & 0xF) << 16) | (long)(flowLable & 0xFFFF));
            int dataLength = stream.readUnsignedShort();
            protocol.setLength(dataLength);
            int nextHeader = stream.readUnsignedByte();
            protocol.setNextHeaderIp(nextHeader);
            protocol.setHopLimit(stream.readUnsignedByte());
            byte[] source = new byte[16];
            byte[] des = new byte[16];
            if (stream.available() >= 16) {
                if (stream.read(source) != 16) {
                    LOGGER.error((Object)"stream read error");
                }
                protocol.setSource(IpTransformer.compressIPv6(IpTransformer.byte2String(source, 6)));
            }
            if (stream.available() >= 16) {
                if (stream.read(des) != 16) {
                    LOGGER.error((Object)"stream read error");
                }
                protocol.setDestination(IpTransformer.compressIPv6(IpTransformer.byte2String(des, 6)));
            }
            int headLength = 40;
            while (!this.isTransmissionProtocolHeader(nextHeader)) {
                IpV6ExpanderHeader expanderHeader = new IpV6ExpanderHeader();
                expanderHeader.setHeader(nextHeader);
                nextHeader = stream.readUnsignedByte();
                expanderHeader.setNextheader(nextHeader);
                int expanderLength = stream.readUnsignedByte();
                expanderHeader.setLength(expanderLength);
                headLength += (expanderLength + 1) * 8;
                if (stream.skip((expanderLength + 1) * 8 - 2) != (long)((expanderLength + 1) * 8 - 2)) {
                    LOGGER.error((Object)"stream read error");
                }
                protocol.addExpandHeaders(expanderHeader);
            }
            byte[] headData = new byte[headLength < data.length ? headLength : data.length];
            System.arraycopy(data, 0, headData, 0, headLength < data.length ? headLength : data.length);
            protocol.setHeadData(headData);
            byte[] loadData = new byte[data.length - headLength];
            System.arraycopy(data, headLength, loadData, 0, loadData.length);
            protocol.setLoadData(loadData);
            protocol.setSubTypeFlag(new SingleValueProtocolType(nextHeader));
            IpProtocol4IpV6 ipProtocol4IpV6 = protocol;
            return ipProtocol4IpV6;
        }
        catch (IOException e) {
            IpProtocol4IpV6 ipProtocol4IpV6 = protocol;
            return ipProtocol4IpV6;
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    return protocol;
                }
            }
        }
    }

    @Override
    public boolean canParse(SubProtocolType type) {
        return typeFlag.equals(type);
    }
}

