/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.biz.pcap.PcapIdentifier;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.util.CommonUtil;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class PcapEntity {
    private static final byte[] MAC_HEAD = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 8, 0};
    private static final byte[] MAC_HEAD_V6 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, -122, -35};
    PcapIdentifier pcapIdentifier;
    private byte[] data;
    private int length;
    private int sequenceNumber;
    private AttackType attackType;
    private int type;

    public PcapEntity(PcapIdentifier pcapIdentifier) {
        this.pcapIdentifier = pcapIdentifier;
    }

    public AttackType getAttackType() {
        return this.attackType;
    }

    public void setAttackType(AttackType attackType) {
        this.attackType = attackType;
    }

    public byte[] getData() {
        if (null == this.data) {
            this.data = new byte[0];
        }
        byte[] content = new byte[this.data.length];
        System.arraycopy(this.data, 0, content, 0, this.data.length);
        return content;
    }

    public int getLength() {
        return this.length;
    }

    public int getPackageLength() {
        return this.length;
    }

    public PcapIdentifier getPcapIdentifier() {
        return this.pcapIdentifier;
    }

    public int getRealLength() {
        return this.length;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getType() {
        return this.type;
    }

    public void setData(byte[] data) {
        if (data.length == 0) {
            throw new IllegalArgumentException("capture data is null");
        }
        int version = data[0] >> 4;
        if (version == 6) {
            this.data = new byte[data.length + MAC_HEAD_V6.length];
            System.arraycopy(MAC_HEAD_V6, 0, this.data, 0, MAC_HEAD_V6.length);
            System.arraycopy(data, 0, this.data, MAC_HEAD_V6.length, data.length);
        } else {
            this.data = new byte[data.length + MAC_HEAD.length];
            System.arraycopy(MAC_HEAD, 0, this.data, 0, MAC_HEAD.length);
            System.arraycopy(data, 0, this.data, MAC_HEAD.length, data.length);
        }
    }

    public void setLength(int length) {
        this.length = length + 14;
    }

    public void setPcapIdentifier(PcapIdentifier pcapIdentifier) {
        this.pcapIdentifier = pcapIdentifier;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String toString() {
        if (null == this.attackType) {
            this.setAttackType(new AttackType(0, 0, 0));
        }
        if (null == this.data) {
            this.setData(new byte[0]);
        }
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).appendSuper("super").append("PcapIdentifiler", (Object)this.pcapIdentifier.toString()).append("attackType is ", (Object)this.attackType.toString()).append("data length is ", this.data.length).append("data content is ", (Object)CommonUtil.getByteArrayStr(this.data)).toString();
    }
}

