/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.biz.pcap.PcapIdentifier;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.pcap.PcapEntity;
import com.hs.atic.collector.entity.pcap.PcapFileWriter;
import com.hs.atic.collector.util.PcapUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class PcapFileInfo {
    public static final int COMPLETED = 0;
    public static final int UNCOMPLETED = 1;
    protected transient PcapFileWriter writer;
    private AttackType attackType;
    private PcapIdentifier identifier;
    private long taskId;
    private boolean isCompleted;
    private String fileName;
    private long beginTime;
    private int captureNumber;
    private long endTime;
    private long fileSize;
    private File file;
    private long pcapFilepkId = -1L;

    public PcapFileInfo(PcapIdentifier identifier, long taskId, String fileName) throws IOException {
        this.identifier = identifier;
        this.taskId = taskId;
        this.fileName = fileName;
        this.file = new File(PcapUtil.getCanonicalPath(fileName));
        this.beginTime = System.currentTimeMillis();
        this.writer = new PcapFileWriter(PcapUtil.getCanonicalPath(fileName));
    }

    public boolean isSaved() {
        return this.pcapFilepkId != -1L;
    }

    public long getPcapFilePkId() {
        return this.pcapFilepkId;
    }

    public void setPcapFilePkId(long pkId) {
        this.pcapFilepkId = pkId;
    }

    public AttackType getAttackType() {
        return this.attackType;
    }

    public void setAttackType(AttackType attackType) {
        this.attackType = attackType;
    }

    public void addCaptureNumber() {
        ++this.captureNumber;
    }

    public void appendEntity(PcapEntity data) throws IOException {
        this.writer.appendEntity(data);
        ++this.captureNumber;
        this.setEndTime(System.currentTimeMillis());
        this.setFileSize(this.file.length());
        this.attackType = data.getAttackType();
    }

    public boolean checkFileWriter() {
        if (null != this.writer) {
            return this.writer.checkFileWriter();
        }
        return false;
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        this.setEndTime(System.currentTimeMillis());
        this.setFileSize(this.file.length());
        this.setCompleted(true);
    }

    public boolean delete() {
        return this.file.delete();
    }

    public boolean equals(Object o) {
        if (o instanceof PcapFileInfo) {
            PcapFileInfo info = (PcapFileInfo)o;
            return info.getFileName().equals(this.getFileName()) && info.getTaskId() == this.getTaskId();
        }
        return false;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public int getCaptureNumber() {
        return this.captureNumber;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public PcapIdentifier getIdentifier() {
        return this.identifier;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public int hashCode() {
        return this.fileName.hashCode() * 17 + (int)(this.taskId ^ this.taskId >>> 32);
    }

    public boolean isIsCompleted() {
        return this.isCompleted;
    }

    public boolean isFull(int required) {
        return this.captureNumber >= required;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public void setCaptureNumber(int captureNumber) {
        this.captureNumber = captureNumber;
    }

    public void setCompleted(boolean isComplete) {
        this.isCompleted = isComplete;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public void setIdentifier(PcapIdentifier identifier) {
        this.identifier = identifier;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("pcapTaskId", this.taskId).append("pcapIdentifier", (Object)this.identifier).append("isFinished", this.isCompleted).append("fileName", (Object)this.fileName).append("fileSize", (Object)(this.fileSize + " byte")).append("startTime", (Object)new Date(this.beginTime)).append("endTime", (Object)new Date(this.endTime)).append("isSaved", this.isSaved()).toString();
    }
}

