/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.NetProtocol;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.UnresolvedProtocol;
import java.io.Serializable;

public class ProtocolItem
implements Serializable {
    private static final long serialVersionUID = -4859800920708236562L;
    private Protocol protocol;
    private long time;
    private int id;

    public byte[] getBytes() {
        if (null == this.protocol) {
            return new byte[0];
        }
        return this.protocol.getLoadData();
    }

    public String getDescription() {
        Protocol subProtocol = this.protocol;
        String description = "";
        if (null != subProtocol) {
            description = subProtocol.getDescription();
        }
        while (null != subProtocol && !(subProtocol.getSubProtocol() instanceof UnresolvedProtocol)) {
            if ((subProtocol = subProtocol.getSubProtocol()) == null) continue;
            try {
                description = subProtocol.getDescription();
            }
            catch (Exception e) {
                return null;
            }
        }
        return description;
    }

    public String getDestinationIp() {
        Protocol subProtocol = this.protocol;
        String destination = null;
        while (subProtocol != null && !(subProtocol.getSubProtocol() instanceof UnresolvedProtocol)) {
            if (!((subProtocol = subProtocol.getSubProtocol()) instanceof NetProtocol)) continue;
            destination = ((NetProtocol)subProtocol).getDestination();
        }
        return destination;
    }

    public int getId() {
        return this.id;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getProtocolName() {
        Protocol subProtocol = this.protocol;
        String protocolName = "";
        if (null != this.protocol) {
            protocolName = this.protocol.getProtocolName();
        }
        while (null != subProtocol && !(subProtocol.getSubProtocol() instanceof UnresolvedProtocol)) {
            if ((subProtocol = subProtocol.getSubProtocol()) == null) continue;
            protocolName = subProtocol.getProtocolName();
        }
        return protocolName;
    }

    public String getSourceIp() {
        Protocol subProtocol = this.protocol;
        String source = null;
        while (subProtocol != null && !(subProtocol.getSubProtocol() instanceof UnresolvedProtocol)) {
            if (!((subProtocol = subProtocol.getSubProtocol()) instanceof NetProtocol)) continue;
            source = ((NetProtocol)subProtocol).getSource();
        }
        return source;
    }

    public long getTime() {
        return this.time;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setTime(long time) {
        this.time = time;
    }
}

