/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.AbstractProtocolParser;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SingleValueProtocolType;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import com.hs.atic.collector.entity.pcap.TcpProtocol;
import com.hs.atic.collector.entity.pcap.TransformProtocolType;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class TcpProtocolParser
extends AbstractProtocolParser {
    private static SubProtocolType protocolType = new SingleValueProtocolType(6);
    private static final int NORMAL_HEAD_LENGTH = 20;

    @Override
    public boolean canParse(SubProtocolType type) {
        return protocolType.equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Protocol parseHead(byte[] data) {
        TcpProtocol protocol = new TcpProtocol();
        UnsignedDataInputStream stream = null;
        try {
            stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
            int sourcePort = stream.readUnsignedShort();
            protocol.setSourcePort(sourcePort);
            int destinationPort = stream.readUnsignedShort();
            protocol.setDestinationPort(destinationPort);
            long sequenceNumber = stream.readUnsignedInt();
            protocol.setSequenceNumber(sequenceNumber);
            long acknowledgementNumber = stream.readUnsignedInt();
            protocol.setAcknowledgementNumber(acknowledgementNumber);
            int headLength = stream.readUnsignedByte() / 4;
            byte[] headData = new byte[headLength];
            protocol.setHeadData(headData);
            if (data.length < headLength) {
                headLength = data.length;
            }
            System.arraycopy(data, 0, headData, 0, headLength);
            int length = data.length - headLength;
            int flag = stream.readUnsignedByte();
            protocol.setFlag(flag);
            int windowSize = stream.readUnsignedShort();
            protocol.setWindowSize(windowSize);
            int checkSum = stream.readUnsignedShort();
            protocol.setCheckSum(checkSum);
            if (headLength > 20) {
                stream.readUnsignedInt();
                int mss = stream.readUnsignedShort();
                protocol.setMss(mss);
            }
            if (length > 0) {
                byte[] loadData = new byte[length];
                System.arraycopy(data, headLength, loadData, 0, loadData.length);
                protocol.setLength(length);
                protocol.setLoadData(loadData);
            } else {
                protocol.setLoadData(new byte[0]);
            }
            TransformProtocolType subProtocolType = new TransformProtocolType(sourcePort, destinationPort);
            protocol.setSubProtocolType(subProtocolType);
            TcpProtocol tcpProtocol = protocol;
            return tcpProtocol;
        }
        catch (IOException e) {
            TcpProtocol tcpProtocol = protocol;
            return tcpProtocol;
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    return protocol;
                }
            }
        }
    }
}

