/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.biz.event.process.DeviceType;
import com.hs.atic.collector.biz.event.process.IpType4ZoneCapture;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.biz.pcap.PcapBuilder;
import com.hs.atic.collector.biz.pcap.PcapIdentifier;
import com.hs.atic.collector.conn.ConnectionRmiThread;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.pcap.CaptureTask;
import com.hs.atic.collector.entity.pcap.PcapEntity;
import com.hs.atic.collector.entity.pcap.PcapFileInfo;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.rmi.NotifyCaptureTaskFinshedService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ZoneCaptureTask
extends CaptureTask {
    private static final String SERVICE_NAME = "notifyCaptureTaskFinshedService";
    private Map<Type, PcapFileInfo> files = new HashMap<Type, PcapFileInfo>();
    private Map<Type, Integer> fileIndexs = new HashMap<Type, Integer>();

    public ZoneCaptureTask(PcapIdentifier pcapIdentifier, String fileName, long taskId) throws IOException {
        super(pcapIdentifier, fileName, taskId);
    }

    @Override
    public synchronized void check() {
        Iterator<Map.Entry<Type, PcapFileInfo>> itor = this.files.entrySet().iterator();
        while (itor.hasNext()) {
            PcapFileInfo file = itor.next().getValue();
            if (!file.checkFileWriter()) continue;
            file.close();
            this.getPcapFileRepository().updateObject(file);
            itor.remove();
            LOGGER.info((Object)("now i remove the pcapFile " + ZoneCaptureTask.getcleanedMessage(file.getFileName())));
        }
    }

    @Override
    public void finish() {
        Iterator<Map.Entry<Type, PcapFileInfo>> itor = this.files.entrySet().iterator();
        while (itor.hasNext()) {
            PcapFileInfo file = itor.next().getValue();
            file.close();
            this.getPcapFileRepository().updateObject(file);
        }
        this.setFinished(true);
    }

    @Override
    protected PcapFileInfo getPcapFile(PcapEntity data) throws IOException {
        AttackType attackType = data.getAttackType();
        IpType4ZoneCapture type = new IpType4ZoneCapture(data.getPcapIdentifier().getPcapDeviceIP(), data.getPcapIdentifier().getDeviceType(), data.getPcapIdentifier().getZoneIp(), attackType);
        DeviceType indexType = new DeviceType(data.getPcapIdentifier().getPcapDeviceIP(), data.getPcapIdentifier().getDeviceType(), attackType);
        if (!(this.files.containsKey(type) || PcapBuilder.getInstance().isCaptureOverThreshold() || PcapBuilder.getInstance().isCaptureOverLevel())) {
            this.files.put(type, this.createNewFile(indexType, data.getPcapIdentifier(), attackType));
        }
        return this.files.get(type);
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private PcapFileInfo createNewFile(Type type, PcapIdentifier identifier, AttackType attackType) throws IOException {
        int index = 0;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("new create new file ,type is " + type + " and fileIndexs are " + this.fileIndexs));
        }
        if (this.fileIndexs.containsKey(type)) {
            index = this.fileIndexs.get(type);
            ++index;
        }
        String fileName = "";
        fileName = attackType.getTypeValue() >= 2000 ? this.getBaseFileName() + '_' + "Filter" + attackType.getTypeValue() + '_' + "Index" + '_' + index : this.getBaseFileName() + '_' + attackType.getDescription() + '_' + "Index" + '_' + index;
        fileName = ZoneCaptureTask.getcleanFileName(fileName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("new create new file ,name is " + index));
        }
        PcapFileInfo file = new PcapFileInfo(identifier, this.getTaskId(), fileName);
        file.setAttackType(attackType);
        this.fileIndexs.put(type, index);
        return file;
    }

    private static String getcleanFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        fileName = fileName.replaceAll("\\||/|:|\\*|\\?|\"|<|>|\\\\", "");
        return fileName;
    }

    @Override
    public void afterFileFull(PcapFileInfo file) throws IOException {
        file.close();
        this.getPcapFileRepository().updateObject(file);
        if (3 == file.getIdentifier().getType()) {
            NotifyCaptureTaskFinshedService listener = null;
            if (ConnectionRmiThread.getInstance().getRmiConnection().booleanValue()) {
                listener = (NotifyCaptureTaskFinshedService)CommonUtil.retreiveAticRmiService(SERVICE_NAME);
            }
            if (null != listener) {
                String collectorIp = System.getProperty("java.rmi.server.hostname");
                listener.notifyCaptureFileFinshed(file.getFileName(), file.getTaskId(), file.getAttackType().getTypeValue(), file.getAttackType().getProtocol(), collectorIp);
            }
        }
        AttackType attackType = file.getAttackType();
        IpType4ZoneCapture type = new IpType4ZoneCapture(file.getIdentifier().getPcapDeviceIP(), file.getIdentifier().getDeviceType(), file.getIdentifier().getZoneIp(), attackType);
        DeviceType indexType = new DeviceType(file.getIdentifier().getPcapDeviceIP(), file.getIdentifier().getDeviceType(), attackType);
        this.files.put(type, this.createNewFile(indexType, file.getIdentifier(), attackType));
    }

    @Override
    public void init(List<PcapFileInfo> pcapFiles) {
        for (PcapFileInfo file : pcapFiles) {
            AttackType attackType = file.getAttackType();
            IpType4ZoneCapture type = new IpType4ZoneCapture(file.getIdentifier().getPcapDeviceIP(), file.getIdentifier().getDeviceType(), file.getIdentifier().getZoneIp(), attackType);
            DeviceType indexType = new DeviceType(file.getIdentifier().getPcapDeviceIP(), file.getIdentifier().getDeviceType(), attackType);
            String fileName = file.getFileName();
            int inNum = 0;
            try {
                String fileIndex = fileName.substring(fileName.lastIndexOf(95) + 1, fileName.length());
                inNum = Integer.parseInt(fileIndex);
            }
            catch (Exception e) {
                LOGGER.error((Object)("get pcap index error!" + e.getMessage()));
            }
            if (this.fileIndexs.containsKey(indexType)) {
                int index = this.fileIndexs.get(indexType);
                this.fileIndexs.put(indexType, inNum > index ? inNum : index);
            } else {
                this.fileIndexs.put(indexType, inNum);
            }
            if (file.isIsCompleted()) continue;
            this.files.put(type, file);
        }
    }

    public Map<Type, PcapFileInfo> getFiles() {
        return this.files;
    }

    public Map<Type, Integer> getFileIndexs() {
        return this.fileIndexs;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("head", (Object)this.pcapIdentifier).append("fileIndexs", this.fileIndexs).append("files", this.files).toString();
    }
}

