/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.init;

import com.hs.atic.collector.db.monitor.DBSysConf;
import com.hs.atic.collector.util.LogManager;
import org.apache.log4j.Logger;

public final class CollectorVersionRepository {
    private static CollectorVersionRepository instance = new CollectorVersionRepository();
    private static final String QUERYVALUE = "COLLECTOR_VERSION";
    private static final int ATIC_VERSION = 0;
    private static final int NIP_SIMPLE_VERSION = 2;
    private Logger logger = LogManager.getInstance().getDBLog();
    private int version = this.loadVersion();

    private CollectorVersionRepository() {
        this.logger.info((Object)("load collector version :" + this.version));
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public static CollectorVersionRepository getInstance() {
        return instance;
    }

    private int loadVersion() {
        DBSysConf conf = new DBSysConf();
        String value = conf.querySysValue(QUERYVALUE);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void updateVersion(int newVersion) {
        this.version = newVersion;
        DBSysConf conf = new DBSysConf();
        this.logger.info((Object)("update collector version :" + newVersion));
        try {
            conf.update(QUERYVALUE, String.valueOf(newVersion));
        }
        catch (Exception e) {
            this.logger.info((Object)("update collector version error:" + newVersion));
        }
    }

    public boolean isNeedDrop() {
        return this.version != 2;
    }
}

