/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.init;

import com.hs.atic.collector.biz.CheckDevWorkThread;
import com.hs.atic.collector.biz.ZipThread;
import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.biz.alarm.DivertAlarmThread;
import com.hs.atic.collector.biz.alarm.SyslogThread;
import com.hs.atic.collector.biz.event.EventModel;
import com.hs.atic.collector.biz.event.nfa.NfaModel;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.biz.event.process.InitDataFromAticThread;
import com.hs.atic.collector.biz.event.process.unicom.CleanLogProcessThread;
import com.hs.atic.collector.biz.monitor.MonitorCollectorThread;
import com.hs.atic.collector.biz.pcap.PcapModel;
import com.hs.atic.collector.biz.report.ZoneSecurityTableUtil;
import com.hs.atic.collector.conn.ConnectionRmiThread;
import com.hs.atic.collector.db.daemon.BaseLineRecycleThread;
import com.hs.atic.collector.db.daemon.PartitionThread;
import com.hs.atic.collector.db.daemon.SummaryThread;
import com.hs.atic.collector.init.IpChangeTool;
import com.hs.atic.collector.manager.agent.resource.MBeanResourceFactory;
import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.CountAnomalyTimeThread;
import com.hs.atic.collector.util.CrashThreadHandler;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.rmi.impl.AnalyzeSuccessRateServiceImpl;
import com.hs.atic.rmi.impl.AttackDataServiceRMIImpl;
import com.hs.atic.rmi.impl.BaseLineDataServiceRmiImpl;
import com.hs.atic.rmi.impl.BlackListServiceRMIImpl;
import com.hs.atic.rmi.impl.CapturePcapServiceImpl;
import com.hs.atic.rmi.impl.CollectorLocationDevImpl;
import com.hs.atic.rmi.impl.CollectorSendSyslogServiceImpl;
import com.hs.atic.rmi.impl.DataStatServiceImpl;
import com.hs.atic.rmi.impl.DynamicBaseLineServiceImpl;
import com.hs.atic.rmi.impl.FileTransServiceImpl;
import com.hs.atic.rmi.impl.FlowCompareServiceImpl;
import com.hs.atic.rmi.impl.FoundDefaultIdRmiServiceImpl;
import com.hs.atic.rmi.impl.GuardCollectorStatusImpl;
import com.hs.atic.rmi.impl.IntelligentDefenseConfigServiceImpl;
import com.hs.atic.rmi.impl.NormalAndExceptServiceImpl;
import com.hs.atic.rmi.impl.NotifyFaultSeverityRuleServiceImpl;
import com.hs.atic.rmi.impl.PcapProtocolQueryServiceImpl;
import com.hs.atic.rmi.impl.ServiceLearningRMIServiceImpl;
import com.hs.atic.rmi.impl.ShowCollectorCounterServiceImpl;
import com.hs.atic.rmi.impl.SysManagerServiceImpl;
import com.hs.atic.rmi.impl.TopNIPFlowRmiImpl;
import com.hs.atic.rmi.impl.ZoneDnsTopNServiceRmiImpl;
import com.hs.atic.rmi.impl.ZoneDynBlackListServiceImpl;
import com.hs.atic.rmi.impl.ZonePacketServiceImpl;
import com.hs.atic.rmi.impl.ZoneStateServiceImpl;
import com.hs.lego.core.sdk.base.dataprotect.util.AticDataProtector;
import com.huawei.atic.rmi.registry.RegistryProxy;
import java.io.File;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Main {
    private static final Logger LOGGER = LogManager.getInstance().getSystemLog();

    public static void main(String[] args) {
        Main manager = new Main();
        manager.start();
    }

    public void start() {
        Thread monitorThread;
        LOGGER.warn((Object)"now begin start collector.");
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        if (1 == version) {
            IpChangeTool.initCheckCollectorIp();
        }
        LOGGER.warn((Object)("The max memory is " + Runtime.getRuntime().maxMemory() / 0x100000L + "M. The total memory is " + Runtime.getRuntime().totalMemory() / 0x100000L + "M. The free memory is " + Runtime.getRuntime().freeMemory() / 0x100000L + "M"));
        Properties properties = CommonUtil.loadCollectorCertInfoProperties();
        System.setProperty("javax.net.ssl.keyStore", AticInstallUtil.getInstance().getCollectorInstallPath() + File.separator + "cert" + File.separator + "collector_keystore");
        System.setProperty("javax.net.ssl.keyStorePassword", AticDataProtector.sdpDecryptInitData(properties.getProperty("keystore.collector.password")).toString());
        System.setProperty("javax.net.ssl.trustStore", AticInstallUtil.getInstance().getCollectorInstallPath() + File.separator + "cert" + File.separator + "collector_truststore");
        System.setProperty("javax.net.ssl.trustStorePassword", AticDataProtector.sdpDecryptInitData(properties.getProperty("truststore.collector.password")).toString());
        Registry registry = null;
        int collectoRmiPort = 11099;
        int collectoRmiServicePort = 33099;
        try {
            String port = EventUtil.getEventConfigProperty("CollectorRmiPort");
            collectoRmiPort = Integer.parseInt(port);
            String servicePort = EventUtil.getEventConfigProperty("CollectorRmiServicePort");
            collectoRmiServicePort = Integer.parseInt(servicePort);
        }
        catch (Exception e) {
            LogManager.getInstance().getRMILog().error((Object)("parse CollectorRmiPort error!" + e.getMessage()));
        }
        ClientSocketFactory csf = null;
        ServerSocketFactory ssf = null;
        try {
            csf = new ClientSocketFactory(true);
            String collectorIP = System.getProperty("java.rmi.server.hostname");
            ssf = new ServerSocketFactory(collectorIP, new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"}, new String[]{"TLSv1.2"}, true);
            registry = new RegistryProxy(collectoRmiPort, csf, ssf);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)("rmi over ssl LocateRegistry.createRegistry(11099, csf, ssf) error ! Program exit!" + e.getMessage()));
            System.exit(1);
        }
        try {
            if (null == registry) {
                throw new RemoteException("registry is null!");
            }
            SysManagerServiceImpl sysManagerService = new SysManagerServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("sysManagerService", sysManagerService);
            DataStatServiceImpl dataStatService = new DataStatServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("dataStatService", dataStatService);
            NormalAndExceptServiceImpl normalAndExceptionService = new NormalAndExceptServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("normalAndExceptionService", normalAndExceptionService);
            AnalyzeSuccessRateServiceImpl analyzeSuccessRateService = new AnalyzeSuccessRateServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("analyzeSuccessRateService", analyzeSuccessRateService);
            FlowCompareServiceImpl flowCompareService = new FlowCompareServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("flowCompareService", flowCompareService);
            ZonePacketServiceImpl zonePacketService = new ZonePacketServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("zonePacketService", zonePacketService);
            FileTransServiceImpl fileTransService = new FileTransServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("fileTransService", fileTransService);
            DynamicBaseLineServiceImpl dynamicBaseLineService = new DynamicBaseLineServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("dynamicBaseLineService", dynamicBaseLineService);
            CapturePcapServiceImpl capturePcapService = new CapturePcapServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("capturePcapService", capturePcapService);
            PcapProtocolQueryServiceImpl pcapProtocolQueryService = new PcapProtocolQueryServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("pcapProtocolQueryService", pcapProtocolQueryService);
            ZoneStateServiceImpl zoneStateService = new ZoneStateServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("zoneStateService", zoneStateService);
            ZoneDynBlackListServiceImpl zoneDynBlackListService = new ZoneDynBlackListServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("zoneDynBlackListService", zoneDynBlackListService);
            BaseLineDataServiceRmiImpl baseline = new BaseLineDataServiceRmiImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("zoneBaselineService", baseline);
            AttackDataServiceRMIImpl attackDataService = new AttackDataServiceRMIImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("attackDataService", attackDataService);
            ZoneDnsTopNServiceRmiImpl zoneDnsSrcTopNService = new ZoneDnsTopNServiceRmiImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("zoneDnsSrcTopNService", zoneDnsSrcTopNService);
            BlackListServiceRMIImpl blackListService = new BlackListServiceRMIImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("blackListService", blackListService);
            ServiceLearningRMIServiceImpl sericeLearningService = new ServiceLearningRMIServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("serviceLearningService", sericeLearningService);
            FoundDefaultIdRmiServiceImpl foundDefaultIdRmiService = new FoundDefaultIdRmiServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("foundDefaultIdRelationService", foundDefaultIdRmiService);
            NotifyFaultSeverityRuleServiceImpl notifyFaultSeverityRuleService = new NotifyFaultSeverityRuleServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("notifyFaultSeverityRuleService", notifyFaultSeverityRuleService);
            ShowCollectorCounterServiceImpl showCollectorCounterService = new ShowCollectorCounterServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("showCollectorCounterService", showCollectorCounterService);
            CollectorSendSyslogServiceImpl collectorSendSyslogService = new CollectorSendSyslogServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("collectorSendSyslogService", collectorSendSyslogService);
            GuardCollectorStatusImpl guardCollectorStatus = new GuardCollectorStatusImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("guardCollectorStatus", guardCollectorStatus);
            TopNIPFlowRmiImpl toponIPFlowService = new TopNIPFlowRmiImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("toponIPFlowService", toponIPFlowService);
            CollectorLocationDevImpl collectorLocationDevService = new CollectorLocationDevImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("collectorLocationDevService", collectorLocationDevService);
            IntelligentDefenseConfigServiceImpl intelligentDefenseService = new IntelligentDefenseConfigServiceImpl(collectoRmiServicePort, csf, ssf);
            registry.rebind("IntelligentDefenseConfigService", intelligentDefenseService);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)("rmi service bind error! Program exit!" + e.getMessage()));
            System.exit(1);
        }
        CrashThreadHandler crashThreadHandler = CrashThreadHandler.getInstance();
        try {
            InitDataFromAticThread initDataThread = new InitDataFromAticThread();
            initDataThread.setUncaughtExceptionHandler(crashThreadHandler);
            initDataThread.start();
            LOGGER.info((Object)"initDataThread start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("InitDataFromAticThread start failed ! Program exit !" + e.getMessage()));
            System.exit(1);
        }
        try {
            PartitionThread partition = new PartitionThread();
            Thread partitionThread = new Thread((Runnable)partition, "manager table partition");
            partitionThread.setUncaughtExceptionHandler(crashThreadHandler);
            partitionThread.start();
            LOGGER.info((Object)"partitionThread start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("PartitionThread start failed ! Program exit !" + e.getMessage()));
            System.exit(1);
        }
        try {
            BaseLineRecycleThread baseLineRecycle = new BaseLineRecycleThread();
            Thread baseLineRecycleThread = new Thread((Runnable)baseLineRecycle, "manager table baseline");
            baseLineRecycleThread.setUncaughtExceptionHandler(crashThreadHandler);
            baseLineRecycleThread.start();
            LOGGER.info((Object)"baseLineRecycleThread start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("PartitionThread start failed ! Program exit !" + e.getMessage()));
            System.exit(1);
        }
        try {
            CheckDevWorkThread checkThread = new CheckDevWorkThread();
            monitorThread = new Thread((Runnable)checkThread, "checkThread");
            monitorThread.setUncaughtExceptionHandler(crashThreadHandler);
            monitorThread.start();
            LOGGER.info((Object)"monitorThread start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("CheckDevWorkThread start failed ! Program exit !" + e.getMessage()));
            System.exit(1);
        }
        try {
            AlarmThread alarmThread = AlarmThread.getInstance();
            alarmThread.setUncaughtExceptionHandler(crashThreadHandler);
            alarmThread.start();
            LOGGER.info((Object)"alarmThread start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("AlarmThread start failed ! Program exit !" + e.getMessage()));
            System.exit(1);
        }
        try {
            DivertAlarmThread blackholeAlarmThread = new DivertAlarmThread(2);
            blackholeAlarmThread.setName("BlackholeAlarmThread");
            blackholeAlarmThread.setUncaughtExceptionHandler(crashThreadHandler);
            blackholeAlarmThread.start();
            LOGGER.info((Object)"blackholeAlarmThread start OK !");
            DivertAlarmThread divertAlarmThread = new DivertAlarmThread(1);
            divertAlarmThread.setName("DivertAlarmThread");
            divertAlarmThread.setUncaughtExceptionHandler(crashThreadHandler);
            divertAlarmThread.start();
            LOGGER.info((Object)"divertAlarmThread start OK !");
            AlarmThread.getInstance().setBlackholeAlarmThread(blackholeAlarmThread);
            AlarmThread.getInstance().setDivertAlarmThread(divertAlarmThread);
            LOGGER.info((Object)"AlarmThread start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("start blackholeAlarmThread or divertAlarmThread error!" + e.getMessage()));
            System.exit(1);
        }
        try {
            SyslogThread syslogThread = SyslogThread.getInstance();
            syslogThread.setUncaughtExceptionHandler(crashThreadHandler);
            syslogThread.start();
            LOGGER.info((Object)"syslogThread start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("AlarmThread start failed ! Program exit !" + e.getMessage()));
            System.exit(1);
        }
        try {
            ConnectionRmiThread connectionRmiThread = ConnectionRmiThread.getInstance();
            Thread conRmi = new Thread((Runnable)connectionRmiThread, "ConnectionRmiThread");
            conRmi.setUncaughtExceptionHandler(crashThreadHandler);
            conRmi.start();
            LOGGER.info((Object)"ConnectionRmiThread start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("ConnectionRmiThread start failed ! Program exit !" + e.getMessage()));
            System.exit(1);
        }
        try {
            CountAnomalyTimeThread countThread = CountAnomalyTimeThread.getInstane();
            Thread count = new Thread((Runnable)countThread, "countThread");
            count.setUncaughtExceptionHandler(crashThreadHandler);
            count.start();
            LOGGER.info((Object)"CountAnomalyTimeThread start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("CountAnomalyTimeThread start failed ! Program exit !" + e.getMessage()));
            System.exit(1);
        }
        try {
            ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
            zoneSecurityTableUtil.createZoneSecurityTemporaryTable();
            FoundIDUtil.getInstance().initQuery();
            LOGGER.info((Object)"FoundIDUtil initQuery OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("Database(ZoneSecurityTableUtil or FoundIDUtil.getInstance().initQuery()) init failed ! Program exit !" + e.getMessage()));
            System.exit(1);
        }
        try {
            EventModel eventModel = EventModel.getInstance();
            eventModel.start();
            LOGGER.info((Object)"eventModel 9110 start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("EventModel start failed ! Program exit !" + e.getMessage()));
            System.exit(1);
        }
        try {
            NfaModel nfaModel = NfaModel.getInstance();
            nfaModel.start();
            LOGGER.info((Object)"nfaModel 9114 start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("NfaModel start failed! Program exit!" + e.getMessage()));
            System.exit(1);
        }
        try {
            PcapModel pcapModel = PcapModel.getInstance();
            pcapModel.start();
            LOGGER.info((Object)"pcapModel 9112 start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("PcapModel start failed ! Program exit !" + e.getMessage()));
            System.exit(1);
        }
        try {
            MonitorCollectorThread monitorCollector = new MonitorCollectorThread();
            monitorThread = new Thread((Runnable)monitorCollector, "monitorCollector");
            monitorThread.setUncaughtExceptionHandler(crashThreadHandler);
            monitorThread.start();
            LOGGER.info((Object)"monitorThread start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("MonitorThread start failed ! Program exit !" + e.getMessage()));
            System.exit(1);
        }
        try {
            SummaryThread summaryThread = new SummaryThread();
            summaryThread.setUncaughtExceptionHandler(crashThreadHandler);
            summaryThread.start();
            LOGGER.info((Object)"summaryThread start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("SummaryThread start failed ! Program exit !" + e.getMessage()));
            System.exit(1);
        }
        try {
            ZipThread zt = new ZipThread();
            zt.setTarget("log");
            zt.setLogBackDir("logback");
            zt.setUncaughtExceptionHandler(crashThreadHandler);
            zt.start();
            LOGGER.info((Object)"ZipThread start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("ZipThread start failed ! Program exit !" + e.getMessage()));
            System.exit(1);
        }
        try {
            MBeanResourceFactory.MEMORY_CONTROL.setUncaughtExceptionHandler(crashThreadHandler);
            MBeanResourceFactory.MEMORY_CONTROL.start();
            LOGGER.info((Object)"MBeanResourceFactory start OK !");
        }
        catch (Exception e) {
            LOGGER.error((Object)("jmx start failed ! Program exit !" + e.getMessage()));
        }
        this.stratUnicomLogThread(crashThreadHandler);
        LOGGER.info((Object)"stratUnicomLogThread start OK !");
        LOGGER.info((Object)"collector start OK !");
    }

    public static void stop(String[] args) {
        LOGGER.info((Object)"Collector service shutdown.");
        Main.systemExit();
    }

    private static void systemExit() {
        System.exit(0);
    }

    private void stratUnicomLogThread(CrashThreadHandler crashThreadHandler) {
        try {
            CleanLogProcessThread processThread = CleanLogProcessThread.getInstance();
            processThread.setUncaughtExceptionHandler(crashThreadHandler);
            if (processThread.isUnicomSocEnable()) {
                processThread.start();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("CleanLogProcessThread start failed ! Program exit !" + e.getMessage()));
        }
    }
}

