/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.init;

import com.hs.atic.collector.biz.event.process.EventTypeProcessor;
import com.hs.atic.collector.biz.monitor.MonitorCollector;
import com.hs.atic.collector.biz.pcap.PcapModel;
import com.hs.atic.collector.manager.agent.resource.MBeanResourceFactory;
import com.hs.atic.collector.transponder.PacketsTransponder;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class UdpManagerThread
extends Thread {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final long THOU = 1000L;
    private int port = 9110;
    private List<EventTypeProcessor> processorList = new ArrayList<EventTypeProcessor>();
    private PacketsTransponder transponder = new PacketsTransponder();

    public UdpManagerThread(int port) {
        this.setName("UDP Receiver Thread " + port);
        this.port = port;
    }

    public void addTypeProcessor(EventTypeProcessor processor) {
        this.processorList.add(processor);
    }

    @Override
    public void run() {
        DatagramSocket socket = null;
        try {
            String collectorIP = System.getProperty("java.rmi.server.hostname");
            if (this.port == 9112) {
                try {
                    LOGGER.error((Object)"pcapThreadInitResource start");
                    PcapModel.getInstance().pcapThreadInitResource();
                    LOGGER.error((Object)"pcapThreadInitResource end");
                }
                catch (Exception e) {
                    LOGGER.error((Object)("PcapBuilder loadPcapTaskFromDb error!" + e.getMessage()));
                }
            }
            try {
                InetAddress iddr = InetAddress.getByName(collectorIP);
                socket = new DatagramSocket(this.port, iddr);
            }
            catch (UnknownHostException e) {
                LOGGER.error((Object)("create socket error for port=" + this.port + ", collectorIP=" + collectorIP));
                socket = new DatagramSocket(this.port);
            }
            socket.setReceiveBufferSize(CommonUtil.getSocketReciveBufferSize());
        }
        catch (SocketException e) {
            LOGGER.fatal((Object)("can't open socket " + this.port + " on local, program exit." + e.getMessage()));
            System.exit(1);
        }
        LOGGER.error((Object)("begin listening on :" + this.port));
        int receiveCount = 0;
        long recentStaticsTime = System.currentTimeMillis();
        int packetMaxLength = CommonUtil.getPacketMaxLength();
        byte[] buf = null;
        DatagramPacket packet = null;
        while (true) {
            try {
                while (true) {
                    buf = new byte[packetMaxLength];
                    packet = new DatagramPacket(buf, buf.length);
                    socket.receive(packet);
                    ++receiveCount;
                    if (System.currentTimeMillis() - recentStaticsTime > 1000L) {
                        if (System.currentTimeMillis() - recentStaticsTime > 10000L) {
                            receiveCount = 0;
                        }
                        String className = Thread.currentThread().getName();
                        LOGGER.info((Object)("className : " + (String)className + " revice log num=" + receiveCount + " per second"));
                        MBeanResourceFactory.UNRESOLVED_BINARY_PACKET.addPacketReceivedInfo(System.currentTimeMillis(), (int)((long)receiveCount * 1000L / (System.currentTimeMillis() - recentStaticsTime)), receiveCount, recentStaticsTime);
                        recentStaticsTime = System.currentTimeMillis();
                        receiveCount = 0;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("recieve 1 packet from " + packet.getAddress() + ":" + this.port));
                    }
                    this.transponder.transmit(packet);
                    if (MonitorCollector.isDiskOk()) {
                        for (EventTypeProcessor typeProcessor : this.processorList) {
                            typeProcessor.processPacket(packet);
                        }
                    }
                    packet = null;
                }
            }
            catch (Exception throwable) {
                LOGGER.error((Object)("throwable: " + throwable.getMessage()));
                continue;
            }
            break;
        }
    }
}

