/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.manager.mbean;

import com.hs.atic.collector.manager.agent.resource.MBeanResourceFactory;
import com.hs.atic.collector.manager.mbean.JVMInfoMBean;

public class JVMInfo
implements JVMInfoMBean {
    @Override
    public String getMaxJVMMemory() {
        return MBeanResourceFactory.CAN_USED_MAX_JVMMEMORY + "M";
    }

    @Override
    public String getUsedJVMMemory() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L + "M";
    }

    @Override
    public String getFreeJVMMemory() {
        return (long)MBeanResourceFactory.CAN_USED_MAX_JVMMEMORY - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L + "M";
    }

    @Override
    public int getThreadCount() {
        return Thread.activeCount();
    }

    @Override
    public String getCalMemory() {
        return this.getMemorySpaceMillis() + "M";
    }

    public int getMemorySpaceMillis() {
        int unresolvedPacketMemory = MBeanResourceFactory.UNRESOLVED_BINARY_PACKET.getUnresolvedMemory();
        int flow70sSpace = MBeanResourceFactory.FLOW_MESSAGE_70SEC.getMemorySpaceMillis();
        int flow5minSpace = MBeanResourceFactory.FLOW_MESSAGE_5MIN.getMemorySpaceMillis();
        int flow1hourSpace = MBeanResourceFactory.FLOW_MESSAGE_1HOUR.getMemorySpaceMillis();
        int abnormalSpace = MBeanResourceFactory.ABNORMAL_FLOW.getMemorySpaceMillis();
        int blacklistSpace = MBeanResourceFactory.BLACKLIST_FLOW.getMemorySpaceMillis();
        int captureSpace = MBeanResourceFactory.PACKET_CAPTURE.getMemorySpaceMillis();
        int baselineSpace = MBeanResourceFactory.BASELINE_INFO.getMemorySpaceMillis();
        int serviceLearningSpace = MBeanResourceFactory.SERVICE_LEARNING_INFO.getMemorySpaceMillis();
        int srcAndContentTopNSpace = MBeanResourceFactory.SRC_AND_CONTENT_TOPN_FLOW.getMemorySpaceMillis();
        int dnsDefendSpace = MBeanResourceFactory.DNS_DEFEND_FLOW.getMemorySpaceMillis();
        int alarmSpace = MBeanResourceFactory.ALARM_MESSAGE.getMemorySpaceMillis();
        int result = unresolvedPacketMemory + flow70sSpace + flow5minSpace + flow1hourSpace + abnormalSpace + blacklistSpace + captureSpace + baselineSpace + serviceLearningSpace + srcAndContentTopNSpace + dnsDefendSpace + alarmSpace;
        return result / 1024;
    }

    public String toString() {
        return "JVMInfo [getFreeJVMMemory()=" + this.getFreeJVMMemory() + ", getMaxJVMMemory()=" + this.getMaxJVMMemory() + ", getMemorySpaceMillis()=" + this.getMemorySpaceMillis() + ", getThreadCount()=" + this.getThreadCount() + ", getUsedJVMMemory()=" + this.getUsedJVMMemory() + "]";
    }
}

