/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.manager.mbean;

import com.hs.atic.collector.biz.CounterBuffer;
import com.hs.atic.collector.biz.event.process.TimeDatagramPacket;
import com.hs.atic.collector.manager.mbean.UnresolvedBinaryPacketMBean;
import java.util.concurrent.ConcurrentLinkedQueue;

public class UnresolvedBinaryPacket
implements UnresolvedBinaryPacketMBean {
    private int packetReceivedRate;
    private long packetReceivedLastTime;
    private ConcurrentLinkedQueue<TimeDatagramPacket> flowQueue;
    private CounterBuffer<?> captureBuffer;
    private int receiveCount;
    private long beginCountTime;

    public ConcurrentLinkedQueue<TimeDatagramPacket> getFlowQueue() {
        return this.flowQueue;
    }

    public void setFlowQueue(ConcurrentLinkedQueue<TimeDatagramPacket> flowQueue) {
        this.flowQueue = flowQueue;
    }

    public CounterBuffer<?> getCaptureBuffer() {
        return this.captureBuffer;
    }

    public void setCaptureBuffer(CounterBuffer<?> captureBuffer) {
        this.captureBuffer = captureBuffer;
    }

    public void addPacketReceivedInfo(long receivedTime, int rate, int count, long recentStaticsTime) {
        this.packetReceivedLastTime = receivedTime;
        this.packetReceivedRate = rate;
        this.receiveCount = count;
        this.beginCountTime = recentStaticsTime;
    }

    public long getPacketReceivedLastTime() {
        return this.packetReceivedLastTime;
    }

    public int getReceiveCount() {
        return this.receiveCount;
    }

    public long getBeginCountTime() {
        return this.beginCountTime;
    }

    @Override
    public int getCapturePacketResolvedThreadCount() {
        return 1;
    }

    @Override
    public String getPacketReceivedRate() {
        if (System.currentTimeMillis() - this.packetReceivedLastTime > 10000L) {
            return "0pps";
        }
        return this.packetReceivedRate + "pps";
    }

    @Override
    public int getUnresolvedCapturePacketCount() {
        return this.captureBuffer.getUnresolvedPacketCount();
    }

    @Override
    public String getUnresolvedCapturePacketMemory() {
        if (this.captureBuffer.getUnresolvedPacketMemory() > 0x500000L) {
            return this.captureBuffer.getUnresolvedPacketMemory() / 1024L / 1024L + "M";
        }
        return this.captureBuffer.getUnresolvedPacketMemory() / 1024L + "KB";
    }

    @Override
    public int getUnresolvedFlowPacketCount() {
        int retValue = 0;
        if (this.flowQueue != null) {
            retValue = this.flowQueue.size();
        }
        return retValue;
    }

    @Override
    public String getUnresolvedFlowPacketMemory() {
        String retValue = "0KB";
        return retValue;
    }

    @Override
    public String getFlowPacketResolvedRate() {
        String retValue = "0pps";
        return retValue;
    }

    @Override
    public String getCapturePacketResolvedRate() {
        return this.captureBuffer.getPacketResolvedRate() + "pps";
    }

    public int getUnresolvedMemory() {
        return (int)(this.captureBuffer.getUnresolvedPacketMemory() / 1024L);
    }

    public String toString() {
        return "UnresolvedBinaryPacket [getCapturePacketResolvedRate()=" + this.getCapturePacketResolvedRate() + ", getCapturePacketResolvedThreadCount()=" + this.getCapturePacketResolvedThreadCount() + ", getFlowPacketResolvedRate()=" + this.getFlowPacketResolvedRate() + ", getPacketReceivedRate()=" + this.getPacketReceivedRate() + ", getUnresolvedCapturePacketCount()=" + this.getUnresolvedCapturePacketCount() + ", getUnresolvedCapturePacketMemory()=" + this.getUnresolvedCapturePacketMemory() + ", getUnresolvedFlowPacketCount()=" + this.getUnresolvedFlowPacketCount() + ", getUnresolvedFlowPacketMemory()=" + this.getUnresolvedFlowPacketMemory() + ", getUnresolvedMemory()=" + this.getUnresolvedMemory() + "]";
    }
}

