/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.entity.alarm.IpFlowInfo;
import com.hs.atic.collector.entity.alarm.IpInfoKey;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.sdk.bis.form.BlackholeNpForm;
import com.hs.atic.sdk.bis.form.ConfigBlackholeNpForm;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class BlackHoleNpCommandUtil {
    private static final Logger LOGGER = LogManager.getInstance().getRMILog();
    private static final String BLACK_HOLE_NP_TALBE_NAME = "atic_blackhole_np_config";
    private static final String UPDATE_BLACK_HOLE_NP_SQL = "UPDATE atic_blackhole_np_config SET time_long = ?, black_hole_threshold = ? WHERE np_ip = ?";
    private static final String INSERT_BLACK_HOLE_NP_SQL = "insert into atic_blackhole_np_config(np_ip,time_long,black_hole_threshold) values (?,?,?)";
    private static final String DELETE_BLACK_HOLE_NP_BY_ID = "delete from atic_blackhole_np_config where np_ip in(?)";
    private static final String DELETE_ALL_BLACK_HOLE_NP = "delete from atic_blackhole_np_config";
    private static final String QUERY_BLACK_HOLE_NP_BY_ID = "select np_ip, time_long, black_hole_threshold from atic_blackhole_np_config where np_ip = ?";
    private static BlackHoleNpCommandUtil instance = null;
    private Map<String, ConfigBlackholeNpForm> commandFormMap = new HashMap<String, ConfigBlackholeNpForm>();

    private BlackHoleNpCommandUtil() {
        if (this.commandFormMap.isEmpty()) {
            this.commandFormMap = this.getRuleInDatabase();
            LOGGER.info((Object)("Init commandFormMap, get from db, commandFormMap=" + this.commandFormMap.toString()));
        }
    }

    public static BlackHoleNpCommandUtil getInstance() {
        if (null == instance) {
            instance = new BlackHoleNpCommandUtil();
        }
        return instance;
    }

    public ConfigBlackholeNpForm decideSeverity(IpInfoKey ipInfoKey, IpFlowInfo ipFlowInfo) {
        ConfigBlackholeNpForm npForm = null;
        String zoneIp = ipInfoKey.getZoneIp();
        if (zoneIp != null) {
            npForm = this.commandFormMap.get(zoneIp);
            if (npForm == null) {
                return null;
            }
            long blackHoleNpKbps = (long)npForm.getBlackholeThreshold().intValue() * 1024L;
            if (ipFlowInfo != null && ipFlowInfo.getCurrInKbps() >= blackHoleNpKbps) {
                LOGGER.info((Object)("ipFlowInfo.getCurrInKbps(): " + ipFlowInfo.getCurrInKbps() + ", blackHoleNpKbps:" + blackHoleNpKbps));
                return npForm;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAllConfigBlackholeNpData(List<ConfigBlackholeNpForm> configBlackholeNpFormList) {
        if (null == configBlackholeNpFormList || configBlackholeNpFormList.isEmpty()) {
            LOGGER.error((Object)"Input configBlackholeNpFormList is empty");
            return false;
        }
        Connection conn = DBConnPool.getConnection();
        PreparedStatement psDelete = null;
        PreparedStatement psInstert = null;
        if (conn == null) {
            LOGGER.error((Object)"DBConnPool.getConnection() retrun null.");
            return false;
        }
        try {
            conn.setAutoCommit(false);
            psDelete = conn.prepareStatement(DELETE_ALL_BLACK_HOLE_NP);
            psDelete.execute();
            psInstert = conn.prepareStatement(INSERT_BLACK_HOLE_NP_SQL);
            for (ConfigBlackholeNpForm configBlackholeNpForm : configBlackholeNpFormList) {
                BlackHoleNpCommandUtil.addConfigBlackholeNpThreadPrepared(psInstert, configBlackholeNpForm);
            }
            psInstert.executeBatch();
            conn.commit();
            this.closePreparedStatement(psDelete);
            this.closePreparedStatement(psInstert);
            this.closeConnection(conn);
        }
        catch (SQLException e) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e2) {
                    LOGGER.error((Object)"rollback error");
                }
                LOGGER.error((Object)"save configBlackholeNpForm data error");
                boolean e2 = false;
                this.closePreparedStatement(psDelete);
                this.closePreparedStatement(psInstert);
                this.closeConnection(conn);
                return e2;
            }
            catch (Throwable throwable) {
                this.closePreparedStatement(psDelete);
                this.closePreparedStatement(psInstert);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        this.commandFormMap.clear();
        for (ConfigBlackholeNpForm npForm : configBlackholeNpFormList) {
            String npIp = npForm.getNpIp().split("/")[0];
            this.commandFormMap.put(npIp, npForm);
        }
        LOGGER.info((Object)"save all black hole np data success!");
        return true;
    }

    private static int addConfigBlackholeNpThreadPrepared(PreparedStatement ps, ConfigBlackholeNpForm npForm) throws SQLException {
        int paramIndex = 1;
        ps.setString(paramIndex++, npForm.getNpIp());
        ps.setInt(paramIndex++, npForm.getTimeLong());
        ps.setLong(paramIndex++, npForm.getBlackholeThreshold().intValue());
        ps.addBatch();
        return paramIndex;
    }

    public boolean saveFaultSeverityRule(ConfigBlackholeNpForm npForm) {
        if (null == npForm) {
            LOGGER.info((Object)"save black hole np is null.");
            return false;
        }
        if (!this.saveInDatabase(npForm)) {
            return false;
        }
        String ip = npForm.getNpIp().split("/")[0];
        this.commandFormMap.put(ip, npForm);
        LOGGER.info((Object)"save black hole np rule success!");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveInDatabase(ConfigBlackholeNpForm npForm) {
        ConfigBlackholeNpForm isNpIpForm = this.getBlackHoleNpFormByNpIp(npForm.getNpIp());
        Connection conn = DBConnPool.getConnection();
        PreparedStatement ps = null;
        if (conn == null) {
            LOGGER.error((Object)"DBConnPool.getConnection() retrun null.");
            return false;
        }
        try {
            conn.setAutoCommit(false);
            if (isNpIpForm == null) {
                LOGGER.info((Object)("create a new black hole Np data: " + npForm.toString()));
                ps = conn.prepareStatement(INSERT_BLACK_HOLE_NP_SQL);
                int paramIndex = 1;
                ps.setString(paramIndex++, npForm.getNpIp());
                ps.setInt(paramIndex++, npForm.getTimeLong());
                ps.setLong(paramIndex, npForm.getBlackholeThreshold().intValue());
                ps.execute();
                conn.commit();
            } else {
                LOGGER.info((Object)("update rule: " + npForm.toString()));
                ps = conn.prepareStatement(UPDATE_BLACK_HOLE_NP_SQL);
                int paramIndex = 1;
                ps.setInt(paramIndex++, npForm.getTimeLong());
                ps.setLong(paramIndex++, npForm.getBlackholeThreshold().intValue());
                ps.setString(paramIndex++, npForm.getNpIp());
                ps.execute();
                conn.commit();
            }
            LOGGER.info((Object)"update black hole np OK!!");
            this.closePreparedStatement(ps);
            this.closeConnection(conn);
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException e2) {
                LOGGER.error((Object)"rollback error");
            }
            LOGGER.error((Object)"save black hole np error");
            boolean bl = false;
            return bl;
        }
        finally {
            this.closePreparedStatement(ps);
            this.closeConnection(conn);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ConfigBlackholeNpForm> getRuleInDatabase() {
        HashMap<String, ConfigBlackholeNpForm> configFormMap = new HashMap<String, ConfigBlackholeNpForm>();
        ConfigBlackholeNpForm npForm = null;
        Connection conn = DBConnPool.getConnection();
        PreparedStatement st = null;
        ResultSet rs = null;
        String sql = "SELECT id,np_ip,time_long,black_hole_threshold FROM atic_blackhole_np_config";
        try {
            st = conn.prepareStatement(sql);
            rs = st.executeQuery();
            int index = 0;
            while (rs.next()) {
                index = 1;
                npForm = new ConfigBlackholeNpForm();
                npForm.setId(rs.getLong(index++));
                npForm.setNpIp(rs.getString(index++));
                npForm.setTimeLong(rs.getInt(index++));
                npForm.setBlackholeThreshold(rs.getInt(index++));
                String npIp = npForm.getNpIp().split("/")[0];
                configFormMap.put(npIp, npForm);
            }
            this.closeResultSet(rs);
            this.closePreparedStatement(st);
            this.closeConnection(conn);
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"getRuleInDatabase SQLException");
                this.closeResultSet(rs);
                this.closePreparedStatement(st);
                this.closeConnection(conn);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closePreparedStatement(st);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        return configFormMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigBlackholeNpForm getBlackHoleNpFormByNpIp(String npIp) {
        ConfigBlackholeNpForm npForm = null;
        Connection conn = DBConnPool.getConnection();
        PreparedStatement st = null;
        ResultSet rs = null;
        String sql = QUERY_BLACK_HOLE_NP_BY_ID;
        try {
            st = conn.prepareStatement(sql);
            st.setString(1, npIp);
            rs = st.executeQuery();
            int index = 0;
            while (rs.next()) {
                index = 1;
                npForm = new ConfigBlackholeNpForm();
                npForm.setNpIp(rs.getString(index++));
                npForm.setTimeLong(rs.getInt(index++));
                npForm.setBlackholeThreshold(rs.getInt(index++));
            }
            this.closeResultSet(rs);
            this.closePreparedStatement(st);
            this.closeConnection(conn);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"getBlackHoleNpFormByNpIp SQLException");
        }
        finally {
            this.closeResultSet(rs);
            this.closePreparedStatement(st);
            this.closeConnection(conn);
        }
        return npForm;
    }

    private void closeResultSet(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"when resultSet close is error");
            }
        }
    }

    private void closeConnection(Connection conn) {
        try {
            if (null != conn) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"db connection close faile");
        }
    }

    private void closePreparedStatement(PreparedStatement ps) {
        try {
            if (null != ps) {
                ps.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"db statement close faile");
        }
    }

    public boolean deleteBlackHoleNpByNpIp(String npIp) {
        LOGGER.info((Object)("delete black hole NP data by npIp=" + npIp));
        boolean isDelete = false;
        try {
            ArrayList<String> npIpList = new ArrayList<String>();
            npIpList.add(npIp);
            isDelete = this.deleteBlackHoleNpByNpIps(npIpList);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)("delete fail!" + e.getMessage()));
        }
        return isDelete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteBlackHoleNpByNpIps(List<String> npIpList) throws RemoteException {
        if (null == npIpList || npIpList.isEmpty()) {
            LOGGER.error((Object)"input NpIpList is empty");
            return false;
        }
        Connection conn = DBConnPool.getConnection();
        PreparedStatement psDelete = null;
        if (conn == null) {
            LOGGER.error((Object)"DBConnPool.getConnection() retrun null.");
            return false;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < npIpList.size(); ++i) {
            sb.append(npIpList.get(i));
            if (i >= npIpList.size() - 1) continue;
            sb.append(',');
        }
        try {
            psDelete = conn.prepareStatement(DELETE_BLACK_HOLE_NP_BY_ID);
            psDelete.setString(1, sb.toString());
            psDelete.execute();
            for (String npIp : npIpList) {
                this.commandFormMap.remove(npIp.split("/")[0]);
            }
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException e2) {
                LOGGER.error((Object)"rollback error");
            }
            LOGGER.error((Object)("deleteSeverityRules error.zoneIdList=" + npIpList.toString()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.closePreparedStatement(psDelete);
            this.closeConnection(conn);
        }
        return true;
    }

    public boolean bathSaveOrUpate(List<BlackholeNpForm> blackholeNpForms) {
        LOGGER.info((Object)("bath save or updata black hole NP blackholeNpForms:" + blackholeNpForms.toString()));
        boolean isBathSave = true;
        ConfigBlackholeNpForm npForm = null;
        for (BlackholeNpForm blackholeNpForm : blackholeNpForms) {
            npForm = new ConfigBlackholeNpForm();
            npForm.setNpIp(blackholeNpForm.getNpIp());
            npForm.setTimeLong(blackholeNpForm.getTimeLong());
            npForm.setBlackholeThreshold(blackholeNpForm.getBlackholeThreshold());
            if (this.saveFaultSeverityRule(npForm)) continue;
            isBathSave = false;
            break;
        }
        return isBathSave;
    }
}

