/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.biz.event.nfa.NfaAttackSrcFlow;
import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.db.monitor.DBSysConf;
import com.hs.atic.collector.entity.BizIpEntry;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.IPUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.ClientSocketFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public final class CommonUtil {
    public static final int HOUR = 3600000;
    public static final int CAPACITY_RATE = 1024;
    public static final int TIME_RATE = 1000;
    public static final int EXCEPTION_EVENT_TIMEOUT = 5;
    public static final int PORTS_DISPLAY_MAX = 5;
    public static final String EMPTY_STRING = "  ";
    public static final String EMPTY_ZORE_STRING = "0";
    public static final String SEPARATOR = ",";
    public static final String SEMICOLON = ";";
    private static final int DEFAULT_BIZ_PERIOD = 300000;
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final int DEFAULT_FLOW_PERIOD = 300000;
    private static final int DEFAULT_DNS_PERIOD = 300000;
    private static final int DEFAULT_ATIC_FLOW_MAX_NUM = 99999999;
    private static int curAticFlowMaxNum = 99999999;
    private static final int DEFAULT_PACKET_MAX_LENGTH = 2049;
    private static int packetMaxLength = 2049;
    private static final int DEFAULT_SOCKET_BUFFER_SIZE = 0x3100000;
    private static int socketReciveBufferSize = 0x3100000;

    private CommonUtil() {
    }

    public static String getByteArrayStr(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("receive packet data are " + LogManager.NEXT_LINE);
        buffer.append("-------------------------");
        buffer.append(LogManager.NEXT_LINE);
        for (int i = 0; i < data.length; ++i) {
            buffer.append("0x");
            Formatter formatter = new Formatter();
            Locale defloc = Locale.getDefault();
            if (data[i] < 16 && data[i] >= 0) {
                buffer.append('0');
            }
            buffer.append(formatter.format("%x", data[i]).toString().toUpperCase(defloc));
            buffer.append(',');
            if (i % 8 == 7) {
                buffer.append(LogManager.NEXT_LINE);
                continue;
            }
            if (i % 4 != 3) continue;
            buffer.append(' ');
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIpString(Set<String> ips, int columnWidth) {
        HashSet<String> ipCopy = new HashSet<String>();
        try {
            Set<String> set = ips;
            synchronized (set) {
                ipCopy.addAll(ips);
            }
            StringBuffer attackers = new StringBuffer();
            if (ipCopy.isEmpty()) {
                attackers.append(EMPTY_STRING);
            } else {
                Iterator itor = ipCopy.iterator();
                while (itor.hasNext()) {
                    String ipStr = (String)itor.next();
                    if (CommonUtil.overLength(attackers.toString() + ipStr + SEPARATOR, columnWidth)) break;
                    attackers.append(ipStr);
                    if (!itor.hasNext()) continue;
                    attackers.append(SEPARATOR);
                }
            }
            String result = attackers.toString();
            if (!"".equals(result) && SEPARATOR.equals(result.substring(result.length() - 1))) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error((Object)("getIpString error !!" + e.getMessage()));
            return EMPTY_STRING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAttackSrcIpAndFlowString(Set<String> attackerList, List<NfaAttackSrcFlow> list) {
        ArrayList<String> returnString = new ArrayList<String>();
        ArrayList<NfaAttackSrcFlow> listCopy = new ArrayList<NfaAttackSrcFlow>();
        try {
            List<NfaAttackSrcFlow> list2 = list;
            synchronized (list2) {
                listCopy.addAll(list);
            }
            StringBuffer attackers = new StringBuffer();
            StringBuffer attackerFlow = new StringBuffer();
            if (listCopy.isEmpty()) {
                if (null != attackerList && !attackerList.isEmpty()) {
                    attackers.append(CommonUtil.getIpString(attackerList, 5000));
                } else {
                    attackers.append(EMPTY_STRING);
                }
                attackerFlow.append(EMPTY_STRING);
                returnString.add(attackers.toString());
                returnString.add(attackerFlow.toString());
            } else {
                String returnAttackers = "";
                String returnAttackerFlow = "";
                for (NfaAttackSrcFlow flow : listCopy) {
                    String ipStr = flow.getAttackSrcIp();
                    attackers.append(ipStr).append(SEPARATOR);
                    attackerFlow.append(ipStr).append(SEPARATOR).append(flow.getPps()).append(SEPARATOR).append(flow.getKbps()).append(SEMICOLON);
                }
                returnAttackers = attackers.substring(0, attackers.length() - 1);
                returnAttackerFlow = attackerFlow.substring(0, attackerFlow.length() - 1);
                returnString.add(returnAttackers);
                returnString.add(returnAttackerFlow);
            }
            return returnString;
        }
        catch (Exception e) {
            LOGGER.error((Object)("getIpString error !!" + e.getMessage()));
            return returnString;
        }
    }

    public static void bizIpEntry2Ip(Set<BizIpEntry> bizIpSet, Set<String> ipSet) {
        if (bizIpSet != null && ipSet != null) {
            ipSet.clear();
            for (BizIpEntry entry : bizIpSet) {
                ipSet.add(entry.getZoneIp());
            }
        }
    }

    public static Set<String> transIpString2Set(String ipList) {
        if (null == ipList) {
            return new HashSet<String>();
        }
        String[] array = ipList.split(SEPARATOR);
        HashSet<String> ips = new HashSet<String>();
        for (String ip : array) {
            if (!IPUtil.isIpv4(ip)) continue;
            ips.add(ip);
        }
        return ips;
    }

    public static String tansIpSet2String(Set<String> ips) {
        StringBuffer attackers = new StringBuffer();
        if (ips.isEmpty()) {
            attackers.append(EMPTY_STRING);
        } else {
            Iterator<String> itor = ips.iterator();
            while (itor.hasNext()) {
                String ipStr = itor.next();
                attackers.append(ipStr);
                if (!itor.hasNext()) continue;
                attackers.append(SEPARATOR);
            }
        }
        return attackers.toString();
    }

    public static String tansPortsSet2String(Set<Integer> portSet) {
        StringBuffer ports = new StringBuffer();
        if (portSet.isEmpty()) {
            ports.append(EMPTY_ZORE_STRING);
        } else {
            Integer ipStr = null;
            Iterator<Integer> itor = portSet.iterator();
            while (itor.hasNext()) {
                ipStr = itor.next();
                ports.append(ipStr);
                if (!itor.hasNext()) continue;
                ports.append(SEPARATOR);
            }
        }
        return ports.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties openPropertyFile(String relativeFileName) {
        FileInputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = new FileInputStream(relativeFileName);
            properties.load(inputStream);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"find the file fail");
        }
        catch (IOException e) {
            LOGGER.error((Object)"read content of file fail");
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"when close file ,error happen.I can do nothing");
                }
            }
        }
        return properties;
    }

    public static boolean overLength(String value, int length) {
        return value.length() > length;
    }

    public static Object retreiveAticRmiService(String serviceName) {
        DBSysConf dbSysConf = new DBSysConf();
        String ip = dbSysConf.querySysValue("server_ip");
        int aticRmiPort = 11098;
        try {
            String port = EventUtil.getEventConfigProperty("AticRmiPort");
            aticRmiPort = Integer.parseInt(port);
        }
        catch (RuntimeException e) {
            LogManager.getInstance().getSystemLog().error((Object)"parse AticRmiPort error");
        }
        try {
            ClientSocketFactory csf = new ClientSocketFactory(true);
            Registry registry = LocateRegistry.getRegistry(ip, aticRmiPort, csf);
            LogManager.getInstance().getSystemLog().info((Object)("Getting Rmi Service " + serviceName + ". the atic Rmi service ip=" + ip + ", port=" + aticRmiPort));
            return registry.lookup(serviceName);
        }
        catch (Exception e) {
            LogManager.getInstance().getSystemLog().error((Object)("Get Rmi Service " + serviceName + " error. port : " + aticRmiPort + " " + e.getMessage()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getTables(String path) {
        ArrayList<String> tableList = new ArrayList<String>();
        try {
            FileInputStream in = new FileInputStream(path);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "utf-8"));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().length() <= 0 || line.trim().startsWith("#")) continue;
                    tableList.add(line);
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"reader readLine Exception");
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"reader close Exception");
                }
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"in close Exception");
                }
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"getTables Exception");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("getTables Exception!" + e.getMessage()));
        }
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTableConlum(String path) {
        FileInputStream in = null;
        BufferedReader reader = null;
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            in = new FileInputStream(path);
            reader = new BufferedReader(new InputStreamReader((InputStream)in, "utf-8"));
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() <= 0 || line.trim().startsWith("#")) continue;
                buffer.append(line);
            }
            line = buffer.toString();
            return line;
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)("getTableConlum failed error :" + e.getMessage()));
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"getTableConlum failed error");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("getTableConlum failed error :" + e.getMessage()));
        }
        catch (IOException e) {
            LOGGER.error((Object)"getTableConlum failed error :");
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"getTableConlum close BufferedReader failed error :");
            }
            try {
                if (null != in) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"getTableConlum close InputStream failed error :");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(List<String> sqlList) {
        Connection conn;
        if (!sqlList.isEmpty() && (conn = DBConnPool.getConnection()) != null) {
            try {
                conn.setAutoCommit(false);
                for (String excutesql : sqlList) {
                    CommonUtil.doExecuteSql(conn, excutesql);
                }
                conn.commit();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"excute sql error.");
            }
            finally {
                CommonUtil.free(conn, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doExecuteSql(Connection conn, String excutesql) {
        PreparedStatement stmt = null;
        try {
            StringBuffer temSql = new StringBuffer(excutesql);
            temSql.append("");
            stmt = conn.prepareStatement(temSql.toString());
            stmt.execute();
            CommonUtil.free(null, stmt);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"excute sql error");
        }
        finally {
            CommonUtil.free(null, stmt);
        }
    }

    public static void free(Connection conn, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"free stmt.close() error");
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"free conn.close() error");
        }
    }

    public static void free(Connection conn, Statement stmt, ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"rs.close() error SQLException");
            }
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"free stmt.close() error");
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"free conn.close() error");
        }
    }

    public static long time4TodayBeginning() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTimeInMillis() / 1000L;
    }

    public static String transferlong2String(Long time) {
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (time == null || 0L == time) {
            return "";
        }
        Date d = new Date(time);
        return formate.format(d);
    }

    public static String convertIpFromLong2Str(long address) {
        byte[] values = new byte[]{(byte)(address >>> 24 & 0xFFL), (byte)(address >>> 16 & 0xFFL), (byte)(address >>> 8 & 0xFFL), (byte)(address >>> 0 & 0xFFL)};
        return (values[0] & 0xFF) + "." + (values[1] & 0xFF) + "." + (values[2] & 0xFF) + "." + (values[3] & 0xFF);
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equals(str);
    }

    public static void setIpToFormate(DataStatCondition cds) {
        if (IpTransformer.checkIpInvaild(cds.getDeviceIp())) {
            cds.setDeviceIp(IpTransformer.formatIpAddress(cds.getDeviceIp()));
        }
        if (IpTransformer.checkIpInvaild(cds.getZoneIp())) {
            cds.setZoneIp(IpTransformer.formatIpAddress(cds.getZoneIp()));
        }
        if (IpTransformer.checkIpInvaild(cds.getSouceIp())) {
            cds.setSouceIp(IpTransformer.formatIpAddress(cds.getSouceIp()));
        }
        if (IpTransformer.checkIpInvaild(cds.getDescIp())) {
            cds.setDescIp(IpTransformer.formatIpAddress(cds.getDescIp()));
        }
    }

    public static List<Object> getDeviceIpLocationSql(DataStatCondition cds, StringBuffer condSql) {
        ArrayList<Object> list = new ArrayList<Object>();
        condSql.append(" a.DEVICE_IP in ( ");
        if (cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            condSql.append('?');
            list.add(cds.getDeviceIp());
        } else {
            int num = 0;
            for (String deviceIp : cds.getDeviceIpList()) {
                cds.setDeviceIp(deviceIp);
                CommonUtil.setIpToFormate(cds);
                if (0 == num) {
                    condSql.append('?');
                    list.add(cds.getDeviceIp());
                } else {
                    condSql.append(" , ? ");
                    list.add(cds.getDeviceIp());
                }
                ++num;
            }
        }
        condSql.append(')');
        return list;
    }

    public static List<Object> getDeviceIpSql(DataStatCondition cds, StringBuffer condSql) {
        ArrayList<Object> list = new ArrayList<Object>();
        Long deviceId = cds.getDeviceId();
        List<String> deviceIpList = cds.getDeviceIpList();
        condSql.append(" DEVICE_IP in ( ");
        if (deviceId != null && cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            condSql.append('?');
            list.add(cds.getDeviceIp());
        } else {
            if (deviceIpList.isEmpty()) {
                return list;
            }
            int num = 0;
            for (String deviceIp : cds.getDeviceIpList()) {
                cds.setDeviceIp(deviceIp);
                CommonUtil.setIpToFormate(cds);
                if (0 == num) {
                    condSql.append('?');
                    list.add(cds.getDeviceIp());
                } else {
                    condSql.append(" , ? ");
                    list.add(cds.getDeviceIp());
                }
                ++num;
            }
        }
        condSql.append(')');
        return list;
    }

    public static int getFlowPeroid() {
        int period = 300000;
        try {
            period = Integer.parseInt(EventUtil.getEventConfigProperty("FlowThreadPeriod"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"read config error content error,key is FlowThreadPeriod");
        }
        return period;
    }

    public static int getDnsPeroid() {
        int period = 300000;
        try {
            period = Integer.parseInt(EventUtil.getEventConfigProperty("DnsThreadPeriod"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"read config error content error,key is DnsThreadPeriod");
        }
        return period;
    }

    public static int getBizPeroid() {
        int period = 300000;
        try {
            period = Integer.parseInt(EventUtil.getEventConfigProperty("BizThreadPeriod"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"read config error content error,key is BizThreadPeriod");
        }
        return period;
    }

    public static void freeDbResource(Connection con, PreparedStatement stmt) {
        try {
            if (null != stmt) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        try {
            if (null != con) {
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close connection error");
        }
    }

    public static int getAticFlowMaxNum() {
        try {
            if (curAticFlowMaxNum == 99999999) {
                curAticFlowMaxNum = Integer.parseInt(EventUtil.getEventConfigProperty("AticFlowMaxNum"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"read config error content error,key is FlowThreadPeriod");
            curAticFlowMaxNum = 99999999;
        }
        return curAticFlowMaxNum;
    }

    public static int getPacketMaxLength() {
        try {
            if (packetMaxLength == 2049) {
                packetMaxLength = Integer.parseInt(EventUtil.getEventConfigProperty("packetMaxLength"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"read config error content error,key is packetMaxLength");
            packetMaxLength = 99999999;
        }
        return packetMaxLength;
    }

    public static int getSocketReciveBufferSize() {
        try {
            if (socketReciveBufferSize == 0x3100000) {
                socketReciveBufferSize = Integer.parseInt(EventUtil.getEventConfigProperty("socketReciveBufferSize"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"read config error content error, key is socketReciveBufferSize");
            socketReciveBufferSize = 0x3100000;
        }
        return socketReciveBufferSize;
    }

    public static String transDeviceType(int deviceType) {
        if (0 == deviceType) {
            return "clean";
        }
        return "detect";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean modifyPropertyValue(String filePath, String key, String value) {
        FileInputStream fiStream = null;
        InputStreamReader inReader = null;
        BufferedReader br = null;
        FileOutputStream foStream = null;
        OutputStreamWriter outReader = null;
        BufferedWriter bw = null;
        StringBuffer sbf = new StringBuffer();
        try {
            fiStream = new FileInputStream(filePath);
            inReader = new InputStreamReader((InputStream)fiStream, "gbk");
            br = new BufferedReader(inReader);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.contains(key)) {
                    line = key + " = " + value;
                }
                sbf.append(line);
                sbf.append(System.getProperty("line.separator"));
            }
            foStream = new FileOutputStream(filePath, false);
            outReader = new OutputStreamWriter((OutputStream)foStream, "gbk");
            bw = new BufferedWriter(outReader);
            bw.write(sbf.toString());
        }
        catch (IOException e) {
            boolean bl;
            try {
                LOGGER.error((Object)"write error");
                bl = false;
            }
            catch (Throwable throwable) {
                CommonUtil.closeBufferedReader(br);
                CommonUtil.closeInputStreamReader(inReader);
                CommonUtil.closeFileInputStream(fiStream);
                CommonUtil.closeBufferedWriter(bw);
                CommonUtil.closeOutputStreamWriter(outReader);
                CommonUtil.closeFileOutputStream(foStream);
                throw throwable;
            }
            CommonUtil.closeBufferedReader(br);
            CommonUtil.closeInputStreamReader(inReader);
            CommonUtil.closeFileInputStream(fiStream);
            CommonUtil.closeBufferedWriter(bw);
            CommonUtil.closeOutputStreamWriter(outReader);
            CommonUtil.closeFileOutputStream(foStream);
            return bl;
        }
        CommonUtil.closeBufferedReader(br);
        CommonUtil.closeInputStreamReader(inReader);
        CommonUtil.closeFileInputStream(fiStream);
        CommonUtil.closeBufferedWriter(bw);
        CommonUtil.closeOutputStreamWriter(outReader);
        CommonUtil.closeFileOutputStream(foStream);
        return true;
    }

    private static void closeBufferedReader(BufferedReader br) {
        if (null != br) {
            try {
                br.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"when close br error happen.I can do nothing");
            }
        }
    }

    private static void closeInputStreamReader(InputStreamReader inReader) {
        if (null != inReader) {
            try {
                inReader.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"when close inReader error happen.I can do nothing");
            }
        }
    }

    private static void closeFileInputStream(FileInputStream fiStream) {
        if (null != fiStream) {
            try {
                fiStream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"when close fileReader error happen.I can do nothing");
            }
        }
    }

    private static void closeBufferedWriter(BufferedWriter bw) {
        if (null != bw) {
            try {
                bw.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"when close bw error happen.I can do nothing");
            }
        }
    }

    private static void closeOutputStreamWriter(OutputStreamWriter outReader) {
        if (null != outReader) {
            try {
                outReader.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"when close outReader error happen.I can do nothing");
            }
        }
    }

    private static void closeFileOutputStream(FileOutputStream foStream) {
        if (null != foStream) {
            try {
                foStream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"when close foStream error happen.I can do nothing");
            }
        }
    }

    public static Properties loadCollectorCertInfoProperties() {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            String path = AticInstallUtil.getInstance().getCollectorInstallPath() + "/cert/collectorCertInfo.properties";
            inputStream = new FileInputStream(path);
            properties.load(inputStream);
        }
        catch (IOException e) {
            LOGGER.error((Object)"load collector cert info error");
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)("load collector cert info error!" + e.getMessage()));
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close inputStream error");
                }
            }
        }
        return properties;
    }

    public static String queryDestinationPort(String destinationPort) {
        if (CommonUtil.isNull(destinationPort) || EMPTY_ZORE_STRING.equals(destinationPort)) {
            return "--";
        }
        Set<String> portSet = CommonUtil.transString2Set(destinationPort);
        String[] ports = new String[portSet.size()];
        portSet.toArray(ports);
        int len = ports.length >= 5 ? 5 : ports.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(ports[i]).append(SEPARATOR);
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static Set<String> transString2Set(String str) {
        String[] array;
        HashSet<String> strs = new HashSet<String>();
        if (null == str) {
            return strs;
        }
        for (String s : array = str.split(SEPARATOR)) {
            if (EMPTY_ZORE_STRING.equals(s)) continue;
            strs.add(s);
        }
        return strs;
    }

    public static String getDirectionStr(int direction) {
        if (2 == direction) {
            return "outbound";
        }
        return "inbound";
    }

    public static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replaceAll("\t|\r|\n", "");
        return message;
    }
}

