/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.biz.pcap.AESDecryptorFactory;
import com.hs.atic.collector.entity.Collector;
import com.hs.atic.collector.entity.monitor.DeviceObj;
import com.hs.atic.collector.util.LogManager;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public final class HmacUtil {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final ThreadLocal<Map<String, Mac>> DEV_MAC_MAP = new ThreadLocal();
    private static final ThreadLocal<Map<String, Long>> UPDATE_TIME_MAP = new ThreadLocal();
    private static HmacUtil instance = new HmacUtil();
    private Map<String, Long> deviceModifyTimeMap = new ConcurrentHashMap<String, Long>();

    private HmacUtil() {
    }

    public static HmacUtil getInstance() {
        return instance;
    }

    public void modifyDeviceMac(DeviceObj device) {
        if (null == device) {
            LOGGER.error((Object)"input device is null");
            return;
        }
        String logIp = device.getLogIp();
        if (1 == device.getEncryptType()) {
            this.deviceModifyTimeMap.put(logIp, System.currentTimeMillis());
        }
    }

    public static Map<String, Long> getDeviceUpdateTimeMap() {
        Map<String, Long> map = UPDATE_TIME_MAP.get();
        if (map == null) {
            try {
                map = new HashMap<String, Long>();
                UPDATE_TIME_MAP.set(map);
            }
            catch (Exception e) {
                map = null;
                LOGGER.error((Object)("getThreadLocalMap error:" + e.getMessage()));
            }
        }
        return map;
    }

    private static Map<String, Mac> getThreadLocalMap() {
        Map<String, Mac> hmap = DEV_MAC_MAP.get();
        if (hmap == null) {
            try {
                hmap = new HashMap<String, Mac>();
                DEV_MAC_MAP.set(hmap);
            }
            catch (Exception e) {
                hmap = null;
                LOGGER.error((Object)("getThreadLocalMap error:" + e.getMessage()));
            }
        }
        return hmap;
    }

    private Mac getHmac(StringBuffer logPwd) {
        Charset asciiCs = Charset.forName("US-ASCII");
        Mac shaMac = null;
        try {
            shaMac = Mac.getInstance("HmacSHA256");
            if (shaMac != null) {
                SecretKeySpec secretKey = new SecretKeySpec(asciiCs.encode(logPwd.toString()).array(), "HmacSHA256");
                shaMac.init(secretKey);
            }
        }
        catch (InvalidKeyException e) {
            shaMac = null;
            LOGGER.error((Object)("getHmac InvalidKeyException error:" + e.getMessage()));
        }
        catch (Exception e) {
            shaMac = null;
            LOGGER.error((Object)("getHmac Exception error:" + e.getMessage()));
        }
        return shaMac;
    }

    private Mac getMacByIp(String logIp) {
        Mac shaMAC = null;
        DeviceObj device = Collector.getInstance().getDeviceByIp(logIp);
        if (device != null) {
            StringBuffer key = new StringBuffer();
            key.append(device.getLogPwd());
            if (key.length() != 64) {
                LOGGER.error((Object)("the log mac key is error of device:" + logIp));
                return null;
            }
            StringBuffer macKey = new StringBuffer();
            macKey.append(key.substring(32, 64));
            shaMAC = this.getHmac(macKey);
        }
        return shaMAC;
    }

    private void checkRemoveMacAndMap(String logIp) {
        Long mapModifyTime = this.deviceModifyTimeMap.get(logIp);
        if (mapModifyTime != null) {
            long updateTime = 0L;
            long modifyTime = mapModifyTime;
            Map<String, Long> mapUpdateTimeMap = HmacUtil.getDeviceUpdateTimeMap();
            Long mapUpdateTime = mapUpdateTimeMap.get(logIp);
            if (mapUpdateTime != null) {
                updateTime = mapUpdateTime;
            }
            if (modifyTime > updateTime) {
                Map<String, Mac> macMap = HmacUtil.getThreadLocalMap();
                macMap.remove(logIp);
                mapUpdateTimeMap.put(logIp, System.currentTimeMillis());
            }
        }
    }

    public boolean checkHmac(String logIp, byte[] logData, byte[] macData) {
        Map<String, Mac> macIpMap = HmacUtil.getThreadLocalMap();
        if (null == logIp || logIp.isEmpty() || null == logData || null == macData) {
            LOGGER.error((Object)"input paramer is error");
            return false;
        }
        Mac hmac = macIpMap.get(logIp);
        if (hmac == null) {
            Thread curThread = Thread.currentThread();
            String threadName = curThread.getName();
            hmac = this.getMacByIp(logIp);
            LOGGER.error((Object)("threadName : " + threadName + " logIp : " + logIp + " Mac : " + hmac));
            macIpMap.put(logIp, hmac);
            if (hmac == null) {
                LOGGER.error((Object)("doesnot have mac of device log ip:" + logIp));
                return false;
            }
        }
        try {
            byte[] macCount = hmac.doFinal(logData);
            if (ArrayUtils.isEquals((Object)macData, (Object)macCount)) {
                return true;
            }
        }
        catch (IllegalStateException e) {
            LOGGER.error((Object)("checkHmac error of device log ip " + logIp + ". " + e.getMessage()));
        }
        this.checkRemoveMacAndMap(logIp);
        AESDecryptorFactory.getInstance().checkRemoveDecryptMap(logIp);
        LOGGER.error((Object)("checkHmac error of device log ip" + logIp));
        return false;
    }
}

