/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.LogUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class ParamCheckUtil {
    public static final String DEFAULT_REGEX = "^[\\w|\u4e00-\u9fa5|\\-|\\!|\\@|\\#|\\$|\\^|\\.|\\+|\\}|\\{|\\/|\\:| ]*$";
    public static final String PACKET_FILE_NAME_REGEX = "^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.|\\*|\\:|\\,|\\/| |%]*$";
    public static final int PACKET_FILE_NAME_MAX_LENGTH = 256;
    public static final int MAX_LIST_SIZE = 10000;
    private static final Logger LOGGER = LogManager.getInstance().getRMILog();

    public static boolean isValidString(String str, int length) {
        return ParamCheckUtil.isValidString(str, length, DEFAULT_REGEX);
    }

    public static boolean isValidString(String str, int length, String regex) {
        if (CommonUtil.isNull(str)) {
            return true;
        }
        if (str.length() <= length && Pattern.matches(regex, str)) {
            return true;
        }
        LOGGER.error((Object)("input str not invalid, str=" + LogUtil.getCleanedMessage(str) + ", length=" + length + ", regex=" + regex));
        return false;
    }

    public static boolean isValidStringNotNull(String str, int length) {
        return ParamCheckUtil.isValidStringNotNull(str, length, DEFAULT_REGEX);
    }

    public static boolean isValidStringNotNull(String str, int length, String regex) {
        if (CommonUtil.isNull(str)) {
            LOGGER.error((Object)"input str is null or empty");
            return false;
        }
        if (str.length() <= length && Pattern.matches(regex, str)) {
            return true;
        }
        LOGGER.error((Object)("input str not invalid, str=" + LogUtil.getCleanedMessage(str) + ", length=" + length + ", regex=" + regex));
        return false;
    }

    public static boolean isValidStringList(List<String> list, int listSize, int strLength, String regex) {
        if (null == list || list.isEmpty()) {
            return true;
        }
        if (list.size() > listSize) {
            LOGGER.error((Object)("input list.size = " + list.size() + " is bigger than " + listSize));
            return false;
        }
        for (String str : list) {
            if (ParamCheckUtil.isValidString(str, strLength, regex)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidStringListNotNull(List<String> list, int listSize, int strLength) {
        return ParamCheckUtil.isValidStringListNotNull(list, listSize, strLength, DEFAULT_REGEX);
    }

    public static boolean isValidStringListNotNull(List<String> list, int listSize, int strLength, String regex) {
        if (null == list || list.isEmpty()) {
            LOGGER.error((Object)"input list is null or empty");
            return false;
        }
        if (list.size() > listSize) {
            LOGGER.error((Object)("input list.size = " + list.size() + " is bigger than " + listSize));
            return false;
        }
        for (String str : list) {
            if (ParamCheckUtil.isValidStringNotNull(str, strLength, regex)) continue;
            return false;
        }
        return true;
    }
}

