/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.biz.monitor.ISystemTool;
import com.hs.atic.collector.biz.monitor.SystemToolFactory;
import com.hs.atic.collector.entity.monitor.CollectorDiskObj;
import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class PcapUtil {
    public static final String POSTFIX_NAME = ".pcap";
    private static final String CONFIGFILE = "conf" + File.separator + "pcap.conf";
    private static final Logger LOGGER = LogManager.getInstance().getPcapLogger();

    private PcapUtil() {
    }

    public static String getCanonicalPath(String fileName) {
        return PcapUtil.getPcapFileDirectory() + File.separator + fileName + POSTFIX_NAME;
    }

    public static String getPcapConfigProperty(String key) {
        Properties properties = CommonUtil.openPropertyFile(CONFIGFILE);
        return properties.getProperty(key);
    }

    public static String getPcapFileDirectory() {
        return AticInstallUtil.getInstance().getCollectorInstallPath() + File.separator + "pcap";
    }

    public static int transformInt2LittleEnd(int value) {
        int c1 = value >>> 24 & 0xFF;
        int c2 = value >>> 16 & 0xFF;
        int c3 = value >>> 8 & 0xFF;
        int c4 = value >>> 0 & 0xFF;
        int littleEnd = c4 << 24 | c3 << 16 | c2 << 8 | c1 << 0;
        return littleEnd;
    }

    public static short transfromShort2LittleEnd(int value) {
        int c3 = value >>> 8 & 0xFF;
        int c4 = value >>> 0 & 0xFF;
        short littleEnd = (short)(c4 << 8 | c3 << 0);
        return littleEnd;
    }

    public static CollectorDiskObj getDiskInfo() {
        CollectorDiskObj disk = null;
        ISystemTool systemTool = SystemToolFactory.getSystemTool();
        try {
            long time = System.currentTimeMillis() / 1000L;
            if (systemTool == null) {
                return disk;
            }
            List<CollectorDiskObj> disks = systemTool.getDisk(time);
            for (CollectorDiskObj diskInfo : disks) {
                if (!PcapUtil.pcapFilesOnThisDisk(diskInfo)) continue;
                disk = diskInfo;
            }
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"RuntimeException getDiskInfo fail");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception getDiskInfo fail");
        }
        return disk;
    }

    public static boolean pcapFilesOnThisDisk(CollectorDiskObj disk) {
        String path = PcapUtil.getPcapFileDirectory();
        return path.indexOf(disk.getDiskName()) == 0;
    }
}

