/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.biz.alarm.SyslogThread;
import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.huawei.secsyslog.SyslogClientAbstrat;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class SyslogServerUtil {
    private static final Logger LOGGER = LogManager.getInstance().getRMILog();
    private static final String TABLE_NAME = "atic_syslog_server";
    private static final String UPDATE_SQL = "UPDATE atic_syslog_server set server_ip = ?,server_port = ?,default_zone_syslog = ?,atic_optlog = ?,device_syslog = ?,third_syslog = ?,flow_syslog = ?,flow_syslog_outbound = ?,ip_flow_seconds_syslog = ?,alarm_syslog = ?,alarm_min_level = ?,alarm_abnormity_log = ?,alarm_attack_log = ?,alarm_refresh_log = ?,alarm_detail_log = ?,alarm_abnormity_log_outbound = ?,alarm_attack_log_outbound = ?,alarm_refresh_log_outbound = ?,alarm_detail_log_outbound = ?,transfer_protocol = ?,certificate_name = ? where id = ? ";
    private static final String INSERT_SELECT_FILED = "id,server_ip,server_port,default_zone_syslog,atic_optlog,device_syslog,third_syslog,flow_syslog,flow_syslog_outbound,ip_flow_seconds_syslog,alarm_syslog,alarm_min_level,alarm_abnormity_log,alarm_attack_log,alarm_refresh_log,alarm_detail_log,alarm_abnormity_log_outbound,alarm_attack_log_outbound,alarm_refresh_log_outbound,alarm_detail_log_outbound,transfer_protocol,certificate_name";
    private static final String QUERY_ALL = "SELECT id,server_ip,server_port,default_zone_syslog,atic_optlog,device_syslog,third_syslog,flow_syslog,flow_syslog_outbound,ip_flow_seconds_syslog,alarm_syslog,alarm_min_level,alarm_abnormity_log,alarm_attack_log,alarm_refresh_log,alarm_detail_log,alarm_abnormity_log_outbound,alarm_attack_log_outbound,alarm_refresh_log_outbound,alarm_detail_log_outbound,transfer_protocol,certificate_name FROM atic_syslog_server";
    private static final String QUERY_BY_IP_PORT = "select id,server_ip,server_port,default_zone_syslog,atic_optlog,device_syslog,third_syslog,flow_syslog,flow_syslog_outbound,ip_flow_seconds_syslog,alarm_syslog,alarm_min_level,alarm_abnormity_log,alarm_attack_log,alarm_refresh_log,alarm_detail_log,alarm_abnormity_log_outbound,alarm_attack_log_outbound,alarm_refresh_log_outbound,alarm_detail_log_outbound,transfer_protocol,certificate_name FROM atic_syslog_server where server_ip = ? and server_port = ?";
    private static final String INSERT_SQL = "insert into atic_syslog_server(id,server_ip,server_port,default_zone_syslog,atic_optlog,device_syslog,third_syslog,flow_syslog,flow_syslog_outbound,ip_flow_seconds_syslog,alarm_syslog,alarm_min_level,alarm_abnormity_log,alarm_attack_log,alarm_refresh_log,alarm_detail_log,alarm_abnormity_log_outbound,alarm_attack_log_outbound,alarm_refresh_log_outbound,alarm_detail_log_outbound,transfer_protocol,certificate_name) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String DELETE_SYSLOG_SERVER_BY_ID = "delete from atic_syslog_server where id in (?)";
    private static SyslogServerUtil instance;
    private Map<String, SyslogServerEntity> serverFormMap = new HashMap<String, SyslogServerEntity>();

    private SyslogServerUtil() {
        if (this.serverFormMap.size() == 0) {
            this.serverFormMap = this.getSyslogServerInDatabase();
            LOGGER.info((Object)("Init serverFormMap, get from db, serverFormMap=" + this.serverFormMap.toString()));
        }
    }

    public static SyslogServerUtil getInstance() {
        if (null == instance) {
            instance = new SyslogServerUtil();
        }
        return instance;
    }

    public SyslogServerEntity getSyslogServerByIpPort(String ip, Integer port) {
        return this.getInDatabase(ip, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyslogServerEntity getInDatabase(String ip, Integer port) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement st = null;
        SyslogServerEntity server = null;
        ResultSet rs = null;
        if (conn == null) {
            LOGGER.error((Object)"DBConnPool.getConnection() retrun null.");
            return new SyslogServerEntity();
        }
        try {
            st = conn.prepareStatement(QUERY_BY_IP_PORT);
            int paramIndex = 1;
            st.setString(paramIndex, ip);
            st.setInt(++paramIndex, port);
            rs = st.executeQuery();
            int index = 0;
            while (rs.next()) {
                index = 1;
                server = new SyslogServerEntity();
                server.setId(rs.getInt(index++));
                server.setServerIp(rs.getString(index++));
                server.setServerPort(rs.getInt(index++));
                server.setDefaultZoneSyslog(rs.getInt(index++));
                server.setAticOptlog(rs.getInt(index++));
                server.setDeviceSyslog(rs.getInt(index++));
                server.setThirdSyslog(rs.getInt(index++));
                server.setFlowSyslog(rs.getInt(index++));
                server.setFlowSyslogOutbound(rs.getInt(index++));
                server.setIpFlowSecondsSyslog(rs.getInt(index++));
                server.setAlarmSyslog(rs.getInt(index++));
                server.setAlarmMinLevel(rs.getInt(index++));
                server.setAlarmAbnormityLog(rs.getInt(index++));
                server.setAlarmAttackLog(rs.getInt(index++));
                server.setAlarmRefreshLog(rs.getInt(index++));
                server.setAlarmDetailLog(rs.getInt(index++));
                server.setAlarmAbnormityLogOutbound(rs.getInt(index++));
                server.setAlarmAttackLogOutbound(rs.getInt(index++));
                server.setAlarmRefreshLogOutbound(rs.getInt(index++));
                server.setAlarmDetailLogOutbound(rs.getInt(index++));
                server.setTransferProtocol(rs.getInt(index++));
                server.setCertificateName(rs.getString(index++));
            }
            LOGGER.info((Object)"get SyslogServerEntity OK!!");
            SyslogServerEntity syslogServerEntity = server;
            this.closeResultSet(rs);
            this.closePreparedStatement(st);
            this.closeConnection(conn);
            return syslogServerEntity;
        }
        catch (SQLException e) {
            LOGGER.error((Object)"save SyslogServerEntity error");
            SyslogServerEntity syslogServerEntity = new SyslogServerEntity();
            return syslogServerEntity;
        }
        finally {
            this.closeResultSet(rs);
            this.closePreparedStatement(st);
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveSyslogServer(SyslogServerEntity server) {
        if (null == server) {
            LOGGER.info((Object)"syslog server is null.");
            return false;
        }
        SyslogServerEntity oldServer = null;
        if (0 != server.getId()) {
            for (Map.Entry<String, SyslogServerEntity> servermap : this.serverFormMap.entrySet()) {
                if (server.getId() != servermap.getValue().getId()) continue;
                oldServer = servermap.getValue();
                break;
            }
        }
        if (!this.saveInDatabase(server)) {
            return false;
        }
        String ipPort = server.getServerIp() + "," + server.getServerPort();
        Map<String, SyslogServerEntity> map = this.serverFormMap;
        synchronized (map) {
            if (null != oldServer) {
                String oldIpPort = oldServer.getServerIp() + "," + oldServer.getServerPort();
                this.serverFormMap.remove(oldIpPort);
            } else {
                SyslogServerEntity savedServer = this.getSyslogServerByIpPort(server.getServerIp(), server.getServerPort());
                if (savedServer != null) {
                    server.setId(savedServer.getId());
                }
            }
            this.serverFormMap.put(ipPort, server);
            Map<String, Object> keysAndValuesMap = SyslogThread.getInstance().getSyslogClienMapKeysAndValues();
            List keys = (List)keysAndValuesMap.get("keys");
            List values = (List)keysAndValuesMap.get("values");
            HashMap syslogClienMap = new HashMap();
            if (null == keys || keys.size() == 0) {
                syslogClienMap = null;
            } else {
                for (int i = 0; i < keys.size(); ++i) {
                    syslogClienMap.put(keys.get(i), values.get(i));
                }
            }
            SyslogClientAbstrat client = null;
            if (null != syslogClienMap && !syslogClienMap.isEmpty()) {
                client = (SyslogClientAbstrat)syslogClienMap.get(ipPort);
            }
            if (null != client) {
                client.setSyslogServerEntity(server);
            }
        }
        LOGGER.info((Object)"save syslog server success!");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveInDatabase(SyslogServerEntity syslogServer) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement ps = null;
        if (conn == null) {
            LOGGER.error((Object)"DBConnPool.getConnection() retrun null.");
            return false;
        }
        try {
            conn.setAutoCommit(false);
            if (0 == syslogServer.getId()) {
                LOGGER.info((Object)("create a new syslog server,serverId=" + syslogServer.getId()));
                ps = conn.prepareStatement(INSERT_SQL);
                this.setInsertSqlPrepared(ps, syslogServer);
                ps.executeBatch();
                conn.commit();
            } else {
                LOGGER.info((Object)("update syslog server,serverId=" + syslogServer.getId()));
                ps = conn.prepareStatement(UPDATE_SQL);
                SyslogServerUtil.setUpdateSqlPrepared(ps, syslogServer);
                ps.executeBatch();
                conn.commit();
            }
            LOGGER.info((Object)"update SyslogServerEntity OK!!");
            this.closePreparedStatement(ps);
            this.closeConnection(conn);
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException e2) {
                LOGGER.error((Object)"rollback error");
            }
            LOGGER.error((Object)"save SyslogServerEntity error");
            boolean bl = false;
            return bl;
        }
        finally {
            this.closePreparedStatement(ps);
            this.closeConnection(conn);
        }
        return true;
    }

    private void setInsertSqlPrepared(PreparedStatement ps, SyslogServerEntity syslogServer) throws SQLException {
        int paramIndex = 1;
        ps.setLong(paramIndex++, syslogServer.getId());
        SyslogServerUtil.addSyslogServerThreadPrepared(ps, syslogServer, paramIndex);
        ps.addBatch();
    }

    private static int addSyslogServerThreadPrepared(PreparedStatement ps, SyslogServerEntity syslogServer, int paramIndex) throws SQLException {
        ps.setString(paramIndex++, syslogServer.getServerIp());
        ps.setInt(paramIndex++, syslogServer.getServerPort());
        ps.setInt(paramIndex++, syslogServer.getDefaultZoneSyslog());
        ps.setInt(paramIndex++, syslogServer.getAticOptlog());
        ps.setInt(paramIndex++, syslogServer.getDeviceSyslog());
        ps.setInt(paramIndex++, syslogServer.getThirdSyslog());
        ps.setInt(paramIndex++, syslogServer.getFlowSyslog());
        ps.setInt(paramIndex++, syslogServer.getFlowSyslogOutbound());
        ps.setInt(paramIndex++, syslogServer.getIpFlowSecondsSyslog());
        ps.setInt(paramIndex++, syslogServer.getAlarmSyslog());
        ps.setInt(paramIndex++, syslogServer.getAlarmMinLevel());
        ps.setInt(paramIndex++, syslogServer.getAlarmAbnormityLog());
        ps.setInt(paramIndex++, syslogServer.getAlarmAttackLog());
        ps.setInt(paramIndex++, syslogServer.getAlarmRefreshLog());
        ps.setInt(paramIndex++, syslogServer.getAlarmDetailLog());
        ps.setInt(paramIndex++, syslogServer.getAlarmAbnormityLogOutbound());
        ps.setInt(paramIndex++, syslogServer.getAlarmAttackLogOutbound());
        ps.setInt(paramIndex++, syslogServer.getAlarmRefreshLogOutbound());
        ps.setInt(paramIndex++, syslogServer.getAlarmDetailLogOutbound());
        ps.setInt(paramIndex++, syslogServer.getTransferProtocol());
        ps.setString(paramIndex++, syslogServer.getCertificateName());
        return paramIndex;
    }

    private static void setUpdateSqlPrepared(PreparedStatement ps, SyslogServerEntity syslogServer) throws SQLException {
        int paramIndex = 1;
        paramIndex = SyslogServerUtil.addSyslogServerThreadPrepared(ps, syslogServer, paramIndex);
        ps.setLong(paramIndex, syslogServer.getId());
        ps.addBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SyslogServerEntity> getSyslogServerInDatabase() {
        HashMap<String, SyslogServerEntity> serverFormMaps = new HashMap<String, SyslogServerEntity>();
        SyslogServerEntity server = null;
        Connection conn = DBConnPool.getConnection();
        PreparedStatement st = null;
        ResultSet rs = null;
        String sql = QUERY_ALL;
        try {
            st = conn.prepareStatement(sql);
            rs = st.executeQuery();
            int index = 0;
            while (rs.next()) {
                index = 1;
                server = new SyslogServerEntity();
                server.setId(rs.getInt(index++));
                server.setServerIp(rs.getString(index++));
                server.setServerPort(rs.getInt(index++));
                server.setDefaultZoneSyslog(rs.getInt(index++));
                server.setAticOptlog(rs.getInt(index++));
                server.setDeviceSyslog(rs.getInt(index++));
                server.setThirdSyslog(rs.getInt(index++));
                server.setFlowSyslog(rs.getInt(index++));
                server.setFlowSyslogOutbound(rs.getInt(index++));
                server.setIpFlowSecondsSyslog(rs.getInt(index++));
                server.setAlarmSyslog(rs.getInt(index++));
                server.setAlarmMinLevel(rs.getInt(index++));
                server.setAlarmAbnormityLog(rs.getInt(index++));
                server.setAlarmAttackLog(rs.getInt(index++));
                server.setAlarmRefreshLog(rs.getInt(index++));
                server.setAlarmDetailLog(rs.getInt(index++));
                server.setAlarmAbnormityLogOutbound(rs.getInt(index++));
                server.setAlarmAttackLogOutbound(rs.getInt(index++));
                server.setAlarmRefreshLogOutbound(rs.getInt(index++));
                server.setAlarmDetailLogOutbound(rs.getInt(index++));
                server.setTransferProtocol(rs.getInt(index++));
                server.setCertificateName(rs.getString(index++));
                String ipPort = server.getServerIp() + "," + server.getServerPort();
                serverFormMaps.put(ipPort, server);
            }
            this.closeResultSet(rs);
            this.closePreparedStatement(st);
            this.closeConnection(conn);
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"getSyslogServerInDatabase SQLException");
                this.closeResultSet(rs);
                this.closePreparedStatement(st);
                this.closeConnection(conn);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closePreparedStatement(st);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        return serverFormMaps;
    }

    private void closeResultSet(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"when resultSet close is error");
            }
        }
    }

    private void closeConnection(Connection conn) {
        try {
            if (null != conn) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"db connection close faile");
        }
    }

    private void closePreparedStatement(PreparedStatement ps) {
        try {
            if (null != ps) {
                ps.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"db statement close faile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSysLogServers(String syslogServerIds) throws RemoteException {
        if (null == syslogServerIds || syslogServerIds.isEmpty()) {
            LOGGER.error((Object)"input syslog server ids is empty");
            return false;
        }
        Connection conn = DBConnPool.getConnection();
        PreparedStatement psDelete = null;
        if (conn == null) {
            LOGGER.error((Object)"DBConnPool.getConnection() retrun null.");
            return false;
        }
        try {
            ArrayList<String> deleteList = new ArrayList<String>();
            String[] ids = syslogServerIds.split(",");
            for (Map.Entry<String, SyslogServerEntity> map : this.serverFormMap.entrySet()) {
                for (int i = 0; i < ids.length; ++i) {
                    if (Integer.parseInt(ids[i]) != map.getValue().getId()) continue;
                    deleteList.add(map.getKey());
                }
            }
            if (!deleteList.isEmpty()) {
                Map<String, Object> keysAndValuesMap = SyslogThread.getInstance().getSyslogClienMapKeysAndValues();
                List keys = (List)keysAndValuesMap.get("keys");
                List values = (List)keysAndValuesMap.get("values");
                HashMap clientMap = new HashMap();
                if (null == keys || keys.size() == 0) {
                    clientMap = null;
                } else {
                    for (int i = 0; i < keys.size(); ++i) {
                        clientMap.put(keys.get(i), values.get(i));
                    }
                }
                Map<String, SyslogServerEntity> map = this.serverFormMap;
                synchronized (map) {
                    for (String key : deleteList) {
                        SyslogClientAbstrat serverThread;
                        this.serverFormMap.remove(key);
                        if (null == clientMap || clientMap.isEmpty() || null == (serverThread = (SyslogClientAbstrat)clientMap.get(key))) continue;
                        serverThread.stopClient();
                        clientMap.remove(key);
                    }
                }
            }
            for (int i = 0; i < ids.length; ++i) {
                psDelete = conn.prepareStatement(DELETE_SYSLOG_SERVER_BY_ID);
                psDelete.setString(1, ids[i]);
                psDelete.execute();
            }
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException e2) {
                LOGGER.error((Object)"rollback error");
            }
            LOGGER.error((Object)("deleteSysLogServers error.syslogServerIds=" + syslogServerIds));
            boolean bl = false;
            return bl;
        }
        finally {
            this.closePreparedStatement(psDelete);
            this.closeConnection(conn);
        }
        return true;
    }

    public Map<String, Object> getSyslogServerMapKeysAndValues() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<SyslogServerEntity> values = new ArrayList<SyslogServerEntity>();
        for (Map.Entry<String, SyslogServerEntity> serverMap : this.serverFormMap.entrySet()) {
            keys.add(serverMap.getKey());
            values.add(serverMap.getValue());
        }
        resultMap.put("keys", keys);
        resultMap.put("values", values);
        return resultMap;
    }

    public static boolean compareSyslogServer(SyslogServerEntity server1, SyslogServerEntity server2) {
        return server1.getServerIp().equals(server2.getServerIp()) && server1.getServerPort() == server2.getServerPort() && server1.getTransferProtocol() == server2.getTransferProtocol();
    }
}

