/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class TimeTransformer {
    private static final String FIRST_DAY = "01";
    private static final int TEN_DAY = 11;
    private static final int SECODE_TEN_DAY = 21;
    private static final int SIX_MONTH = 6;
    private static final String JANUARY = "01";
    private static final String JULY = "07";
    private static final String ZERO = "0";

    private TimeTransformer() {
    }

    public static String getDayExpress(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int year = calendar.get(1);
        int month = TimeTransformer.getMonth(calendar);
        int day = calendar.get(5);
        return TimeTransformer.twoDigitWidth(year) + TimeTransformer.twoDigitWidth(month) + TimeTransformer.twoDigitWidth(day);
    }

    public static String getHalfYearExpress(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int year = calendar.get(1);
        int month = TimeTransformer.getMonth(calendar);
        String date = month > 6 ? JULY : "01";
        return TimeTransformer.twoDigitWidth(year) + date;
    }

    public static String getMonthExpress(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int year = calendar.get(1);
        int month = TimeTransformer.getMonth(calendar);
        return TimeTransformer.twoDigitWidth(year) + TimeTransformer.twoDigitWidth(month);
    }

    public static String getTenDayExpress(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int year = calendar.get(1);
        int month = TimeTransformer.getMonth(calendar);
        int day = calendar.get(5);
        String date = "";
        date = day < 11 ? "01" : (day >= 21 ? "21" : "11");
        return TimeTransformer.twoDigitWidth(year) + TimeTransformer.twoDigitWidth(month) + date;
    }

    public static String getYearExpress(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int year = calendar.get(1);
        return TimeTransformer.twoDigitWidth(year);
    }

    private static int getMonth(Calendar calendar) {
        return calendar.get(2) + 1;
    }

    private static String twoDigitWidth(int value) {
        int result = value % 100;
        if (result > 9) {
            return "" + result;
        }
        return ZERO + result;
    }

    public static long convertTimeString(String time) {
        if (time == null || time.length() == 0) {
            return 0L;
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = formate.parse(time.trim());
            return date.getTime() / 1000L;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static String transferlong2String(Long time) {
        if (time == null) {
            return "";
        }
        Date d = new Date(time);
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formate.format(d);
    }

    public static long transferWithoutHour(long maxExactLogTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(maxExactLogTime * 1000L);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        String time = year + "-" + month + "-" + day + " 00:00:00";
        return TimeTransformer.convertTimeString(time);
    }

    public static long transferWithoutSecond(long maxExactLogTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(maxExactLogTime * 1000L);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        String time = year + "-" + month + "-" + day + " " + hour + ":00:00";
        return TimeTransformer.convertTimeString(time);
    }
}

