/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi;

import com.hs.atic.collector.util.LogManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;

public class ServerSocketFactory
implements RMIServerSocketFactory {
    protected static final Logger LOGGER = LogManager.getInstance().getSysLogLogger();
    private static SSLSocketFactory defaultSSLSocketFactory = null;
    private String serverIp = null;
    private final String[] enabledCipherSuites;
    private final String[] enabledProtocols;
    private final boolean needClientAuth;
    private List<String> enabledCipherSuitesList;
    private List<String> enabledProtocolsList;
    private SSLContext context;

    public ServerSocketFactory(String serverIp, String[] enabledCipherSuites, String[] enabledProtocols, boolean needClientAuth) {
        this(serverIp, null, enabledCipherSuites, enabledProtocols, needClientAuth);
    }

    public ServerSocketFactory(String serverIp, SSLContext context, String[] enabledCipherSuites, String[] enabledProtocols, boolean needClientAuth) {
        this.serverIp = serverIp;
        this.enabledCipherSuites = enabledCipherSuites == null ? null : (String[])enabledCipherSuites.clone();
        this.enabledProtocols = enabledProtocols == null ? null : (String[])enabledProtocols.clone();
        this.needClientAuth = needClientAuth;
        this.context = context;
        SSLSocketFactory sslSocketFactory = context == null ? ServerSocketFactory.getDefaultSSLSocketFactory() : context.getSocketFactory();
        SSLSocket sslSocket = null;
        if (this.enabledCipherSuites != null && this.enabledProtocols != null) {
            try {
                sslSocket = (SSLSocket)sslSocketFactory.createSocket();
                sslSocket.setEnabledCipherSuites(this.enabledCipherSuites);
                sslSocket.setEnabledProtocols(this.enabledProtocols);
            }
            catch (Exception e) {
                String msg = "Unable to check if the cipher suites and protocols to enable are supported";
                throw (IllegalArgumentException)new IllegalArgumentException("Unable to check if the cipher suites and protocols to enable are supported").initCause(e);
            }
            finally {
                try {
                    if (sslSocket != null) {
                        sslSocket.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)"exception when close socket");
                }
            }
        }
        if (this.enabledCipherSuites != null) {
            this.enabledCipherSuitesList = Arrays.asList(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            this.enabledProtocolsList = Arrays.asList(this.enabledProtocols);
        }
    }

    private static synchronized SSLSocketFactory getDefaultSSLSocketFactory() {
        if (defaultSSLSocketFactory == null) {
            defaultSSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        return defaultSSLSocketFactory;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        final SSLSocketFactory sslSocketFactory = this.context == null ? ServerSocketFactory.getDefaultSSLSocketFactory() : this.context.getSocketFactory();
        return new ServerSocket(port, 50, InetAddress.getByName(this.serverIp)){

            @Override
            public Socket accept() throws IOException {
                Socket socket = super.accept();
                SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
                sslSocket.setUseClientMode(false);
                if (ServerSocketFactory.this.enabledCipherSuites != null) {
                    sslSocket.setEnabledCipherSuites(ServerSocketFactory.this.enabledCipherSuites);
                }
                if (ServerSocketFactory.this.enabledProtocols != null) {
                    sslSocket.setEnabledProtocols(ServerSocketFactory.this.enabledProtocols);
                }
                sslSocket.setNeedClientAuth(ServerSocketFactory.this.needClientAuth);
                return sslSocket;
            }
        };
    }

    public final String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites == null ? null : (String[])this.enabledCipherSuites.clone();
    }

    public final String[] getEnabledProtocols() {
        return this.enabledProtocols == null ? null : (String[])this.enabledProtocols.clone();
    }

    public final boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServerSocketFactory)) {
            return false;
        }
        ServerSocketFactory that = (ServerSocketFactory)obj;
        return this.getClass().equals(that.getClass()) && this.checkParameters(that);
    }

    private boolean checkParameters(ServerSocketFactory that) {
        List<String> thatEnabledProtocolsList;
        List<String> thatEnabledCipherSuitesList;
        if (this.context == null ? that.context != null : !this.context.equals(that.context)) {
            return false;
        }
        if (this.needClientAuth != that.needClientAuth) {
            return false;
        }
        if (this.enabledCipherSuites == null && that.enabledCipherSuites != null || this.enabledCipherSuites != null && that.enabledCipherSuites == null) {
            return false;
        }
        if (this.enabledCipherSuites != null && that.enabledCipherSuites != null && !this.enabledCipherSuitesList.equals(thatEnabledCipherSuitesList = Arrays.asList(that.enabledCipherSuites))) {
            return false;
        }
        if (this.enabledProtocols == null && that.enabledProtocols != null || this.enabledProtocols != null && that.enabledProtocols == null) {
            return false;
        }
        return this.enabledProtocols == null || that.enabledProtocols == null || this.enabledProtocolsList.equals(thatEnabledProtocolsList = Arrays.asList(that.enabledProtocols));
    }

    public int hashCode() {
        return this.getClass().hashCode() + (this.context == null ? 0 : this.context.hashCode()) + (this.needClientAuth ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode()) + (this.enabledCipherSuites == null ? 0 : this.enabledCipherSuitesList.hashCode()) + (this.enabledProtocols == null ? 0 : this.enabledProtocolsList.hashCode());
    }
}

