/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.db.event.ExceptionRepository;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.LogUtil;
import com.hs.atic.collector.util.ParamCheckUtil;
import com.hs.atic.rmi.AttackData;
import com.hs.atic.rmi.AttackDataRmiService;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AttackDataServiceRMIImpl
extends UnicastRemoteObject
implements AttackDataRmiService {
    protected static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final long serialVersionUID = 1L;
    private static final int INTER_ACTIVE_ALL = -1;
    private static final int INTER_ACTIVE_AUTO_DEFEND = 3;
    private static final int INTER_ACTIVE_NOT_DEFEND = 4;

    public AttackDataServiceRMIImpl() throws RemoteException {
    }

    public AttackDataServiceRMIImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getQueryAllCount(Map<String, Object> queryMap) throws RemoteException {
        Integer num;
        ResultSet result;
        PreparedStatement query;
        Connection con;
        block15: {
            if (null == queryMap || queryMap.size() > 10000) {
                LOGGER.error((Object)"input param is not valid.");
                return 0;
            }
            con = null;
            query = null;
            result = null;
            int interActivePara = 0;
            try {
                interActivePara = Integer.parseInt((String)queryMap.get("interActive"));
            }
            catch (Exception e) {
                LOGGER.error((Object)("getQueryAllCount interActivePara error,interActivePara :" + interActivePara + ". " + e.getMessage()));
            }
            String zoneIdParam = (String)queryMap.get("zoneId");
            StringBuffer tmp = new StringBuffer();
            num = 0;
            HashMap<Integer, Object> valueMap = new HashMap<Integer, Object>();
            int index = 1;
            if (!"all".equals(queryMap.get("deviceIp")) && !((String)queryMap.get("deviceIp")).isEmpty()) {
                tmp.append(" select count(PKID) as countNum ");
                tmp.append(" from ");
                tmp.append(" atic_attack_log where 1 = 1 ");
                if (-1 != interActivePara && 3 != interActivePara && 4 != interActivePara) {
                    tmp.append(" AND INTERACTIVE = ? ");
                    valueMap.put(index++, interActivePara);
                }
                tmp.append(" and ZONE_ID = ? ");
                valueMap.put(index++, zoneIdParam);
                if (null != queryMap.get("deviceType") && !((String)queryMap.get("deviceType")).isEmpty()) {
                    int deviceTypePara = Integer.parseInt((String)queryMap.get("deviceType"));
                    tmp.append(" and DEVICE_TYPE = ? ");
                    valueMap.put(index++, deviceTypePara);
                }
                tmp.append("  AND DEVICE_IP IN ( ");
                String deviceIpsTemp = ((String)queryMap.get("deviceIp")).substring(1, ((String)queryMap.get("deviceIp")).length() - 1);
                String[] ips = deviceIpsTemp.split(",");
                for (int i = 0; i < ips.length; ++i) {
                    if (i == 0) {
                        tmp.append('?');
                    } else {
                        tmp.append(",?");
                    }
                    valueMap.put(index++, IpTransformer.formatIpAddress(ips[i]));
                }
                tmp.append(')');
                tmp.append(" AND ATTACK_STATUS <> 0 ");
                if (null != queryMap.get("direction")) {
                    int directionPara = (Integer)queryMap.get("direction");
                    tmp.append(" and DIRECTION = ? ");
                    valueMap.put(index++, directionPara);
                }
            }
            LOGGER.info((Object)("getQueryAllCount " + ((Object)valueMap).toString()));
            try {
                con = DBConnPool.getConnection();
                query = con.prepareStatement(tmp.toString());
                for (Map.Entry entry : valueMap.entrySet()) {
                    query.setObject((Integer)entry.getKey(), entry.getValue());
                }
                result = query.executeQuery();
                if (!result.next()) break block15;
                num = result.getInt("countNum");
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"query capture pcapFileInfo file  error");
                }
                catch (Throwable throwable) {
                    AttackDataServiceRMIImpl.freeDbResource(con, query, result);
                    throw throwable;
                }
                AttackDataServiceRMIImpl.freeDbResource(con, query, result);
            }
        }
        AttackDataServiceRMIImpl.freeDbResource(con, query, result);
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AttackData> getAttackData(Map<String, Object> queryMap) throws RemoteException {
        if (null == queryMap || queryMap.size() > 10000) {
            LOGGER.error((Object)"input param is not valid.");
            return new ArrayList<AttackData>();
        }
        Connection con = DBConnPool.getConnection();
        PreparedStatement query = null;
        ArrayList<AttackData> list = new ArrayList<AttackData>();
        ResultSet result = null;
        HashMap<Integer, Object> condition = new HashMap<Integer, Object>();
        String sql = this.getQuerySql(queryMap, true, condition);
        LOGGER.info((Object)("getAttackData " + ((Object)condition).toString()));
        List<AttackData> earlyDataList = this.getAttackDataEarlyAttackTime(queryMap);
        try {
            query = con.prepareStatement(sql);
            for (Map.Entry entry : condition.entrySet()) {
                query.setObject((Integer)entry.getKey(), entry.getValue());
            }
            result = query.executeQuery();
            AttackData data = null;
            while (result.next()) {
                data = new AttackData();
                long pkId = result.getLong("PKID");
                String deviceIp = result.getString("DEVICE_IP");
                int direction = result.getInt("DIRECTION");
                long zoneId = result.getLong("ZONE_ID");
                long bizId = result.getLong("BIZ_ID");
                String zoneIp = result.getString("ZONE_IP");
                long startTimeAlert = result.getLong("START_TIME_ALERT");
                int attackType = result.getInt("ATTACK_TYPE");
                int port = result.getInt("PORT");
                int attackStatus = result.getInt("ATTACK_STATUS");
                long dropBytes = result.getLong("DROP_PACKETS");
                long attackBytes = result.getLong("DROP_KBITS");
                int interActive = result.getInt("INTERACTIVE");
                int deviceType = result.getInt("DEVICE_TYPE");
                int protocol = result.getInt("PROTOCOL");
                long currentValue = result.getLong("CURRENT_VALUE");
                long limitValue = result.getLong("LIMIT_VALUE");
                int ppsOrKbps = result.getInt("PPS_OR_KBPS");
                long currentValue1 = result.getLong("CURRENT_VALUE_1");
                long limitValue1 = result.getLong("LIMIT_VALUE_1");
                int ppsOrKbps1 = result.getInt("PPS_OR_KBPS_1");
                data.setAttackDataPkId(pkId);
                data.setDeviceIp(deviceIp);
                data.setDirection(direction);
                data.setZoneId(zoneId);
                data.setBizId(bizId);
                data.setZoneIp(zoneIp);
                data.setStartTimeAlert(startTimeAlert);
                data.setAttackType(attackType);
                data.setPort(port);
                data.setAttackStatus(attackStatus);
                data.setDropBytes(dropBytes);
                data.setAttackBytes(attackBytes);
                data.setInterActive(interActive);
                data.setDeviceType(deviceType);
                data.setProtocol(protocol);
                data.setCurrentValue(currentValue);
                data.setLimitValue(limitValue);
                data.setPpsOrKbps(ppsOrKbps);
                data.setCurrentValue1(currentValue1);
                data.setLimitValue1(limitValue1);
                data.setPpsOrKbps1(ppsOrKbps1);
                data.setMultiCurrent(AttackTypeFactory.getInstance().isConnectionFlood(new AttackType(attackType, protocol, port)));
                for (AttackData attackData : earlyDataList) {
                    if (!this.checkIsSameIp(data, attackData).booleanValue()) continue;
                    data.setEarlyAlertTime(attackData.getEarlyAlertTime());
                    break;
                }
                if (null == data.getEarlyAlertTime()) {
                    data.setEarlyAlertTime(data.getStartTimeAlert());
                }
                list.add(data);
            }
            AttackDataServiceRMIImpl.freeDbResource(con, query, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"query capture pcapFileInfo file  error");
        }
        finally {
            AttackDataServiceRMIImpl.freeDbResource(con, query, result);
        }
        return list;
    }

    private String getQuerySql(Map<String, Object> queryMap, boolean needLimit, Map<Integer, Object> condition) {
        int index = 1;
        int interActivePara = 0;
        int start = 0;
        int pageSize = 0;
        try {
            interActivePara = Integer.parseInt((String)queryMap.get("interActive"));
            start = Integer.parseInt((String)queryMap.get("start"));
            pageSize = Integer.parseInt((String)queryMap.get("pageSize"));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("queryMap is error, queryMap=" + queryMap.toString()));
            return "";
        }
        String zoneIdParam = (String)queryMap.get("zoneId");
        StringBuffer tmp = new StringBuffer();
        if (!"all".equals(queryMap.get("deviceIp")) && !((String)queryMap.get("deviceIp")).isEmpty()) {
            tmp.append(" select PKID, DEVICE_IP,DIRECTION, ZONE_ID, BIZ_ID, ZONE_IP, START_TIME_ALERT, ");
            tmp.append(" ATTACK_TYPE, PORT, DROP_KBITS, DROP_PACKETS, ATTACK_STATUS, INTERACTIVE, DEVICE_TYPE,PROTOCOL,CURRENT_VALUE,LIMIT_VALUE,PPS_OR_KBPS,CURRENT_VALUE_1,LIMIT_VALUE_1,PPS_OR_KBPS_1 ");
            tmp.append(" from atic_attack_log where 1 = 1 ");
            if (-1 != interActivePara && 3 != interActivePara && 4 != interActivePara) {
                tmp.append(" AND INTERACTIVE = ? ");
                condition.put(index++, interActivePara);
            }
            if (null != queryMap.get("deviceType") && !((String)queryMap.get("deviceType")).isEmpty()) {
                int deviceTypePara = Integer.parseInt((String)queryMap.get("deviceType"));
                tmp.append(" and DEVICE_TYPE = ? ");
                condition.put(index++, deviceTypePara);
            }
            tmp.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneIdParam);
            tmp.append(" AND DEVICE_IP IN  ( ");
            String deviceIpsTemp = ((String)queryMap.get("deviceIp")).substring(1, ((String)queryMap.get("deviceIp")).length() - 1);
            String[] ips = deviceIpsTemp.split(",");
            for (int i = 0; i < ips.length; ++i) {
                if (i == 0) {
                    tmp.append('?');
                } else {
                    tmp.append(",?");
                }
                condition.put(index++, IpTransformer.formatIpAddress(ips[i]));
            }
            tmp.append(") AND ATTACK_STATUS <> 0 ");
        }
        if (null != queryMap.get("direction")) {
            int directionPara = (Integer)queryMap.get("direction");
            tmp.append(" and DIRECTION = ? ");
            condition.put(index++, directionPara);
        }
        if (needLimit) {
            tmp.append(" limit ? , ? ");
            condition.put(index++, start);
            condition.put(index++, pageSize);
        } else {
            tmp.append(" GROUP BY DEVICE_IP,DIRECTION,ZONE_ID,ZONE_IP ");
        }
        return tmp.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AttackData> getAttackDataEarlyAttackTime(Map<String, Object> queryMap) {
        ArrayList<AttackData> list = new ArrayList<AttackData>();
        HashMap<Integer, Object> condition = new HashMap<Integer, Object>();
        String tempSql = this.getQuerySql(queryMap, false, condition);
        if (tempSql.isEmpty()) {
            return list;
        }
        int temp = tempSql.indexOf("from");
        int startIndex = temp > 0 ? temp : tempSql.indexOf("FROM");
        String sql = "SELECT DEVICE_IP,DIRECTION,ZONE_ID,ZONE_IP,MIN(START_TIME_ALERT) earlyAlertTime ";
        sql = sql + tempSql.substring(startIndex, tempSql.length() - 1);
        Connection con = DBConnPool.getConnection();
        PreparedStatement query = null;
        ResultSet result = null;
        LOGGER.info((Object)("getAttackDataEarlyAttackTime " + ((Object)condition).toString()));
        try {
            query = con.prepareStatement(sql);
            for (Map.Entry entry : condition.entrySet()) {
                query.setObject((Integer)entry.getKey(), entry.getValue());
            }
            result = query.executeQuery();
            AttackData data = null;
            while (result.next()) {
                data = new AttackData();
                String deviceIp = result.getString("DEVICE_IP");
                long zoneId = result.getLong("ZONE_ID");
                String zoneIp = result.getString("ZONE_IP");
                long earlyAlertTime = result.getLong("earlyAlertTime");
                data.setDeviceIp(deviceIp);
                data.setZoneId(zoneId);
                data.setZoneIp(zoneIp);
                data.setEarlyAlertTime(earlyAlertTime);
                list.add(data);
            }
            AttackDataServiceRMIImpl.freeDbResource(con, query, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"getAttackDataEarlyAttackTime error");
        }
        finally {
            AttackDataServiceRMIImpl.freeDbResource(con, query, result);
        }
        return list;
    }

    private Boolean checkIsSameIp(AttackData attackData, AttackData attackDataCheck) {
        if (attackData.getDeviceIp().equals(attackDataCheck.getDeviceIp()) && attackData.getZoneId().equals(attackDataCheck.getZoneId()) && attackData.getZoneIp().equals(attackDataCheck.getZoneIp())) {
            return true;
        }
        return false;
    }

    @Override
    public void modifyAttackDatas(String inputStr) throws RemoteException {
        if (!ParamCheckUtil.isValidStringNotNull(inputStr, 10000)) {
            LOGGER.error((Object)"input param in not valid");
            return;
        }
        String[] pkIds = this.getPkIds(inputStr);
        try {
            this.updateAttackDatas(pkIds);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)e.getMessage());
        }
    }

    @Override
    public Map<String, Boolean> modifyAttackDatasForResult(String inputStr) throws RemoteException {
        if (!ParamCheckUtil.isValidStringNotNull(inputStr, 10000)) {
            LOGGER.error((Object)"input param in not valid");
            return new HashMap<String, Boolean>();
        }
        String[] pkIds = this.getPkIds(inputStr);
        if (null == pkIds) {
            return new HashMap<String, Boolean>();
        }
        try {
            return this.updateDefendStatus(pkIds);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)e.getMessage());
            return new HashMap<String, Boolean>();
        }
    }

    private String[] getPkIds(String inputStr) {
        String firstFlag = ",";
        String secondFlag = ":";
        ArrayList<String> pkIdList = new ArrayList<String>();
        String[] pkIds = null;
        String[] attackDatas = inputStr.split(firstFlag);
        if (attackDatas.length > 0) {
            for (String attackData : attackDatas) {
                String[] attackDataAtts = attackData.split(secondFlag);
                String pkId = attackDataAtts[0];
                if (!"".equals(pkId)) {
                    pkIdList.add(pkId);
                }
                pkIdList.add(pkId);
            }
            pkIds = new String[pkIdList.size()];
            pkIdList.toArray(pkIds);
        }
        return pkIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAttackDatas(String[] pkIds) throws RemoteException {
        if (null == pkIds) {
            return;
        }
        Connection con = DBConnPool.getConnection();
        PreparedStatement query = null;
        StringBuffer tmp = new StringBuffer();
        String sql = null;
        HashMap<Integer, String> condition = new HashMap<Integer, String>();
        int index = 1;
        tmp.append(" update atic_attack_log ");
        tmp.append(" set INTERACTIVE = 1 ");
        tmp.append(" where pkId in ( ");
        int j = pkIds.length;
        for (int i = 0; i < j; ++i) {
            tmp.append('?');
            condition.put(index++, pkIds[i]);
            if (i != pkIds.length - 1) {
                tmp.append(" , ");
                continue;
            }
            tmp.append(" ) ");
        }
        tmp.append(" AND ATTACK_STATUS <>0  ");
        sql = tmp.toString();
        try {
            query = con.prepareStatement(sql);
            for (Map.Entry entry : condition.entrySet()) {
                query.setObject((Integer)entry.getKey(), entry.getValue());
            }
            query.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error((Object)"query capture pcapFileInfo file  error");
        }
        finally {
            AttackDataServiceRMIImpl.freeDbResource(con, query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Boolean> updateDefendStatus(String[] pkIds) throws RemoteException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Connection con = DBConnPool.getConnection();
        if (null == con) {
            for (String each : pkIds) {
                result.put(each, false);
            }
            return result;
        }
        PreparedStatement query = null;
        try {
            int j = pkIds.length;
            for (int i = 0; i < j; ++i) {
                StringBuffer tmp = new StringBuffer();
                tmp.append(" update atic_attack_log ");
                tmp.append(" set INTERACTIVE = 1 ");
                tmp.append(" where pkId = ? ");
                tmp.append(" AND ATTACK_STATUS <>0  ");
                String sql = tmp.toString();
                try {
                    query = con.prepareStatement(sql);
                    query.setString(1, pkIds[i]);
                    query.executeUpdate();
                    result.put(pkIds[i], true);
                    continue;
                }
                catch (SQLException e) {
                    result.put(pkIds[i], false);
                    LOGGER.error((Object)("update each  updateDefendStatus error,id is " + LogUtil.getCleanedMessage(pkIds[i])));
                    continue;
                }
                finally {
                    AttackDataServiceRMIImpl.freeDbResource(null, query);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("updateDefendStatus error!" + e.getMessage()));
        }
        finally {
            AttackDataServiceRMIImpl.freeDbResource(con, query);
        }
        return result;
    }

    protected static void freeDbResource(Connection con, PreparedStatement stmt) {
        try {
            if (null != stmt) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        try {
            if (null != con) {
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close connection error");
        }
    }

    protected static void freeDbResource(Connection con, PreparedStatement stmt, ResultSet result) {
        if (null != result) {
            try {
                result.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"result.close() is error SQLException");
            }
        }
        try {
            if (null != stmt) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        try {
            if (null != con) {
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close connection error");
        }
    }

    @Override
    public int getZoneDefendState(long zoneId) throws RemoteException {
        ExceptionRepository repository = new ExceptionRepository();
        return repository.getZoneDfendState(zoneId);
    }

    @Override
    public int getDefendState(long zoneId, String deviceIp) throws RemoteException {
        if (!IpTransformer.checkIpInvaild(deviceIp)) {
            LOGGER.error((Object)"deviceIp is not invalid.");
            return -1;
        }
        ExceptionRepository repository = new ExceptionRepository();
        return repository.getDefendState(zoneId, deviceIp);
    }

    @Override
    public boolean getAttackStatus(long zoneId, String zoneIp, String deviceIp) throws RemoteException {
        LOGGER.info((Object)("getAttackStatus.zoneip is" + zoneIp));
        if (!IpTransformer.checkIpInvaild(zoneIp)) {
            LOGGER.error((Object)"getAttackStatus zoneIp is not invalid.");
            return false;
        }
        ExceptionRepository repository = new ExceptionRepository();
        return repository.getAttackStatus(zoneId, zoneIp, deviceIp);
    }
}

