/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.biz.event.process.ZoneBlackListEventHandler;
import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.entity.BlackListData;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.ParamCheckUtil;
import com.hs.atic.rmi.BlackListRmiService;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BlackListServiceRMIImpl
extends UnicastRemoteObject
implements BlackListRmiService {
    protected static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final long serialVersionUID = 1L;

    public BlackListServiceRMIImpl() throws RemoteException {
    }

    public BlackListServiceRMIImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getQueryAllCount(Map<String, String> queryMap) throws RemoteException {
        if (null == queryMap || queryMap.size() > 10000) {
            LOGGER.error((Object)"input param is not valid.");
            return 0;
        }
        Integer countNum = 0;
        Connection con = null;
        PreparedStatement query = null;
        ResultSet result = null;
        StringBuffer tmp = new StringBuffer();
        String sql = null;
        int enablePara = Integer.parseInt(queryMap.get("enable"));
        int blackTypePara = Integer.parseInt(queryMap.get("blackType"));
        String queryBlackIp = queryMap.get("blackIp");
        String deviceIp = queryMap.get("deviceIp");
        String queryZoneId = queryMap.get("zoneId");
        tmp.append(" select count(PKID) as countNum ");
        tmp.append(" from atic_zone_blacklist where 1=1");
        HashMap<Integer, Object> valueMap = new HashMap<Integer, Object>();
        int index = 1;
        if (deviceIp != null) {
            tmp.append(" and device_IP = ? ");
            valueMap.put(index++, IpTransformer.formatIpAddress(deviceIp));
        }
        if (blackTypePara != 0) {
            tmp.append(" and BLACK_TYPE = ? ");
            valueMap.put(index++, blackTypePara);
        }
        if (queryBlackIp != null) {
            tmp.append(" and BLACK_IP = ? ");
            valueMap.put(index++, queryBlackIp);
        }
        if (enablePara != 0) {
            tmp.append(" and enable = ? ");
            valueMap.put(index++, enablePara);
        }
        if (null != queryZoneId && !"".equals(queryZoneId)) {
            tmp.append(" and ZONE_ID = ? ");
            valueMap.put(index++, queryZoneId);
        }
        sql = tmp.toString();
        try {
            con = DBConnPool.getConnection();
            query = con.prepareStatement(sql);
            for (Map.Entry entry : valueMap.entrySet()) {
                query.setObject((Integer)entry.getKey(), entry.getValue());
            }
            result = query.executeQuery();
            if (result.next()) {
                Integer n = countNum = Integer.valueOf(result.getInt("countNum"));
                BlackListServiceRMIImpl.freeDbResource(con, query, result);
                return n;
            }
            BlackListServiceRMIImpl.freeDbResource(con, query, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"query capture pcapFileInfo file  error");
        }
        finally {
            BlackListServiceRMIImpl.freeDbResource(con, query, result);
        }
        return countNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BlackListData> getBlackListData(Map<String, String> queryMap) throws RemoteException {
        if (null == queryMap || queryMap.size() > 10000) {
            LOGGER.error((Object)"input param is not valid.");
            return new ArrayList<BlackListData>();
        }
        Connection con = null;
        PreparedStatement query = null;
        ArrayList<BlackListData> list = new ArrayList<BlackListData>();
        ResultSet result = null;
        StringBuffer tmp = new StringBuffer();
        String sql = null;
        int enablePara = Integer.parseInt(queryMap.get("enable"));
        int blackTypePara = 0;
        try {
            blackTypePara = Integer.parseInt(queryMap.get("blackType"));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"getBlackListData NumberFormatException ");
        }
        String deviceIp = queryMap.get("deviceIp");
        String queryZoneId = queryMap.get("zoneId");
        String queryBlackIp = queryMap.get("blackIp");
        tmp.append(" select PKID, DEVICE_IP, ZONE_ID, BIZ_ID,ZONE_IP,START_TIME,BLACK_IP, PROTOCOL, PORT, BLACK_TYPE, STATUS,ENABLE ");
        tmp.append(" from atic_zone_blacklist where 1=1 ");
        HashMap<Integer, Object> valueMap = new HashMap<Integer, Object>();
        int index = 1;
        if (deviceIp != null) {
            tmp.append(" and device_IP = ? ");
            valueMap.put(index++, IpTransformer.formatIpAddress(deviceIp));
        }
        if (blackTypePara != 0) {
            tmp.append(" and BLACK_TYPE = ? ");
            valueMap.put(index++, blackTypePara);
        }
        if (enablePara != 0) {
            tmp.append(" and enable = ? ");
            valueMap.put(index++, enablePara);
        }
        if (queryBlackIp != null && !"".equals(queryBlackIp)) {
            tmp.append(" and BLACK_IP = ? ");
            valueMap.put(index++, IpTransformer.formatIpAddress(queryBlackIp));
        }
        if (null != queryZoneId && !"".equals(queryZoneId)) {
            tmp.append(" and ZONE_ID = ? ");
            valueMap.put(index++, queryZoneId);
        }
        sql = tmp.toString();
        try {
            con = DBConnPool.getConnection();
            query = con.prepareStatement(sql);
            for (Map.Entry entry : valueMap.entrySet()) {
                query.setObject((Integer)entry.getKey(), entry.getValue());
            }
            result = query.executeQuery();
            BlackListData blakListData = null;
            while (result.next()) {
                blakListData = new BlackListData();
                long pkId = result.getLong("PKID");
                String queryDeviceIp = result.getString("DEVICE_IP");
                long zoneId = result.getLong("ZONE_ID");
                long bizId = result.getLong("BIZ_ID");
                String blackIp = result.getString("BLACK_IP");
                long protocol = result.getLong("PROTOCOL");
                long port = result.getLong("PORT");
                long blackType = result.getLong("BLACK_TYPE");
                long status = result.getLong("STATUS");
                long enable = result.getLong("ENABLE");
                String zoneIp = result.getString("ZONE_IP");
                long startTime = result.getLong("START_TIME");
                blakListData.setPkId(pkId);
                blakListData.setDeviceIp(queryDeviceIp);
                blakListData.setZoneId(zoneId);
                blakListData.setBizId(bizId);
                blakListData.setBlackIp(blackIp);
                blakListData.setProtocol(protocol);
                blakListData.setPort(port);
                blakListData.setBlackType(blackType);
                blakListData.setStatus(status);
                blakListData.setEnable(enable);
                blakListData.setZoneIp(zoneIp);
                blakListData.setStartTime(startTime);
                list.add(blakListData);
            }
            BlackListServiceRMIImpl.freeDbResource(con, query, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"query capture pcapFileInfo file  error");
        }
        finally {
            BlackListServiceRMIImpl.freeDbResource(con, query, result);
        }
        return list;
    }

    @Override
    public void startupService(String inputStr) throws RemoteException {
        if (!ParamCheckUtil.isValidStringNotNull(inputStr, 10000)) {
            LOGGER.error((Object)"input param in not valid");
            return;
        }
        String[] pkIds = this.getPkIds(inputStr);
        this.updateBlackList(pkIds);
    }

    @Override
    public void stopService(List<BlackListData> blacklists) throws RemoteException {
        if (null == blacklists || blacklists.isEmpty()) {
            LOGGER.error((Object)"input param in not valid");
            return;
        }
        String[] pkIds = new String[blacklists.size()];
        for (int i = 0; i < blacklists.size(); ++i) {
            pkIds[i] = String.valueOf(blacklists.get(i).getPkId());
        }
        this.delBlackList(pkIds);
        ZoneBlackListEventHandler.getInstance().deleteBlacklists(blacklists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlackList(String[] pkIds) throws RemoteException {
        if (null == pkIds) {
            return;
        }
        Connection con = null;
        PreparedStatement query = null;
        StringBuffer tmp = new StringBuffer();
        HashMap<Integer, String> condition = new HashMap<Integer, String>();
        int index = 1;
        tmp.append(" update atic_zone_blacklist ");
        tmp.append(" set ENABLE = 2 ");
        tmp.append(" where pkId in ( ");
        int j = pkIds.length;
        for (int i = 0; i < j; ++i) {
            tmp.append('?');
            condition.put(index++, pkIds[i]);
            if (i != pkIds.length - 1) {
                tmp.append(" , ");
                continue;
            }
            tmp.append(" ) ");
        }
        try {
            con = DBConnPool.getConnection();
            query = con.prepareStatement(tmp.toString());
            for (Map.Entry entry : condition.entrySet()) {
                query.setObject((Integer)entry.getKey(), entry.getValue());
            }
            query.executeUpdate();
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)" capture updateBlackList  error");
            }
            catch (Throwable throwable) {
                BlackListServiceRMIImpl.freeDbResource(con, query);
                throw throwable;
            }
            BlackListServiceRMIImpl.freeDbResource(con, query);
        }
        BlackListServiceRMIImpl.freeDbResource(con, query);
    }

    public void delBlackList(String[] pkIds) throws RemoteException {
        if (null == pkIds) {
            return;
        }
        Connection con = null;
        PreparedStatement query = null;
        StringBuffer tmp = new StringBuffer();
        HashMap<Integer, String> condition = new HashMap<Integer, String>();
        int index = 1;
        tmp.append(" delete from  atic_zone_blacklist ");
        tmp.append(" where pkId in ( ");
        int j = pkIds.length;
        for (int i = 0; i < j; ++i) {
            tmp.append('?');
            condition.put(index++, pkIds[i]);
            if (i != pkIds.length - 1) {
                tmp.append(" , ");
                continue;
            }
            tmp.append(" ) ");
        }
        try {
            con = DBConnPool.getConnection();
            query = con.prepareStatement(tmp.toString());
            for (Map.Entry entry : condition.entrySet()) {
                query.setObject((Integer)entry.getKey(), entry.getValue());
            }
            query.executeUpdate();
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)" capture delBlackList  error");
                throw new RemoteException("delBlackList error");
            }
            catch (Throwable throwable) {
                BlackListServiceRMIImpl.freeDbResource(con, query);
                throw throwable;
            }
        }
        BlackListServiceRMIImpl.freeDbResource(con, query);
    }

    private String[] getPkIds(String inputStr) {
        String firstFlag = ",";
        String secondFlag = ":";
        ArrayList<String> pkIdList = new ArrayList<String>();
        String[] pkIds = null;
        String[] datas = inputStr.split(firstFlag);
        if (datas.length > 0) {
            for (String data : datas) {
                String[] blackListDatas = data.split(secondFlag);
                String pkId = blackListDatas[0];
                if ("".equals(pkId)) continue;
                pkIdList.add(pkId);
            }
            pkIds = new String[pkIdList.size()];
            pkIdList.toArray(pkIds);
        }
        return pkIds;
    }

    protected static void freeDbResource(Connection con, Statement stmt, ResultSet result) {
        if (null != result) {
            try {
                result.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"result.close() is error");
            }
        }
        try {
            if (null != stmt) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        try {
            if (null != con) {
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close connection error");
        }
    }

    protected static void freeDbResource(Connection con, PreparedStatement stmt) {
        try {
            if (null != stmt) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        try {
            if (null != con) {
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close connection error");
        }
    }

    @Override
    public void stopAllService(String zoneIdStr) throws RemoteException {
        long zoneId = 0L;
        try {
            zoneId = Long.parseLong(zoneIdStr);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"input zoneId is not number.");
            throw new RemoteException("input zoneId is not number.");
        }
        LOGGER.debug((Object)("start to delete all blacklist of zoneId=" + zoneId));
        Connection con = null;
        PreparedStatement query = null;
        String deleteSql = " delete from atic_zone_blacklist where zone_id=? ";
        try {
            con = DBConnPool.getConnection();
            query = con.prepareStatement(deleteSql);
            query.setObject(1, zoneId);
            query.execute();
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)("delete blackList error of zoneId=" + zoneId));
                throw new RemoteException("delete blackLists by zoneId error.");
            }
            catch (Throwable throwable) {
                BlackListServiceRMIImpl.freeDbResource(con, query);
                throw throwable;
            }
        }
        BlackListServiceRMIImpl.freeDbResource(con, query);
        ZoneBlackListEventHandler.getInstance().deleteBlacklistsByZone(zoneId);
        LOGGER.debug((Object)("end to delete all blacklist of zoneId=" + zoneId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BlackListData> getBlackListByDeviceIp(String deviceIp, long lastTime) throws RemoteException {
        LOGGER.info((Object)("start getBlackListByDeviceIp ,deviceIp is  " + deviceIp));
        StringBuffer tmp = new StringBuffer();
        tmp.append(" select PKID, DEVICE_IP, ZONE_ID, BIZ_ID, ZONE_IP, START_TIME, END_TIME, BLACK_IP, PROTOCOL, PORT, BLACK_TYPE, STATUS, ENABLE ");
        tmp.append(" from atic_zone_blacklist_history where 1=1 ");
        HashMap<Integer, Object> valueMap = new HashMap<Integer, Object>();
        tmp.append(" and DEVICE_IP = ?");
        tmp.append(" and END_TIME >= ?");
        valueMap.put(1, deviceIp);
        valueMap.put(2, lastTime);
        String sql = tmp.toString();
        Connection con = null;
        PreparedStatement query = null;
        ResultSet result = null;
        ArrayList<BlackListData> list = new ArrayList<BlackListData>();
        try {
            con = DBConnPool.getConnection();
            query = con.prepareStatement(sql);
            for (Map.Entry entry : valueMap.entrySet()) {
                query.setObject((Integer)entry.getKey(), entry.getValue());
            }
            result = query.executeQuery();
            BlackListData blakListData = null;
            while (result.next()) {
                blakListData = new BlackListData();
                blakListData.setPkId(result.getLong("PKID"));
                blakListData.setDeviceIp(result.getString("DEVICE_IP"));
                blakListData.setZoneId(result.getLong("ZONE_ID"));
                blakListData.setBizId(result.getLong("BIZ_ID"));
                blakListData.setBlackIp(result.getString("BLACK_IP"));
                blakListData.setProtocol(result.getLong("PROTOCOL"));
                blakListData.setPort(result.getLong("PORT"));
                blakListData.setBlackType(result.getLong("BLACK_TYPE"));
                blakListData.setStatus(result.getLong("STATUS"));
                blakListData.setEnable(result.getLong("ENABLE"));
                blakListData.setZoneIp(result.getString("ZONE_IP"));
                blakListData.setStartTime(result.getLong("START_TIME"));
                blakListData.setEndTime(result.getLong("END_TIME"));
                list.add(blakListData);
            }
            BlackListServiceRMIImpl.freeDbResource(con, query, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"query blacklist history data error");
        }
        finally {
            BlackListServiceRMIImpl.freeDbResource(con, query, result);
        }
        LOGGER.info((Object)"end getBlackListByDeviceIp ...");
        return list;
    }
}

