/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.biz.event.process.DynamicBaselineHandler;
import com.hs.atic.collector.entity.event.DynamicBaseLineTask;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.DynamicBaseLineService;
import com.hs.atic.rmi.ServerSocketFactory;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.apache.log4j.Logger;

public class DynamicBaseLineServiceImpl
extends UnicastRemoteObject
implements DynamicBaseLineService {
    private static final Logger LOGGER = LogManager.getInstance().getRMILog();
    private static final long serialVersionUID = -2516681478655590066L;

    public DynamicBaseLineServiceImpl() throws RemoteException {
    }

    public DynamicBaseLineServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    @Override
    public void addBaseLineTask(long startTime, long endTime, long taskId, long zoneId) throws RemoteException {
        DynamicBaseLineTask task = new DynamicBaseLineTask(taskId, zoneId);
        task.setStartTime(startTime * 1000L);
        task.setEndTime(endTime * 1000L);
        DynamicBaselineHandler.getInstance().addDynamicBaseLineTask(task);
        LOGGER.info((Object)("Add baseLine task is:" + task));
    }

    @Override
    public void cancelBaseLineTask(long taskId) throws RemoteException {
        LOGGER.info((Object)("Cancel base line task.Task id is : " + taskId));
        DynamicBaselineHandler.getInstance().cancelDynamicBaseLineTask(taskId);
    }

    @Override
    public void deleteBaseLineTask(long taskId) throws RemoteException {
        LOGGER.info((Object)("Delete base line task.Task id is : " + taskId));
        DynamicBaselineHandler.getInstance().deleteDynamicBaseLineTask(taskId);
    }
}

