/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.entity.CertInfoEntity;
import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.ParamCheckUtil;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.FileTransService;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.lego.core.sdk.base.dataprotect.util.AticDataProtector;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FileTransServiceImpl
extends UnicastRemoteObject
implements FileTransService {
    protected static final Logger LOGGER = LogManager.getInstance().getFileTransLogger();
    private static final long serialVersionUID = 1L;

    public FileTransServiceImpl() throws RemoteException {
    }

    public FileTransServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getFile(String fileName) {
        if (!ParamCheckUtil.isValidStringNotNull(fileName, 256)) {
            LOGGER.error((Object)"input fileName is not valid");
            return new byte[0];
        }
        String rootPath = AticInstallUtil.getInstance().getCollectorInstallPath();
        String filePath = rootPath + File.separator + "cert" + File.separator + fileName;
        File findFile = new File(filePath);
        if (findFile.exists() && !findFile.isDirectory()) {
            byte[] b = new byte[(int)findFile.length()];
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(findFile));
                if (is.read(b) != (int)findFile.length()) {
                    LOGGER.error((Object)"stream read error");
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.error((Object)"file not foud");
            }
            catch (IOException e) {
                LOGGER.error((Object)"getFile IOException");
            }
            finally {
                try {
                    if (null != is) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close bufferedInputStream error");
                }
            }
            return b;
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveFile(byte[] fileBytes) {
        boolean result = true;
        FileOutputStream fileOutput = null;
        try {
            String saveFilePath = CollectorConstants.PATH_LEGORUNTIME + "third_truststore";
            fileOutput = new FileOutputStream(saveFilePath);
            fileOutput.write(fileBytes);
            fileOutput.flush();
            return result;
        }
        catch (IOException e) {
            result = false;
            LOGGER.error((Object)"saveFile error");
            return result;
        }
        finally {
            if (fileOutput != null) {
                try {
                    try {
                        fileOutput.close();
                        fileOutput = null;
                    }
                    catch (IOException e) {
                        fileOutput = null;
                        fileOutput = null;
                    }
                }
                catch (Throwable throwable) {
                    fileOutput = null;
                    throw throwable;
                }
            }
        }
    }

    @Override
    public List<CertInfoEntity> getCertInfos() throws RemoteException {
        CertInfoEntity certInfoEntity = null;
        ArrayList<CertInfoEntity> certInfoEntities = new ArrayList<CertInfoEntity>();
        Properties properties = this.loadProperties();
        certInfoEntity = new CertInfoEntity();
        certInfoEntity.setName(properties.getProperty("keystore.collector.name"));
        certInfoEntity.setPath(AticInstallUtil.getInstance().getCollectorInstallPath() + properties.getProperty("keystore.collector.path"));
        certInfoEntity.setKeyStorePwd(AticDataProtector.sdpDecryptInitData(properties.getProperty("keystore.collector.password")).toString());
        certInfoEntities.add(certInfoEntity);
        certInfoEntity = new CertInfoEntity();
        certInfoEntity.setName(properties.getProperty("truststore.collector.name"));
        certInfoEntity.setPath(AticInstallUtil.getInstance().getCollectorInstallPath() + properties.getProperty("truststore.collector.path"));
        certInfoEntity.setKeyStorePwd(AticDataProtector.sdpDecryptInitData(properties.getProperty("truststore.collector.password")).toString());
        certInfoEntities.add(certInfoEntity);
        certInfoEntity = new CertInfoEntity();
        certInfoEntity.setName(properties.getProperty("truststore.third.name"));
        certInfoEntity.setPath(AticInstallUtil.getInstance().getCollectorInstallPath() + properties.getProperty("truststore.third.path"));
        certInfoEntity.setKeyStorePwd(AticDataProtector.sdpDecryptInitData(properties.getProperty("truststore.third.password")).toString());
        certInfoEntities.add(certInfoEntity);
        return certInfoEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties() {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            String path = AticInstallUtil.getInstance().getCollectorInstallPath() + File.separator + "cert" + File.separator + "collectorCertInfo.properties";
            inputStream = new FileInputStream(path);
            properties.load(inputStream);
        }
        catch (IOException e) {
            LOGGER.error((Object)"load collectorCertInfo.properties error");
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)("load collectorCertInfo.properties error, " + e.getMessage()));
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close inputStream error ");
                }
            }
        }
        return properties;
    }
}

