/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.biz.report.ZoneSecurityTableUtil;
import com.hs.atic.collector.db.report.DBStat;
import com.hs.atic.collector.entity.log.FlowCompare;
import com.hs.atic.collector.entity.log.FlowCompareCondition;
import com.hs.atic.collector.entity.log.VersionUpgrade;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.FlowCompareQueryType;
import com.hs.atic.rmi.FlowCompareService;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.rmi.impl.FlowCompareQueryTypeWithBiz;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FlowCompareServiceImpl
extends UnicastRemoteObject
implements FlowCompareService {
    protected static final Logger LOG = LogManager.getInstance().getReportLogger();
    private static final long serialVersionUID = -4240564340960341475L;
    protected final DBStat flowCompareDao = new DBStat();
    private FlowCompareQueryType queryTypeObject;

    public FlowCompareServiceImpl() throws RemoteException {
    }

    public FlowCompareServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    private void setIpToFormate(FlowCompareCondition flowCompareCondition) {
        List<String> devIpList = flowCompareCondition.getDeviceIpList();
        if (null != devIpList && !devIpList.isEmpty() && devIpList.size() < 10000) {
            ArrayList<String> tempDeviceList = new ArrayList<String>();
            for (String tempDeviceIp : devIpList) {
                if (!IpTransformer.checkIpInvaild(tempDeviceIp)) continue;
                String tempIpStr = IpTransformer.formatIpAddress(tempDeviceIp);
                tempDeviceList.add(tempIpStr);
            }
            flowCompareCondition.getDeviceIpList().clear();
            flowCompareCondition.setDeviceIpList(tempDeviceList);
        }
        if (IpTransformer.checkIpInvaild(flowCompareCondition.getZoneIp())) {
            flowCompareCondition.setZoneIp(IpTransformer.formatIpAddress(flowCompareCondition.getZoneIp()));
        }
    }

    @Override
    public List<FlowCompare> queryFlowCompare(FlowCompareCondition flowCompareCondition) throws RemoteException {
        if (null == flowCompareCondition) {
            LOG.error((Object)"input flowCompareCondition is null.");
            return null;
        }
        LOG.info((Object)"start queryFlowCompare");
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        Long sessionId = flowCompareCondition.getSessionId();
        List<Long> zoneIdList = flowCompareCondition.getZoneIdList();
        if (!CollectorConstants.QUERY_TYPE_ONLY_DEVICE.equals(flowCompareCondition.getQueryType()) && null != sessionId && null != zoneIdList && !zoneIdList.isEmpty() && zoneIdList.size() < 10000) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(zoneIdList, sessionId);
        }
        this.setIpToFormate(flowCompareCondition);
        this.queryTypeObject = FlowCompareQueryType.getInstance(flowCompareCondition);
        boolean isBiz = this.queryTypeObject instanceof FlowCompareQueryTypeWithBiz;
        List<Map<String, Object>> queryTablesPostfixList = this.queryUpgradeInfo(flowCompareCondition.getStartTime(), flowCompareCondition.getEndTime());
        ArrayList<FlowCompare> flowCompareList = new ArrayList<FlowCompare>();
        for (Map<String, Object> map : queryTablesPostfixList) {
            flowCompareCondition.setStartTime(Long.parseLong(String.valueOf(map.get("startTime"))));
            flowCompareCondition.setEndTime(Long.parseLong(String.valueOf(map.get("endTime"))));
            flowCompareCondition.setTablesPostfixList(String.valueOf(map.get("tablePostfix")));
            List<FlowCompare> tempflowCompareList = this.getFlowComparesByBiz(this.queryTypeObject, flowCompareCondition, isBiz);
            flowCompareList.addAll(tempflowCompareList);
        }
        if (!CollectorConstants.QUERY_TYPE_ONLY_DEVICE.equals(flowCompareCondition.getQueryType()) && null != sessionId && null != zoneIdList && !zoneIdList.isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(sessionId);
        }
        LOG.info((Object)"end queryFlowCompare");
        return flowCompareList;
    }

    private List<Map<String, Object>> queryUpgradeInfo(Long startTime, Long endTime) {
        HashMap<String, Object> map;
        ArrayList<Map<String, Object>> upgradeInfoList = new ArrayList<Map<String, Object>>();
        List<VersionUpgrade> versionUpgradeList = DBStat.getVersionUpgradeList();
        if (versionUpgradeList.isEmpty()) {
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("startTime", startTime);
            map2.put("endTime", endTime);
            map2.put("tablePostfix", "");
            upgradeInfoList.add(map2);
            return upgradeInfoList;
        }
        long statTimeTmp = startTime;
        for (VersionUpgrade versionInfo : versionUpgradeList) {
            if (statTimeTmp >= versionInfo.getUpTime()) continue;
            map = new HashMap();
            map.put("tablePostfix", versionInfo.getTablePostfix());
            map.put("startTime", statTimeTmp);
            if (endTime <= versionInfo.getUpTime()) {
                map.put("endTime", endTime);
                upgradeInfoList.add(map);
                return upgradeInfoList;
            }
            map.put("endTime", versionInfo.getUpTime());
            upgradeInfoList.add(map);
            statTimeTmp = versionInfo.getUpTime();
        }
        VersionUpgrade lastUpgrade = versionUpgradeList.get(versionUpgradeList.size() - 1);
        map = new HashMap<String, Object>();
        if (startTime >= lastUpgrade.getUpTime()) {
            map.put("startTime", startTime);
        } else {
            map.put("startTime", lastUpgrade.getUpTime());
        }
        map.put("endTime", endTime);
        map.put("tablePostfix", "");
        upgradeInfoList.add(map);
        return upgradeInfoList;
    }

    private List<FlowCompare> getFlowComparesByBiz(FlowCompareQueryType tempQueryTypeObject, FlowCompareCondition flowCompare, boolean isBiz) {
        ArrayList<FlowCompare> flowCompareList = new ArrayList();
        if (isBiz && null != flowCompare.getIsServiceGroup() && flowCompare.getIsServiceGroup().booleanValue()) {
            Map<String, List<Long>> serviceIdMap = flowCompare.getServiceIds();
            if (null != serviceIdMap && !serviceIdMap.isEmpty() && serviceIdMap.size() < 10000) {
                for (Map.Entry<String, List<Long>> serviceIdList : serviceIdMap.entrySet()) {
                    flowCompare.setBizType(Integer.parseInt(CollectorConstants.getBizStrToId().get(serviceIdList.getKey())));
                    flowCompareList.addAll(this.getFlowCompares(tempQueryTypeObject, flowCompare));
                }
            }
        } else if (isBiz && this.isaBoolean(flowCompare)) {
            flowCompare.setRequestOrReply("request");
            flowCompareList = this.getFlowCompares(tempQueryTypeObject, flowCompare);
            flowCompare.setRequestOrReply("reply");
            List<FlowCompare> replyFlowCompareList = this.getFlowCompares(tempQueryTypeObject, flowCompare);
            this.mergeFlowCompareList(flowCompareList, replyFlowCompareList);
        } else {
            flowCompareList = this.getFlowCompares(tempQueryTypeObject, flowCompare);
        }
        return flowCompareList;
    }

    private boolean isaBoolean(FlowCompareCondition flowCompare) {
        return Integer.parseInt("6") == flowCompare.getBizType() && flowCompare.isIsQueryRequestOrReply() || Integer.parseInt("0") == flowCompare.getBizType() && -4 == flowCompare.getBizId().intValue();
    }

    private void mergeFlowCompareList(List<FlowCompare> flowCompareList, List<FlowCompare> replyFlowCompareList) {
        for (FlowCompare tempRequest : flowCompareList) {
            for (FlowCompare tempReply : replyFlowCompareList) {
                if (!tempRequest.equals(tempReply)) continue;
                tempRequest.setReplyInFlow(tempReply.getInFlow());
                tempRequest.setReplyAttackFlow(tempReply.getAttackFlow());
                tempRequest.setReplyOutFlow(tempReply.getOutFlow());
                tempRequest.setReplyMaxInFlow(tempReply.getMaxInFlow());
                tempRequest.setReplyMaxAttackFlow(tempReply.getMaxAttackFlow());
                tempRequest.setReplyMaxOutFlow(tempReply.getMaxOutFlow());
                tempRequest.setReplyReboundFlow(tempReply.getReboundFlow());
            }
        }
    }

    private List<FlowCompare> getFlowCompares(FlowCompareQueryType flowQueryType, FlowCompareCondition flowCompare) {
        HashMap<Integer, Object> condition = new HashMap<Integer, Object>();
        String sql = flowQueryType.getFlowCompareSQL(flowCompare, condition);
        List<FlowCompare> tempFlowCompareList = this.flowCompareDao.getFlowCompare(sql, condition);
        return tempFlowCompareList;
    }
}

