/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.biz.report.CommomSqlUtil;
import com.hs.atic.collector.biz.report.ZoneSecurityTableUtil;
import com.hs.atic.collector.db.report.DBStat;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.entity.log.NormalAbnormalCondition;
import com.hs.atic.collector.entity.log.NormalAndExceptObject;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.NormalAndExceptService;
import com.hs.atic.rmi.ServerSocketFactory;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NormalAndExceptServiceImpl
extends UnicastRemoteObject
implements NormalAndExceptService {
    private static final Logger LOG = LogManager.getInstance().getReportLogger();
    private static final long serialVersionUID = 871960322054451005L;
    protected final DBStat dao = new DBStat();
    private Map<Integer, Object> map = new HashMap<Integer, Object>();

    public NormalAndExceptServiceImpl() throws RemoteException {
    }

    public NormalAndExceptServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    private void setIpToFormate(NormalAbnormalCondition normalAndExceptionCondition) {
        List<String> devIpList = normalAndExceptionCondition.getDeviceIpList();
        if (null != devIpList && !devIpList.isEmpty() && devIpList.size() < 10000) {
            ArrayList<String> tempDeviceList = new ArrayList<String>();
            for (String tempDeviceIp : devIpList) {
                if (!IpTransformer.checkIpInvaild(tempDeviceIp)) continue;
                String tempIpStr = IpTransformer.formatIpAddress(tempDeviceIp);
                tempDeviceList.add(tempIpStr);
            }
            normalAndExceptionCondition.getDeviceIpList().clear();
            normalAndExceptionCondition.setDeviceIpList(tempDeviceList);
        }
        if (IpTransformer.checkIpInvaild(normalAndExceptionCondition.getZoneIp())) {
            normalAndExceptionCondition.setZoneIp(IpTransformer.formatIpAddress(normalAndExceptionCondition.getZoneIp()));
        }
    }

    @Override
    public List<NormalAndExceptObject> queryNormalAndException(NormalAbnormalCondition normalAndExceptionCondition) {
        if (null == normalAndExceptionCondition) {
            LOG.error((Object)"input normalAndExceptionCondition is null.");
            return null;
        }
        LOG.info((Object)"start queryNormalAndException");
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        Long sessionId = normalAndExceptionCondition.getSessionId();
        List<Long> zoneIdList = normalAndExceptionCondition.getZoneIdList();
        if (null != sessionId && null != zoneIdList && !zoneIdList.isEmpty() && zoneIdList.size() < 10000) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(zoneIdList, sessionId);
        }
        this.setIpToFormate(normalAndExceptionCondition);
        String sql = this.generateSql(normalAndExceptionCondition);
        LOG.info((Object)("sql : " + normalAndExceptionCondition.toString()));
        List<NormalAndExceptObject> normalAndExceptinList = this.dao.queryNormalAndException(sql, this.map);
        LOG.info((Object)("query normalAndExceptinList, size = " + normalAndExceptinList.size()));
        if (null != sessionId && null != zoneIdList && !zoneIdList.isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(sessionId);
        }
        LOG.info((Object)"end queryNormalAndException");
        return normalAndExceptinList;
    }

    private String generateSql(NormalAbnormalCondition normalAndExceptionCondition) {
        LOG.info((Object)"begin to generate sql for normalAndException.");
        StringBuffer tableName = new StringBuffer();
        StringBuffer sql = new StringBuffer("select LOG_TIME, DEVICE_IP, TOTAL_PPS, ");
        sql.append("LARGE_PPS, ILEGAL_PPS, TTL_DENIED_PPS, ");
        sql.append("(CASE WHEN (TOTAL_PPS < LARGE_PPS + ILEGAL_PPS + TTL_DENIED_PPS) THEN 0 ELSE TOTAL_PPS - LARGE_PPS - ILEGAL_PPS - TTL_DENIED_PPS END) as NORMAL_PPS  from ");
        if (null != normalAndExceptionCondition.getZoneIp()) {
            tableName.append("ATIC_IP_BIZ_UDP_DNS");
        } else {
            tableName.append("ATIC_ZONE_BIZ_UDP_DNS");
        }
        this.appendByTimeSpanType(tableName, normalAndExceptionCondition);
        sql.append(tableName);
        this.appendWhere(sql, normalAndExceptionCondition, tableName.toString());
        LOG.info((Object)"generate sql for normalAndException successfully.");
        return sql.toString();
    }

    private void appendByTimeSpanType(StringBuffer sql, NormalAbnormalCondition normalAndExceptionCondition) {
        int timeSpanType = normalAndExceptionCondition.getTimeSpanType();
        if (timeSpanType == 1) {
            LOG.info((Object)"time is  between 1 and 7 days.");
            sql.append("_H");
        } else if (timeSpanType == 2) {
            LOG.info((Object)"time is more than 7 days.");
            sql.append("_D");
        }
    }

    private void appendWhere(StringBuffer sql, NormalAbnormalCondition normalAndExceptionCondition, String tableName) {
        sql.append(" where ");
        int num = 0;
        int index = 1;
        this.map = new HashMap<Integer, Object>();
        sql.append("DEVICE_IP in (");
        for (String deviceIp : normalAndExceptionCondition.getDeviceIpList()) {
            if (0 == num) {
                sql.append('?');
                this.map.put(index++, deviceIp);
            } else {
                sql.append(" , ? ");
                this.map.put(index++, deviceIp);
            }
            ++num;
        }
        sql.append(')');
        Long zoneId = normalAndExceptionCondition.getZoneId();
        if (zoneId != 0L) {
            sql.append(" and ZONE_ID =  ? ");
            this.map.put(index++, zoneId);
        } else if (null != normalAndExceptionCondition.getSessionId() && !normalAndExceptionCondition.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            this.map.put(index++, normalAndExceptionCondition.getSessionId());
        }
        Long startTime = normalAndExceptionCondition.getStartTime();
        sql.append(" and LOG_TIME >= ? ");
        this.map.put(index++, startTime);
        Long endTime = normalAndExceptionCondition.getEndTime();
        sql.append(" and LOG_TIME <= ? ");
        this.map.put(index++, endTime);
        String zoneIp = normalAndExceptionCondition.getZoneIp();
        if (!CommonUtil.isNull(zoneIp)) {
            sql.append(" and ZONE_IP = ? ");
            this.map.put(index++, zoneIp);
        }
        DataStatCondition cds = new DataStatCondition();
        cds.setBisId(normalAndExceptionCondition.getBizId());
        cds.setIsServiceGroup(normalAndExceptionCondition.getIsServiceGroup());
        cds.setServiceIds(normalAndExceptionCondition.getServiceIds());
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, sql);
        for (Object obj : list) {
            this.map.put(index++, obj);
        }
        Integer deviceType = normalAndExceptionCondition.getDeviceType();
        sql.append(" and DEVICE_TYPE = ? ");
        this.map.put(index, deviceType);
        sql.append(" order by LOG_TIME asc");
    }

    public Map<Integer, Object> getMap() {
        return this.map;
    }

    public void setMap(Map<Integer, Object> map) {
        this.map = map;
    }
}

