/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.util.BlackHoleNpCommandUtil;
import com.hs.atic.collector.util.FaultSeverityRuleUtil;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.NotifyFaultSeverityRuleService;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.sdk.bis.form.BlackholeNpForm;
import com.hs.atic.sdk.bis.form.ConfigBlackholeNpForm;
import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;

public class NotifyFaultSeverityRuleServiceImpl
extends UnicastRemoteObject
implements NotifyFaultSeverityRuleService {
    private static final long serialVersionUID = -208503769149878718L;

    public NotifyFaultSeverityRuleServiceImpl() throws RemoteException {
    }

    public NotifyFaultSeverityRuleServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    @Override
    public boolean notifySeverityRule(FaultSeverityRuleForm form) throws RemoteException {
        if (null == form) {
            return false;
        }
        return FaultSeverityRuleUtil.getInstance().saveFaultSeverityRule(form);
    }

    @Override
    public boolean batchNotifySeverityRule(List<FaultSeverityRuleForm> formList) throws RemoteException {
        if (null == formList || formList.isEmpty() || formList.size() > 10000) {
            return false;
        }
        return FaultSeverityRuleUtil.getInstance().saveAllFaultSeverityRules(formList);
    }

    @Override
    public boolean deleteSeverityRules(List<Long> zoneIdList) throws RemoteException {
        return FaultSeverityRuleUtil.getInstance().deleteSeverityRules(zoneIdList);
    }

    @Override
    public int getSlotBlackholeAlarmSeverity(String deviceIp, String zoneIp) {
        return FaultSeverityRuleUtil.getInstance().getSlotBlackholeAlarmSeverity(deviceIp, zoneIp);
    }

    @Override
    public boolean deleteBlackholeNP(String npIp) throws RemoteException {
        if (null == npIp) {
            return false;
        }
        return BlackHoleNpCommandUtil.getInstance().deleteBlackHoleNpByNpIp(npIp);
    }

    @Override
    public boolean bathSaveOrUpate(List<BlackholeNpForm> blackholeNpForms) throws RemoteException {
        if (null == blackholeNpForms || blackholeNpForms.isEmpty()) {
            return false;
        }
        return BlackHoleNpCommandUtil.getInstance().bathSaveOrUpate(blackholeNpForms);
    }

    @Override
    public boolean isBlackholeThresholdTransfinite(String deviceIp, String zoneIp, Integer threshold) throws RemoteException {
        return FaultSeverityRuleUtil.getInstance().isBlackholeThresholdTransfinite(deviceIp, zoneIp, threshold);
    }

    @Override
    public boolean deleteCollectorFailedBlackholeNP(List<String> npIps) throws RemoteException {
        return BlackHoleNpCommandUtil.getInstance().deleteBlackHoleNpByNpIps(npIps);
    }

    @Override
    public boolean saveAllConfigBlackholeNpData(List<BlackholeNpForm> blackholeNpForms) throws RemoteException {
        ArrayList<ConfigBlackholeNpForm> configBlackholeNpFormList = new ArrayList<ConfigBlackholeNpForm>();
        for (BlackholeNpForm blackholeNpForm : blackholeNpForms) {
            ConfigBlackholeNpForm configBlackholeNpForm = new ConfigBlackholeNpForm();
            configBlackholeNpForm.setNpIp(blackholeNpForm.getNpIp());
            configBlackholeNpForm.setTimeLong(blackholeNpForm.getTimeLong());
            configBlackholeNpForm.setBlackholeThreshold(blackholeNpForm.getBlackholeThreshold());
            configBlackholeNpFormList.add(configBlackholeNpForm);
        }
        return BlackHoleNpCommandUtil.getInstance().saveAllConfigBlackholeNpData(configBlackholeNpFormList);
    }
}

